import { z } from 'zod';
import { appRelationObjectSchema } from '#/types/shared/relationship.js';
const appUserObjectSchema = z.object({
    id: z.string(),
    avatarUrl: z.string(),
    displayName: z.string().nullable(),
    parsedDisplayName: z.array(z.any()),
    handle: z.string(),
    instance: z.string(),
    banner: z.string().nullable().optional(),
    meta: z.object({
        isProfileLocked: z.boolean(),
        isBot: z.boolean(),
        fields: z.array(z.object({
            name: z.string().optional(),
            value: z.string().optional(),
            verifiedAt: z.string().nullable().optional(),
            cid: z.string().optional(),
            cts: z.string().optional(),
            src: z.string().optional(),
            uri: z.string().optional(),
            val: z.string().optional(),
        })),
    }),
    description: z.string(),
    parsedDescription: z.array(z.any()),
    stats: z.object({
        posts: z.number().nullable(),
        followers: z.number().nullable(),
        following: z.number().nullable(),
    }),
    calculated: z.object({
        emojis: z.map(z.string(), z.string()),
    }),
    relationship: appRelationObjectSchema.nullable(),
});
export { appUserObjectSchema };
//# sourceMappingURL=user.js.map