import { z } from 'zod';
declare const appUserObjectSchema: z.ZodObject<{
    id: z.ZodString;
    avatarUrl: z.ZodString;
    displayName: z.ZodNullable<z.ZodString>;
    parsedDisplayName: z.ZodArray<z.ZodAny>;
    handle: z.ZodString;
    instance: z.ZodString;
    banner: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    meta: z.ZodObject<{
        isProfileLocked: z.ZodBoolean;
        isBot: z.ZodBoolean;
        fields: z.ZodArray<z.ZodObject<{
            name: z.ZodOptional<z.ZodString>;
            value: z.ZodOptional<z.ZodString>;
            verifiedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            cid: z.ZodOptional<z.ZodString>;
            cts: z.ZodOptional<z.ZodString>;
            src: z.ZodOptional<z.ZodString>;
            uri: z.ZodOptional<z.ZodString>;
            val: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
    }, z.core.$strip>;
    description: z.ZodString;
    parsedDescription: z.ZodArray<z.ZodAny>;
    stats: z.ZodObject<{
        posts: z.ZodNullable<z.ZodNumber>;
        followers: z.ZodNullable<z.ZodNumber>;
        following: z.ZodNullable<z.ZodNumber>;
    }, z.core.$strip>;
    calculated: z.ZodObject<{
        emojis: z.ZodMap<z.ZodString, z.ZodString>;
    }, z.core.$strip>;
    relationship: z.ZodNullable<z.ZodObject<{
        $type: z.ZodOptional<z.ZodLiteral<"app.bsky.actor.defs#viewerState">>;
        muting: z.ZodNullable<z.ZodBoolean>;
        blocking: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
        blockedBy: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
        following: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
        followedBy: z.ZodNullable<z.ZodUnion<readonly [z.ZodBoolean, z.ZodString]>>;
        showingReblogs: z.ZodNullable<z.ZodBoolean>;
        notifying: z.ZodNullable<z.ZodBoolean>;
        languages: z.ZodArray<z.ZodString>;
        mutingNotifications: z.ZodNullable<z.ZodBoolean>;
        requested: z.ZodNullable<z.ZodBoolean>;
        domainBlocking: z.ZodNullable<z.ZodBoolean>;
        endorsed: z.ZodNullable<z.ZodBoolean>;
        note: z.ZodNullable<z.ZodString>;
    }, z.core.$strip>>;
}, z.core.$strip>;
type UserObjectType = z.infer<typeof appUserObjectSchema>;
export { appUserObjectSchema };
export type { UserObjectType };
//# sourceMappingURL=user.d.ts.map