import { z } from 'zod';
import { postLinkAttachmentObjectSchema } from '#/types/shared/link-attachments.js';
const ActivityPubReactionStateSchema = z.array(z.object({
    id: z.string(),
    count: z.number().positive(),
    me: z.boolean(),
    accounts: z.array(z.string()),
    url: z.string().nullable().optional(),
}));
const ActivityPubBoostedByDto = z.object({
    id: z.string(),
    avatarUrl: z.string(),
    displayName: z.string().nullable().optional(),
    parsedDisplayName: z.array(z.any()),
    handle: z.string().regex(/^@.*?@?.*?$/),
    instance: z.string(),
});
const AppActivityPubMediaDto = z.object({
    url: z.string(),
    previewUrl: z.string().nullable().optional(),
    width: z.number().optional().nullable(), // bsky can be null
    height: z.number().optional().nullable(), // bsky can be null
    alt: z.string().nullable(),
    type: z.string(),
    blurhash: z.string().nullable(),
});
const AppPostStatsDto = z.object({
    replyCount: z.number().nonnegative(),
    boostCount: z.number().nonnegative(),
    likeCount: z.number().nonnegative(),
    quoteCount: z.number().nonnegative(),
    reactions: ActivityPubReactionStateSchema,
});
export const ActivityPubStatusItemDto = z.object({
    uuid: z.string(),
    id: z.string(),
    visibility: z.string(),
    createdAt: z.string(),
    postedBy: ActivityPubBoostedByDto,
    content: z.object({
        raw: z.string().nullable().optional(),
        parsed: z.array(z.any()),
        media: z.array(AppActivityPubMediaDto),
        links: z.array(postLinkAttachmentObjectSchema),
    }),
    interaction: z.object({
        boosted: z.boolean(),
        liked: z.boolean(),
        bookmarked: z.boolean(),
    }),
    stats: AppPostStatsDto,
    calculated: z.object({
        mediaContainerHeight: z.number(),
        emojis: z.map(z.string(), z.string()),
        translationOutput: z.string().optional(),
        translationType: z.string().optional(),
        reactionEmojis: z.array(z.object({
            height: z.number().nullable().optional(),
            width: z.number().nullable().optional(),
            name: z.string(),
            url: z.string().url(),
        })),
        mentions: z.array(z.object({
            id: z.string().optional().nullable(),
            text: z.string().optional(),
            url: z.string().nullable().optional(),
            username: z.string().optional().nullable(),
            acct: z.string().optional().nullable(),
        })),
        customEmojiCount: z.number().optional(),
    }),
    meta: z.object({
        sensitive: z.boolean(),
        cw: z.string().nullable(),
        isBoost: z.boolean(),
        isReply: z.boolean(),
        mentions: z.array(z.object({
            id: z.string(), // lazy loaded for misskey forks
            handle: z.string().optional(),
            url: z.string().optional(),
            acct: z.string().optional().nullable(),
            username: z.string().optional().nullable(),
        })),
        cid: z.string().nullable().optional(),
        uri: z.string().nullable().optional(),
    }),
    state: z.object({
        isBookmarkStateFinal: z.boolean(),
    }),
    atProto: z
        .object({
        viewer: z
            .object({
            like: z.string().nullable().optional(),
            embeddingDisabled: z.boolean().optional(),
            pinned: z.any().optional(),
            repost: z.any().optional(),
            replyDisabled: z.boolean().optional(),
            threadMuted: z.boolean().optional(),
        })
            .optional(),
    })
        .nullable()
        .optional(),
});
const ActivityPubStatusLevelTwo = ActivityPubStatusItemDto.extend({
    replyTo: ActivityPubStatusItemDto.nullable().optional(), // Misskey/Firefish natively supports quote boosting
    boostedFrom: ActivityPubStatusItemDto.nullable().optional(), // Pleroma feature
    quotedFrom: ActivityPubStatusItemDto.nullable().optional(),
});
const postObjectSchema = ActivityPubStatusLevelTwo.extend({
    replyTo: ActivityPubStatusLevelTwo.nullable().optional(), // Misskey/Firefish natively supports quote boosting
    boostedFrom: ActivityPubStatusLevelTwo.nullable().optional(), // Pleroma feature
    quotedFrom: ActivityPubStatusLevelTwo.nullable().optional(), // Bluesky feature
    rootPost: ActivityPubStatusItemDto.nullable().optional(),
});
const mentionObjectSchema = z.object({
    id: z.string(),
    handle: z.string().optional(),
    url: z.string().optional(),
    acct: z.string().optional().nullable(),
    username: z.string().optional().nullable(),
});
export { postObjectSchema };
//# sourceMappingURL=post.js.map