import { z } from 'zod';
declare const appMessageObjectSchema: z.ZodObject<{
    id: z.ZodString;
    senderId: z.ZodString;
    content: z.ZodObject<{
        raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    }, z.core.$strip>;
    embed: z.ZodNullable<z.ZodAny>;
    createdAt: z.ZodCoercedDate<unknown>;
    facets: z.ZodArray<z.ZodAny>;
    reactions: z.ZodArray<z.ZodObject<{
        value: z.ZodString;
        senderId: z.ZodString;
        createdAt: z.ZodCoercedDate<unknown>;
    }, z.core.$strip>>;
    deleted: z.ZodBoolean;
}, z.core.$strip>;
declare const appChatRoomObjectSchema: z.ZodObject<{
    id: z.ZodString;
    members: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        handle: z.ZodString;
        displayName: z.ZodOptional<z.ZodString>;
        avatar: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
    unreadCount: z.ZodNullable<z.ZodNumber>;
    muting: z.ZodBoolean;
    lastMessage: z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        senderId: z.ZodString;
        content: z.ZodObject<{
            raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>;
        embed: z.ZodNullable<z.ZodAny>;
        createdAt: z.ZodCoercedDate<unknown>;
        facets: z.ZodArray<z.ZodAny>;
        reactions: z.ZodArray<z.ZodObject<{
            value: z.ZodString;
            senderId: z.ZodString;
            createdAt: z.ZodCoercedDate<unknown>;
        }, z.core.$strip>>;
        deleted: z.ZodBoolean;
    }, z.core.$strip>>;
}, z.core.$strip>;
type MessageObjectType = z.infer<typeof appMessageObjectSchema>;
type ChatRoomObjectType = z.infer<typeof appChatRoomObjectSchema>;
export { appMessageObjectSchema, appChatRoomObjectSchema };
export type { MessageObjectType, ChatRoomObjectType };
//# sourceMappingURL=chat.d.ts.map