type ResultPage<T> = {
    data: T;
    maxId?: string | null;
    minId?: string | null;
    hitsTotal?: number;
};
declare const defaultResultPage: {
    data: never[];
    maxId: null;
    minId: null;
    hitsTotal: number;
};
export type { ResultPage };
export { defaultResultPage };
export declare enum ApiErrorCode {
    UNAUTHORIZED = "E_UNAUTHORIZED",
    INCOMPATIBLE_DRIVER = "E_INCOMPATIBLE_DRIVER",
    INSTANCE_SOFTWARE_DETECTION_FAILED = "INSTANCE_SOFTWARE_DETECTION_FAILED",
    DEFAULT_CLIENT = "E_DEFAULT_CLIENT",
    FEATURE_UNSUPPORTED = "E_FEATURE_UNSUPPORTED",
    UNKNOWN_ERROR = "E_UNKNOWN_ERROR",
    OPERATION_UNSUPPORTED = "E_OPERATION_UNSUPPORTED",
    REMOTE_SERVER_ERROR = "E_REMOTE_SERVER_ERROR",
    INVALID_INPUT = "E_INVALID_INPUT",
    PARSING_FAILED = "E_PARSING_FAILED"
}
export declare function errorBuilder<T>(error?: any): any;
export declare function notImplementedErrorBuilder<T>(): any;
export type PaginatedPromise<T> = Promise<{
    data: T;
    minId?: string | null;
    maxId?: string | null;
    hitsTotal?: number;
}>;
//# sourceMappingURL=api-response.d.ts.map