import { KNOWN_SOFTWARE } from '../client/utils/driver.js';
import { DriverService } from './driver.js';
class ActivitypubHelper {
    static removeURLPrefixes(link) {
        let cleanedLink = link.replace(/^https?:\/\//, '');
        cleanedLink = cleanedLink.replace(/^www\./, '');
        return cleanedLink;
    }
    static getHandle(url, myDomain, driver) {
        if (DriverService.supportsAtProto(driver || KNOWN_SOFTWARE.UNKNOWN))
            return url;
        const ex = /^https?:\/\/(.*?)\/(.*?)/;
        const subdomainExtractUrl = /^https?:\/\/(.*?)\/?/;
        const usernameExtract = /^https?:\/\/(.*?)\/@?(.*?)$/;
        const bridged = /^https?:\/\/(.*?)\/r\/(https?:\/\/)?(.*?)\/?$/;
        const pleromaUsernameExtract = /https:\/\/(.*?)\/users\/(.*?)$/;
        const lemmyUsernameExtract = /https:\/\/(.*?)\/u\/(.*?)$/;
        let ourUrl = '';
        let theirUsername = '';
        let theirUrl = '';
        if (ex.test(myDomain)) {
            ourUrl = myDomain.match(subdomainExtractUrl)[1];
        }
        else {
            ourUrl = myDomain;
        }
        if (pleromaUsernameExtract.test(url)) {
            const x = url.match(pleromaUsernameExtract);
            theirUrl = x[1];
            theirUsername = x[2];
        }
        else if (lemmyUsernameExtract.test(url)) {
            const x = url.match(lemmyUsernameExtract);
            theirUrl = x[1];
            theirUsername = x[2];
        }
        else if (usernameExtract.test(url)) {
            const x = url.match(usernameExtract);
            theirUrl = x[1];
            theirUsername = x[2];
        }
        if (theirUsername === '') {
            if (bridged.test(url)) {
                const x = url.match(bridged);
                const bridge = x[1];
                const web = x[3];
                return `${this.removeURLPrefixes(web)} (via ${bridge})`;
            }
            return '<invalid>';
        }
        return ourUrl === theirUrl
            ? `@${theirUsername}`
            : `@${theirUsername}@${theirUrl}`;
    }
    static convertInstanceUrlHttps(url) {
        if (!/^https?:\/\//i.test(url)) {
            url = 'https://' + url;
        }
        return url;
    }
    static getInstanceUrlFromHandle(input, myDomain) {
        const sameServerUser = /^@([a-zA-Z_0-9]+)$/;
        if (sameServerUser.test(input)) {
            return this.convertInstanceUrlHttps(myDomain);
        }
        const remoteHandleRegex = /^@([a-zA-Z_0-9]+)@([a-zA-Z_0-9.]+)$/;
        if (remoteHandleRegex.test(input)) {
            const match = remoteHandleRegex.exec(input);
            if (!match)
                return null;
            const retval = this.convertInstanceUrlHttps(match[2]);
            return this.convertInstanceUrlHttps(retval);
        }
        return '';
    }
    static splitHandle(handle, server) {
        const splits = handle.split('@');
        if (splits.length === 3) {
            return {
                username: splits[1],
                host: server === splits[2] ? null : splits[1],
                handle,
            };
        }
        else if (splits.length === 2) {
            return {
                username: splits[1],
                host: null,
                handle,
            };
        }
    }
}
export default ActivitypubHelper;
//# sourceMappingURL=activitypub.js.map