import { Dispatch, SetStateAction } from 'react';
import { z } from 'zod';
import { ApiTargetInterface } from '../client/index.js';
import { CustomEmojiObjectType } from '#/types/shared/reactions.js';
declare const activityPubReactionItemSchema: z.ZodObject<{
    id: z.ZodString;
    count: z.ZodNumber;
    me: z.ZodBoolean;
    accounts: z.ZodArray<z.ZodString>;
    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.core.$strip>;
type ActivityPubReactionItemType = z.infer<typeof activityPubReactionItemSchema>;
declare const ActivityPubReactionStateSchema: z.ZodArray<z.ZodObject<{
    id: z.ZodString;
    count: z.ZodNumber;
    me: z.ZodBoolean;
    accounts: z.ZodArray<z.ZodString>;
    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.core.$strip>>;
type ActivityPubReactionStateType = z.infer<typeof ActivityPubReactionStateSchema>;
type DriverReactionResolvedType = {
    count: number;
    url?: string;
    name: string;
    type: 'text' | 'image';
    height?: number;
    width?: number;
    interactable: boolean;
    me: boolean;
};
declare class ActivityPubReactionsService {
    static extractReactionCode(input: string, domain: string, subdomain: string): {
        id: string;
    };
    static cannotReact(id: string): boolean;
    static renderData(input: ActivityPubReactionStateType, { me, calculated, cache }: {
        calculated: {
            url?: string;
            width?: number;
            height?: number;
            name?: string;
        }[];
        cache: CustomEmojiObjectType[];
        me: string;
    }): DriverReactionResolvedType[];
    static removeReaction(client: ApiTargetInterface, postId: string, reactionId: string, domain: string, setLoading: (val: boolean) => void): Promise<any>;
    private static syncMisskeyReactionState;
    static addReaction(client: ApiTargetInterface, postId: string, reactionId: string, domain: string, setLoading: Dispatch<SetStateAction<boolean>>): Promise<ActivityPubReactionStateType>;
}
export { activityPubReactionItemSchema, ActivityPubReactionStateSchema };
export type { ActivityPubReactionStateType, ActivityPubReactionItemType };
export default ActivityPubReactionsService;
//# sourceMappingURL=activitypub-reactions.service.d.ts.map