function recursive(node) {
    if (!node)
        return 0;
    if (Array.isArray(node)) {
        return node.reduce((sum, item) => sum + recursive(item), 0);
    }
    let count = 0;
    if (['para', 'bold', 'italic', 'inline'].includes(node.type)) {
        count += node.nodes.reduce((sum, item) => sum + recursive(item), 0);
    }
    else if (node.type === 'customEmoji') {
        count += 1;
    }
    return count;
}
function _implementation(post) {
    const source = post.content.parsed;
    console.log(post.id, recursive(source));
    return {
        ...post,
        calculated: {
            ...post.calculated,
            customEmojiCount: recursive(source),
        },
    };
}
export function countEmojisInBodyContent(input) {
    if (Array.isArray(input))
        return input.map(_implementation);
    return _implementation(input);
}
//# sourceMappingURL=post-process.js.map