import { TextNodeParser } from './text-nodes.js';
import { ActivityPubUserAdapter, } from '../implementors/profile/_interface.js';
import { ActivitypubHelper, DriverService, } from '../index.js';
import { appUserObjectSchema } from '#/types/shared/user.js';
export const APP_USER_DEFAULT_RELATIONSHIP = {
    blocking: null,
    blockedBy: null,
    domainBlocking: null,
    followedBy: null,
    following: null,
    muting: null,
    mutingNotifications: null,
    note: null,
    requested: null,
    requestedBy: null,
    showingReblogs: null,
};
class Parser {
    static rawToInterface(input, driver) {
        if (Array.isArray(input)) {
            return input
                .filter((o) => !!o)
                .map((o) => ActivityPubUserAdapter(o, driver));
        }
        else {
            return ActivityPubUserAdapter(input, driver);
        }
    }
    static interfaceToJson(input, { driver, server, }) {
        if (!input || !input.getId())
            return null;
        let relation = null;
        if (DriverService.supportsAtProto(driver)) {
            const _input = input;
            relation = {
                muting: _input.ref.viewer?.muted ?? null,
                blocking: _input.ref.viewer?.blocking ?? null,
                blockedBy: _input.ref.viewer?.blockedBy ?? null,
                following: _input.ref.viewer?.following ?? null,
                followedBy: _input.ref.viewer?.followedBy ?? null,
                showingReblogs: null,
                notifying: null,
                languages: [],
                mutingNotifications: null,
                requested: false,
                domainBlocking: false,
                endorsed: false,
                note: null,
            };
        }
        const dto = {
            id: input.getId(),
            displayName: input.getDisplayName() || '',
            parsedDisplayName: TextNodeParser.parse(driver, input.getDisplayName() || ''),
            description: input.getDescription() || '',
            parsedDescription: TextNodeParser.parse(driver, input.getDescription() || ''),
            avatarUrl: input.getAvatarUrl() || '',
            banner: input.getBannerUrl(),
            handle: ActivitypubHelper.getHandle(input?.getAccountUrl(server), server, driver),
            instance: input.getInstanceUrl() || server,
            stats: {
                posts: input.getPostCount() || 0,
                followers: input.getFollowersCount() || 0,
                following: input.getFollowingCount() || 0,
            },
            meta: {
                isBot: input.getIsBot() || false,
                isProfileLocked: input.getIsLockedProfile() || false,
                fields: input.getFields() || [],
            },
            calculated: {
                emojis: input.getEmojiMap(),
            },
            relationship: relation,
        };
        const { data, error, success } = appUserObjectSchema.safeParse(dto);
        if (!success) {
            console.log('[ERROR]: user dto validation failed', error);
            return null;
        }
        return data;
    }
    static parse(input, driver, server) {
        if (Array.isArray(input)) {
            return input
                .map((o) => Parser.rawToInterface(o, driver))
                .map((o) => Parser.interfaceToJson(o, {
                driver,
                server,
            }))
                .filter((o) => !!o);
        }
        else {
            return Parser.interfaceToJson(Parser.rawToInterface(input, driver), {
                driver,
                server,
            });
        }
    }
}
export { Parser as UserParser };
//# sourceMappingURL=user.js.map