import { KNOWN_SOFTWARE } from '../client/utils/driver.js';
import { UserTargetInterface } from '../implementors/profile/_interface.js';
import { UserObjectType } from '#/types/shared/user.js';
export declare const APP_USER_DEFAULT_RELATIONSHIP: {
    blocking: null;
    blockedBy: null;
    domainBlocking: null;
    followedBy: null;
    following: null;
    muting: null;
    mutingNotifications: null;
    note: null;
    requested: null;
    requestedBy: null;
    showingReblogs: null;
};
declare class Parser {
    static rawToInterface<T>(input: T | T[], driver: string | KNOWN_SOFTWARE): T extends unknown[] ? UserTargetInterface[] : UserTargetInterface;
    static interfaceToJson(input: UserTargetInterface, { driver, server }: {
        driver: KNOWN_SOFTWARE | string;
        server: string;
    }): {
        id: string;
        avatarUrl: string;
        displayName: string | null;
        parsedDisplayName: any[];
        handle: string;
        instance: string;
        banner?: string | null | undefined;
        meta: {
            isProfileLocked: boolean;
            isBot: boolean;
            fields: {
                name?: string | undefined;
                value?: string | undefined;
                verifiedAt?: string | null | undefined;
                cid?: string | undefined;
                cts?: string | undefined;
                src?: string | undefined;
                uri?: string | undefined;
                val?: string | undefined;
            }[];
        };
        description: string;
        parsedDescription: any[];
        stats: {
            posts: number | null;
            followers: number | null;
            following: number | null;
        };
        calculated: {
            emojis: Map<string, string>;
        };
        relationship: {
            $type?: "app.bsky.actor.defs#viewerState" | undefined;
            muting: boolean | null;
            blocking: string | boolean | null;
            blockedBy: string | boolean | null;
            following: string | boolean | null;
            followedBy: string | boolean | null;
            showingReblogs: boolean | null;
            notifying: boolean | null;
            languages: string[];
            mutingNotifications: boolean | null;
            requested: boolean | null;
            domainBlocking: boolean | null;
            endorsed: boolean | null;
            note: string | null;
        } | null;
    } | null;
    static parse<T>(input: T | T[], driver: string | KNOWN_SOFTWARE, server: string): T extends unknown[] ? UserObjectType[] : UserObjectType;
}
export { Parser as UserParser };
//# sourceMappingURL=user.d.ts.map