import { PostTargetInterface } from '../implementors/index.js';
import { KNOWN_SOFTWARE } from '../client/utils/driver.js';
import { DriverUserFindQueryType } from '../index.js';
import { PostMentionObjectType, PostObjectType } from '#/types/shared/post.js';
declare class Parser {
    private static _export;
    static rawToInterface<T>(input: T | T[], driver: string | KNOWN_SOFTWARE): T extends unknown[] ? PostTargetInterface[] : PostTargetInterface;
    static interfaceToJson(input: PostTargetInterface, { driver, server }: {
        driver: KNOWN_SOFTWARE | string;
        server: string;
    }): PostObjectType | null;
    static parse<T>(input: T | T[], driver: string | KNOWN_SOFTWARE, server: string): T extends unknown[] ? PostObjectType[] : PostObjectType | null;
}
declare class Inspector {
    static getContentTarget(input: PostObjectType): PostObjectType;
    static isQuoteObject(input: PostObjectType): string | boolean;
    static isLiked(input: PostObjectType): boolean;
    static isShared(input: PostObjectType): boolean;
    static isBookmarked(input: PostObjectType): boolean;
}
declare class Resolver {
    static mentionItemsToWebfinger(handle: string, items: PostMentionObjectType[]): DriverUserFindQueryType | null;
}
export { Parser as PostParser, Inspector as PostInspector, Resolver as PostResolver, };
//# sourceMappingURL=post.d.ts.map