import { KNOWN_SOFTWARE } from '#/client/utils/driver.js';
import { appMessageObjectSchema } from '#/types/shared/chat.js';
class Parser {
    static _bundle(input, client) {
        if (!input)
            return null;
        if (client.driver !== KNOWN_SOFTWARE.BLUESKY)
            return null;
        if (input.$type === 'chat.bsky.convo.defs#deletedMessageView') {
            return {
                id: input.id,
                deleted: true,
                senderId: input.sender.did,
                content: {
                    raw: input.text ?? null,
                },
                embed: null,
                createdAt: new Date(input.sentAt),
                facets: [],
                reactions: [],
            };
        }
        else if (input.$type === 'chat.bsky.convo.defs#messageView') {
            return {
                id: input.id,
                deleted: false,
                senderId: input.sender.did,
                content: {
                    raw: input.text,
                },
                embed: input.embed,
                createdAt: new Date(input.sentAt),
                facets: input.facets ?? [],
                reactions: input.reactions?.map((o) => ({
                    value: o.value,
                    senderId: o.sender?.did,
                    createdAt: new Date(o.createdAt),
                })) ?? [],
            };
        }
        else {
            return {
                id: input.id,
                deleted: false,
                senderId: input.sender.did,
                content: {
                    raw: input.text,
                },
                embed: input.embed, // not tested
                createdAt: new Date(input.sentAt),
                facets: input.facets ?? [],
                reactions: input.reactions?.map((o) => ({
                    value: o.value,
                    senderId: o.sender?.did,
                    createdAt: new Date(o.createdAt),
                })) ?? [],
            };
        }
    }
    static rawToJson(input, client) {
        if (!input)
            return null;
        if (client.driver !== KNOWN_SOFTWARE.BLUESKY)
            return null;
        const exported = Parser._bundle(input, client);
        const { data, error, success } = appMessageObjectSchema.safeParse(exported);
        if (!success) {
            console.log('[ERROR]: failed to parse message object:', error);
            return null;
        }
        return data;
    }
    static parse(input, client) {
        if (Array.isArray(input)) {
            return input
                .filter((o) => !!o)
                .map((o) => Parser.rawToJson(o, client));
        }
        else {
            return Parser.rawToJson(input, client);
        }
    }
}
export { Parser as MessageParser };
//# sourceMappingURL=message.js.map