import { UserParser } from './user.js';
import { KNOWN_SOFTWARE } from '../client/utils/driver.js';
import { feedObjectSchema } from '#/types/shared/feed.js';
class Parser {
    static rawToObject(input, driver, server) {
        if (driver !== KNOWN_SOFTWARE.BLUESKY)
            return null;
        const _input = input;
        const dto = {
            uri: _input.uri,
            cid: _input.cid,
            did: _input.did,
            creator: UserParser.parse(_input.creator, driver, server),
            displayName: _input.displayName,
            description: _input.description,
            avatar: _input.avatar,
            likeCount: _input.likeCount,
            labels: _input.labels,
            viewer: {
                like: _input.viewer?.like,
            },
            indexedAt: new Date(_input.indexedAt),
            saved: null,
            pinned: null,
        };
        const { data, error, success } = feedObjectSchema.safeParse(dto);
        if (!success) {
            console.log('[ERROR]: feed dto validation failed', error);
            return null;
        }
        return data;
    }
    static parse(input, driver, server) {
        if (Array.isArray(input)) {
            return input
                .map((o) => Parser.rawToObject(o, driver, server))
                .filter((o) => !!o);
        }
        else {
            return Parser.rawToObject(input, driver, server);
        }
    }
}
export { Parser as FeedParser };
//# sourceMappingURL=feed.js.map