import { KNOWN_SOFTWARE } from '../client/utils/driver.js';
import { appChatRoomObjectSchema, } from '#/types/shared/chat.js';
import { MessageParser } from '#/parsers/message.js';
class Parser {
    static _bundle(input, client) {
        if (!input)
            return null;
        if (client.driver !== KNOWN_SOFTWARE.BLUESKY)
            return null;
        return {
            id: input.id,
            members: input.members.map((o) => ({
                id: o.did,
                handle: o.handle,
                displayName: o.displayName,
                avatar: o.avatar,
            })),
            unreadCount: input.unreadCount,
            muting: input.muted,
            lastMessage: MessageParser.parse(input.lastMessage, client),
        };
    }
    static rawToJson(input, client) {
        if (!input)
            return null;
        if (client.driver !== KNOWN_SOFTWARE.BLUESKY)
            return null;
        const exported = Parser._bundle(input, client);
        const { data, error, success } = appChatRoomObjectSchema.safeParse(exported);
        if (!success) {
            console.log('[ERROR]: status item dto validation failed', error);
            return null;
        }
        return data;
    }
    static parse(input, client) {
        if (Array.isArray(input)) {
            return input
                .filter((o) => !!o)
                .map((o) => Parser.rawToJson(o, client));
        }
        else {
            return Parser.rawToJson(input, client);
        }
    }
}
export { Parser as ChatParser };
//# sourceMappingURL=chat.js.map