import { EmbedViewProcessor_External_2, EmbedViewProcessor_ImagesView, EmbedViewProcessor_RecordWithMedia, EmbedViewProcessor_Video, LinkEmbedProcessor_External, } from '../media-attachment/bluesky.js';
import { AppBskyRichtextFacet, } from '@atproto/api';
class AtprotoPostAdapter {
    post;
    reply;
    reason;
    constructor({ post, reply, reason, }) {
        this.post = post;
        this.reply = reply;
        this.reason = reason;
    }
    getCid = () => this.post.cid;
    getUri = () => this.post.uri;
    getLikeUri = () => this.post.viewer?.like;
    getEmbeddingDisabled = () => this.post.viewer?.embeddingDisabled;
    getPinUri = () => this.post.viewer?.pinned;
    getRepostUri = () => this.post.viewer?.repost;
    getReplyDisabled = () => this.post.viewer?.replyDisabled;
    getThreadMuted = () => this.post.viewer?.threadMuted;
    getViewer = () => this.post.viewer;
    hasQuoteAvailable() {
        return this.isQuote();
    }
    getQuoteRaw() {
        return this.post.embed.record;
    }
    getRaw = () => this.post;
    getId = () => this.post?.uri;
    getUsername = () => this.post?.author?.handle;
    getDisplayName = () => this.post?.author?.displayName;
    getAvatarUrl = () => this.post?.author?.avatar;
    getCreatedAt = () => {
        if (this.isShare())
            return this.reason?.indexedAt;
        return this.post.record?.createdAt || this.post.indexedAt;
    };
    getVisibility() {
        return 'public';
    }
    getAccountUrl(mySubdomain) {
        return `https://bsky.app/profile/${this.post?.author?.handle}`;
    }
    getRepostedStatus() {
        if (this.isShare()) {
            const { post, ...rest } = this;
            return new AtprotoPostAdapter({
                post: this.post,
                reason: null,
                reply: null,
            });
        }
        else if (this.isQuote()) {
            if (this.post.embed?.$type === 'app.bsky.embed.recordWithMedia#view') {
                const _embed = this.post.embed;
                return new AtprotoPostAdapter({
                    post: _embed.record.record,
                    reason: null,
                    reply: null,
                });
            }
            else {
                return new AtprotoPostAdapter({
                    post: this.post.embed?.record,
                    reason: null,
                    reply: null,
                });
            }
        }
        return null;
    }
    getRepostedStatusRaw() {
        if (this.isShare()) {
            return { post: this.post };
        }
        if (this.isQuote()) {
            switch (this.post.embed.$type) {
                case 'app.bsky.embed.recordWithMedia#view': {
                    const _embed = this.post.embed;
                    return { post: _embed.record.record };
                }
                case 'app.bsky.embed.record#view': {
                    const _embed = this.post.embed;
                    return { post: _embed.record };
                }
                default:
                    return null;
            }
        }
        return null;
    }
    hasParentAvailable = () => !!this.reply?.parent;
    getParentRaw = () => this.reply?.parent;
    hasRootAvailable = () => !!this.reply?.root;
    getRootRaw = () => this.reply?.root;
    getContent() {
        if (this.isShare())
            return null;
        return (this.post?.record?.text ||
            this.post?.value?.text);
    }
    getFacets() {
        if (this.isShare())
            return [];
        return this.post?.record?.facets || [];
    }
    getUser() {
        if (this.isShare())
            return this.reason.by;
        return this.post.author;
    }
    isQuote = () => this.post.embed !== undefined &&
        (this.post.embed.$type === 'app.bsky.embed.record#view' ||
            this.post.embed.$type === 'app.bsky.embed.recordWithMedia#view');
    isShare = () => this.reason?.$type === 'app.bsky.feed.defs#reasonRepost';
    isReposted = () => this.isShare() || this.isQuote();
    getMediaAttachments() {
        if (this.reason?.$type === 'app.bsky.feed.defs#reasonRepost') {
            return [];
        }
        if (this.post.embed) {
            switch (this.post.embed.$type) {
                case 'app.bsky.embed.external#view': {
                    return [];
                }
                case 'app.bsky.embed.external': {
                    if (EmbedViewProcessor_External_2.isCompatible(this.post.embed))
                        return EmbedViewProcessor_External_2.compile(this.post.embed);
                    else
                        return [];
                }
                case 'app.bsky.embed.images': {
                    console.log("[WARN]: app.bsky.embed.images' type not handled!");
                    return [];
                }
                case 'app.bsky.embed.images#view': {
                    if (EmbedViewProcessor_ImagesView.isCompatible(this.post.embed))
                        return EmbedViewProcessor_ImagesView.compile(this.post.embed);
                    else
                        return [];
                }
                case 'app.bsky.embed.recordWithMedia#view': {
                    if (EmbedViewProcessor_RecordWithMedia.isCompatible(this.post.embed))
                        return EmbedViewProcessor_RecordWithMedia.compile(this.post.embed);
                    else
                        return [];
                }
                case 'app.bsky.embed.video#view': {
                    if (EmbedViewProcessor_Video.isCompatible(this.post.embed))
                        return EmbedViewProcessor_Video.compile(this.post.embed);
                    else
                        return [];
                }
                case 'app.bsky.embed.record#view': {
                    return [];
                }
                default: {
                    console.log('[WARN]: this.post.embed type not handled!', this.post.embed);
                }
            }
        }
        return [];
    }
    getLinkAttachments() {
        if (this.post.embed) {
            switch (this.post.embed.$type) {
                case 'app.bsky.embed.external#view': {
                    if (LinkEmbedProcessor_External.isCompatible(this.post.embed))
                        return LinkEmbedProcessor_External.compile(this.post.embed);
                    else
                        return [];
                }
                default: {
                    return [];
                }
            }
        }
        return [];
    }
    getMentions() {
        const facets = this.post?.record?.facets;
        if (facets) {
            facets
                .filter((o) => o.features.every(AppBskyRichtextFacet.isMention))
                .map((o) => ({ id: o.features[0].did }));
        }
        return [];
    }
    print() {
        console.log(this.post);
    }
    getIsRebloggedByMe = () => this.post.viewer?.repost !== undefined;
    getIsFavourited = () => false;
    getRepostsCount = () => this.post?.repostCount || 0;
    getRepliesCount = () => this.post?.replyCount || 0;
    getFavouritesCount = () => this.post?.likeCount || 0;
    getQuotesCount = () => this.post?.quoteCount || 0;
    getQuoteCount = () => this.post?.quoteCount || 0;
    getAccountId_Poster() {
        throw new Error('Method not implemented.');
    }
    isValid = () => true;
    isReply = () => !!this.reply;
    getParentStatusId() {
        return this.post.record.reply?.parent?.uri ?? null;
    }
    getUserIdParentStatusUserId() {
        return null;
    }
    getIsSensitive = () => false;
    getSpoilerText = () => null;
    setDescendents = (items) => [];
    getDescendants = () => [];
    getReactions = () => [];
    getCachedEmojis = () => new Map();
    getReactionEmojis = () => [];
    getMyReaction = () => null;
    getQuote = () => null;
    getIsBookmarked = () => this.getViewer()?.bookmarked ?? false;
}
export default AtprotoPostAdapter;
//# sourceMappingURL=bluesky.js.map