import { MediaAttachmentTargetInterface } from '../media-attachment/_interface.js';
import { DhaagaJsMentionObject, PostTargetInterface } from './_interface.js';
import { AppBskyFeedDefs } from '@atproto/api';
import { PostLinkAttachmentObjectType } from '#/types/shared/link-attachments.js';
declare class AtprotoPostAdapter implements PostTargetInterface {
    post: AppBskyFeedDefs.PostView;
    reply: any;
    reason: any;
    constructor({ post, reply, reason }: {
        post: any;
        reply: any;
        reason: any;
    });
    getCid: () => string;
    getUri: () => string;
    getLikeUri: () => string | undefined;
    getEmbeddingDisabled: () => boolean | undefined;
    getPinUri: () => boolean | undefined;
    getRepostUri: () => string | undefined;
    getReplyDisabled: () => boolean | undefined;
    getThreadMuted: () => boolean | undefined;
    getViewer: () => AppBskyFeedDefs.ViewerState | undefined;
    hasQuoteAvailable(): boolean;
    getQuoteRaw(): null | undefined;
    getRaw: () => AppBskyFeedDefs.PostView;
    getId: () => string;
    getUsername: () => string;
    getDisplayName: () => string | undefined;
    getAvatarUrl: () => string | undefined;
    getCreatedAt: () => any;
    getVisibility(): string;
    getAccountUrl(mySubdomain?: string | undefined): string | null | undefined;
    getRepostedStatus(): PostTargetInterface | null | undefined;
    getRepostedStatusRaw(): any;
    hasParentAvailable: () => boolean;
    getParentRaw: () => any;
    hasRootAvailable: () => boolean;
    getRootRaw: () => any;
    getContent(): any;
    getFacets(): any;
    getUser(): any;
    isQuote: () => boolean;
    isShare: () => boolean;
    isReposted: () => boolean;
    getMediaAttachments(): MediaAttachmentTargetInterface[];
    getLinkAttachments(): PostLinkAttachmentObjectType[];
    getMentions(): DhaagaJsMentionObject[];
    print(): void;
    getIsRebloggedByMe: () => boolean;
    getIsFavourited: () => boolean;
    getRepostsCount: () => number;
    getRepliesCount: () => number;
    getFavouritesCount: () => number;
    getQuotesCount: () => number;
    getQuoteCount: () => number;
    getAccountId_Poster(): string;
    isValid: () => boolean;
    isReply: () => boolean;
    getParentStatusId(): string | null | undefined;
    getUserIdParentStatusUserId(): string | null | undefined;
    getIsSensitive: () => boolean;
    getSpoilerText: () => null;
    setDescendents: (items: PostTargetInterface[]) => never[];
    getDescendants: () => never[];
    getReactions: () => never[];
    getCachedEmojis: () => Map<string, string>;
    getReactionEmojis: () => never[];
    getMyReaction: () => null;
    getQuote: () => null;
    getIsBookmarked: () => boolean;
}
export default AtprotoPostAdapter;
//# sourceMappingURL=bluesky.d.ts.map