import { UserDetailedInstance, UserTargetInterface } from './_interface.js';
export declare class MisskeyUser implements UserTargetInterface {
    ref: UserDetailedInstance;
    constructor(ref: UserDetailedInstance);
    getPinnedNotes: () => {
        id: string;
        createdAt: string;
        deletedAt?: string | null | undefined;
        text: string | null;
        cw?: string | null | undefined;
        userId: string;
        user: {
            id: string;
            name: string | null;
            username: string;
            host: string | null;
            avatarUrl: string;
            avatarBlurhash: string | null;
            avatarDecorations: {
                id: string;
                angle?: number | undefined;
                flipH?: boolean | undefined;
                url: string;
                offsetX?: number | undefined;
                offsetY?: number | undefined;
            }[];
            isBot?: boolean | undefined;
            isCat?: boolean | undefined;
            requireSigninToViewContents?: boolean | undefined;
            makeNotesFollowersOnlyBefore?: number | null | undefined;
            makeNotesHiddenBefore?: number | null | undefined;
            instance?: {
                name: string | null;
                softwareName: string | null;
                softwareVersion: string | null;
                iconUrl: string | null;
                faviconUrl: string | null;
                themeColor: string | null;
            } | undefined;
            emojis: {
                [key: string]: string;
            };
            onlineStatus: "active" | "offline" | "online" | "unknown";
            badgeRoles?: {
                name: string;
                iconUrl: string | null;
                displayOrder: number;
            }[] | undefined;
        };
        replyId?: string | null | undefined;
        renoteId?: string | null | undefined;
        reply?: any | null | undefined;
        renote?: any | null | undefined;
        isHidden?: boolean | undefined;
        visibility: "followers" | "home" | "public" | "specified";
        mentions?: string[] | undefined;
        visibleUserIds?: string[] | undefined;
        fileIds?: string[] | undefined;
        files?: {
            id: string;
            createdAt: string;
            name: string;
            type: string;
            md5: string;
            size: number;
            isSensitive: boolean;
            blurhash: string | null;
            properties: {
                width?: number | undefined;
                height?: number | undefined;
                orientation?: number | undefined;
                avgColor?: string | undefined;
            };
            url: string;
            thumbnailUrl: string | null;
            comment: string | null;
            folderId: string | null;
            folder?: {
                id: string;
                createdAt: string;
                name: string;
                parentId: string | null;
                foldersCount?: number | undefined;
                filesCount?: number | undefined;
                parent?: any | null | undefined;
            } | null | undefined;
            userId: string | null;
            user?: {
                id: string;
                name: string | null;
                username: string;
                host: string | null;
                avatarUrl: string;
                avatarBlurhash: string | null;
                avatarDecorations: {
                    id: string;
                    angle?: number | undefined;
                    flipH?: boolean | undefined;
                    url: string;
                    offsetX?: number | undefined;
                    offsetY?: number | undefined;
                }[];
                isBot?: boolean | undefined;
                isCat?: boolean | undefined;
                requireSigninToViewContents?: boolean | undefined;
                makeNotesFollowersOnlyBefore?: number | null | undefined;
                makeNotesHiddenBefore?: number | null | undefined;
                instance?: {
                    name: string | null;
                    softwareName: string | null;
                    softwareVersion: string | null;
                    iconUrl: string | null;
                    faviconUrl: string | null;
                    themeColor: string | null;
                } | undefined;
                emojis: {
                    [key: string]: string;
                };
                onlineStatus: "active" | "offline" | "online" | "unknown";
                badgeRoles?: {
                    name: string;
                    iconUrl: string | null;
                    displayOrder: number;
                }[] | undefined;
            } | null | undefined;
        }[] | undefined;
        tags?: string[] | undefined;
        poll?: {
            expiresAt?: string | null | undefined;
            multiple: boolean;
            choices: {
                isVoted: boolean;
                text: string;
                votes: number;
            }[];
        } | null | undefined;
        emojis?: {
            [key: string]: string;
        } | undefined;
        channelId?: string | null | undefined;
        channel?: {
            id: string;
            name: string;
            color: string;
            isSensitive: boolean;
            allowRenoteToExternal: boolean;
            userId: string | null;
        } | null | undefined;
        localOnly?: boolean | undefined;
        reactionAcceptance: "likeOnly" | "likeOnlyForRemote" | "nonSensitiveOnly" | "nonSensitiveOnlyForLocalLikeOnlyForRemote" | null;
        reactionEmojis: {
            [key: string]: string;
        };
        reactions: {
            [key: string]: number;
        };
        reactionCount: number;
        renoteCount: number;
        repliesCount: number;
        uri?: string | undefined;
        url?: string | undefined;
        reactionAndUserPairCache?: string[] | undefined;
        clippedCount?: number | undefined;
        hasPoll?: boolean | undefined;
        myReaction?: string | null | undefined;
    }[];
    getInstanceUrl(subdomain: string): string;
    getIsLockedProfile(): boolean | null | undefined;
    private extractInstanceUrl;
    getAccountUrl(mySubdomain?: string): string;
    getAppDisplayAccountUrl(myDomain: string): string;
    getEmojiMap(): Map<string, string>;
    findEmoji(q: string): undefined;
    isValid(): boolean;
    getUsername(): string;
    getAvatarBlurHash(): string | null;
    getAvatarUrl(): string;
    getBannerUrl(): string | null;
    getBannerBlurHash(): string | null;
    getDescription(): string | null;
    getCreatedAt(): Date;
    getBirthday(): Date | null;
    getFields(): any[];
    getFollowersCount(): number;
    getFollowingCount(): number;
    hasPendingFollowRequestFromYou(): boolean | undefined;
    hasPendingFollowRequestToYou(): boolean | undefined;
    getIsBot(): boolean | undefined;
    getPostCount(): number;
    getOnlineStatus(): "active" | "offline" | "online" | "unknown";
    getId(): string;
    getDisplayName(): string | null;
}
export default MisskeyUser;
//# sourceMappingURL=misskey.d.ts.map