class MastodonUser {
    ref;
    constructor(ref) {
        this.ref = ref;
    }
    getPinnedNotes = () => [];
    getInstanceUrl() {
        const ex = /^https?:\/\/(.*?)\/(.*?)/;
        const subdomainExtractUrl = /^https?:\/\/(.*?)\/@?/;
        const fullUrl = this.ref.instance?.url;
        if (ex.test(fullUrl)) {
            return fullUrl.match(subdomainExtractUrl)[1];
        }
        return '';
    }
    getAccountUrl(mySubdomain) {
        return this.ref.instance?.url;
    }
    extractInstanceUrl(url, username, myServer) {
        if (!url)
            return '';
        let ourUrl = '';
        let theirUrl = '';
        const ex = /^https?:\/\/(.*?)\/(.*?)/;
        const subdomainExtractUrl = /^https?:\/\/(.*?)\/?/;
        if (ex.test(myServer)) {
            ourUrl = myServer.match(subdomainExtractUrl)[1];
        }
        if (ex.test(url)) {
            theirUrl = url.match(ex)[1];
        }
        if (url.includes(myServer))
            return '@' + username;
        if (ourUrl === theirUrl) {
            return '@' + username;
        }
        return '@' + username + '@' + theirUrl;
    }
    getAppDisplayAccountUrl(myDomain) {
        const url = this.getAccountUrl();
        const username = this.getUsername();
        return this.extractInstanceUrl(url, username, myDomain);
    }
    getEmojiMap() {
        const map = new Map();
        this.ref.instance?.emojis?.forEach((o) => {
            map.set(o.shortcode, o.url);
        });
        return map;
    }
    getAvatarBlurHash() {
        return this.ref?.instance?.avatarStatic;
    }
    getAvatarUrl() {
        return this.ref?.instance?.avatar;
    }
    getBannerBlurHash() {
        return this?.ref?.instance?.headerStatic;
    }
    getBannerUrl() {
        return this?.ref?.instance?.header;
    }
    getBirthday() {
        return null;
    }
    getCreatedAt() {
        return new Date(this?.ref?.instance?.createdAt);
    }
    getDescription() {
        return this?.ref?.instance?.note;
    }
    getDisplayName() {
        return this?.ref?.instance?.displayName;
    }
    getFields() {
        return this?.ref?.instance?.fields;
    }
    getFollowersCount() {
        return this?.ref?.instance?.followersCount;
    }
    getFollowingCount() {
        return this?.ref?.instance?.followingCount;
    }
    getId() {
        return this?.ref?.instance?.id;
    }
    getIsBot() {
        return this?.ref?.instance?.bot;
    }
    getIsLockedProfile() {
        return this?.ref?.instance?.locked;
    }
    getOnlineStatus() {
        return 'unknown';
    }
    getPostCount() {
        return this.ref?.instance?.statusesCount;
    }
    getUsername() {
        return this?.ref?.instance?.username;
    }
    hasPendingFollowRequestFromYou() {
        return false;
    }
    hasPendingFollowRequestToYou() {
        return false;
    }
}
export default MastodonUser;
//# sourceMappingURL=mastodon.js.map