import { AccountInstance, UserTargetInterface } from './_interface.js';
declare class MastodonUser implements UserTargetInterface {
    ref: AccountInstance;
    constructor(ref: AccountInstance);
    getPinnedNotes: () => never[];
    getInstanceUrl(): string;
    getAccountUrl(mySubdomain?: string): string;
    private extractInstanceUrl;
    getAppDisplayAccountUrl(myDomain: string): string;
    getEmojiMap(): Map<string, string>;
    getAvatarBlurHash(): string;
    getAvatarUrl(): string;
    getBannerBlurHash(): string | null;
    getBannerUrl(): string | null;
    getBirthday(): Date | null;
    getCreatedAt(): Date;
    getDescription(): string | null;
    getDisplayName(): string;
    getFields(): any[];
    getFollowersCount(): number;
    getFollowingCount(): number;
    getId(): string;
    getIsBot(): boolean;
    getIsLockedProfile(): boolean;
    getOnlineStatus(): 'online' | 'active' | 'offline' | 'unknown';
    getPostCount(): number;
    getUsername(): string;
    hasPendingFollowRequestFromYou(): boolean;
    hasPendingFollowRequestToYou(): boolean;
}
export default MastodonUser;
//# sourceMappingURL=mastodon.d.ts.map