import MisskeyUser from './misskey.js';
import MastodonUser from './mastodon.js';
import DefaultUser from './default.js';
import BlueskyUserInterface from './bluesky.js';
import { CasingUtil } from '../../utils/casing.js';
import { KNOWN_SOFTWARE } from '../../client/utils/driver.js';
export class UserDetailedInstance {
    instance;
    constructor(instance) {
        this.instance = instance;
    }
}
export class AccountInstance {
    instance;
    constructor(instance) {
        this.instance = instance;
    }
}
export function ActivityPubUserAdapter(profile, domain) {
    if (!profile)
        return new DefaultUser();
    switch (domain) {
        case KNOWN_SOFTWARE.MISSKEY:
        case KNOWN_SOFTWARE.FIREFISH:
        case KNOWN_SOFTWARE.MEISSKEY:
        case KNOWN_SOFTWARE.KMYBLUE:
        case KNOWN_SOFTWARE.CHERRYPICK:
        case KNOWN_SOFTWARE.SHARKEY: {
            return new MisskeyUser(new UserDetailedInstance(profile));
        }
        case KNOWN_SOFTWARE.MASTODON: {
            const instance = new AccountInstance(profile);
            return new MastodonUser(instance);
        }
        case KNOWN_SOFTWARE.PLEROMA:
        case KNOWN_SOFTWARE.AKKOMA: {
            const _camel = CasingUtil.camelCaseKeys(profile);
            return new MastodonUser(new AccountInstance(_camel));
        }
        case KNOWN_SOFTWARE.BLUESKY:
            return new BlueskyUserInterface(profile);
        default: {
            return new DefaultUser();
        }
    }
}
//# sourceMappingURL=_interface.js.map