import { PaginatedPromise } from '#/types/api-response.js';
type DhaagaFetchRequestConfig = {
    method?: 'GET' | 'POST' | 'PUT' | 'DELETE' | 'OPTIONS' | 'PATCH';
    baseURL?: string;
    accessToken?: string;
    queries?: Object | Record<string, string>;
    transformQueryKeys?: 'snake' | 'camel';
    transformQueryValues?: 'snake' | 'camel';
    transformResponse?: 'snake' | 'camel';
};
declare class FetchWrapper {
    baseUrl: string;
    token?: string;
    requestHeader: HeadersInit;
    constructor(urlLike: string, token?: string);
    static create(urlLike: string, token?: string): FetchWrapper;
    private static cleanObject;
    private withQuery;
    getCamelCaseWithLinkPagination<T>(endpoint: string, query?: object | Record<string, string>): PaginatedPromise<T>;
    getCamelCase<T>(endpoint: string, query?: object | Record<string, string>): Promise<T>;
    post<T>(endpoint: string, body: object, opts: {}): Promise<T>;
    private static applyQueriesToRequestUrl;
    private static buildRequestInitObject;
    get<T>(endpoint: string, opts?: DhaagaFetchRequestConfig): Promise<T>;
}
export default FetchWrapper;
//# sourceMappingURL=fetch.d.ts.map