declare enum KNOWN_SOFTWARE {
    AKKOMA = "akkoma",
    BLUESKY = "bluesky",
    CHERRYPICK = "cherrypick",
    FIREFISH = "firefish",
    FRIENDICA = "friendica",
    GOTOSOCIAL = "gotosocial",
    HOMETOWN = "hometown",
    ICESHRIMP = "iceshrimp",
    KMYBLUE = "kmyblue",
    LEMMY = "lemmy",
    MASTODON = "mastodon",
    MEISSKEY = "meisskey",
    MISSKEY = "misskey",
    PEERTUBE = "peertube",
    PIXELFED = "pixelfed",
    PLEROMA = "pleroma",
    SHARKEY = "sharkey",
    UNKNOWN = "unknown"
}
declare const PROTOCOLS: readonly ["masto_api_v1", "masto_api_v2", "misskey_api", "atproto", "pleroma_api"];
type ProtocolEnum = (typeof PROTOCOLS)[number];
declare const data: Record<KNOWN_SOFTWARE, ProtocolEnum[]>;
declare enum DriverNotificationType {
    CHAT = "chat",
    MENTION = "mention",
    HOME = "home",
    PUBLIC = "public",
    STATUS = "status",
    REBLOG = "reblog",
    FOLLOW = "follow",
    FOLLOW_REQUEST = "follow_request",
    FAVOURITE = "favourite",
    POLL_NOTIFICATION = "poll",
    STATUS_EDITED = "update",
    ADMIN_SIGNUP = "admin.sign_up",
    ADMIN_REPORT = "admin.report",
    NOTE = "note",
    REPLY = "reply",
    RENOTE = "renote",
    QUOTE = "quote",
    REACTION = "reaction",
    POLL_ENDED = "pollEnded",
    FOLLOW_REQUEST_RECEIVED = "receiveFollowRequest",
    FOLLOW_REQUEST_ACCEPTED = "followRequestAccepted",
    ROLES_ASSIGNED = "roleAssigned",
    ACHIEVEMENT_EARNED = "achievementEarned",
    APP = "app",
    TEST = "test",
    REACTION_GROUPED = "reaction:grouped",
    RENOTE_GROUPED = "renote:grouped",
    POLL_VOTE = "pollVote",
    GROUP_INVITED = "groupInvited",
    LIKE = "like",
    REPOST = "repost"
}
export { data, KNOWN_SOFTWARE, DriverNotificationType };
//# sourceMappingURL=driver.d.ts.map