import { MisskeyInstanceRouter } from '../collections/servers/misskey.js';
import { MisskeyAccountsRouter } from '../collections/accounts/misskey.js';
import { MisskeyStatusesRouter } from '../collections/posts/misskey.js';
import { MisskeyTrendsRouter } from '../collections/trends/misskey.js';
import { MisskeyNotificationsRouter } from '../collections/notifications/misskey.js';
import { MisskeyTimelinesRouter } from '../collections/timelines/misskey.js';
import { MisskeyTagsRouter } from '../collections/tags/misskey.js';
import { MisskeySearchRouter } from '../collections/search/misskey.js';
import { MisskeyMeRouter } from '../collections/me/misskey.js';
import { MisskeyMediaRouter } from '../collections/media/misskey.js';
import { MisskeyListsRoute } from '../collections/lists/misskey.js';
import FetchWrapper from '../utils/fetch.js';
class Adapter {
    driver;
    server;
    key;
    fetch;
    instances;
    users;
    posts;
    trends;
    notifications;
    timelines;
    tags;
    search;
    me;
    media;
    lists;
    constructor(driver, server, dto) {
        this.driver = driver;
        this.server = server;
        this.key = dto.clientId.toString();
        this.fetch = FetchWrapper.create(dto.instance, dto.token);
        this.instances = new MisskeyInstanceRouter(this.fetch);
        this.users = new MisskeyAccountsRouter(this.fetch);
        this.posts = new MisskeyStatusesRouter(this.fetch);
        this.trends = new MisskeyTrendsRouter(this.fetch);
        this.notifications = new MisskeyNotificationsRouter(this.fetch);
        this.timelines = new MisskeyTimelinesRouter(this.fetch);
        this.tags = new MisskeyTagsRouter(this.fetch);
        this.search = new MisskeySearchRouter(this.fetch);
        this.me = new MisskeyMeRouter(this.fetch);
        this.media = new MisskeyMediaRouter(this.fetch);
        this.lists = new MisskeyListsRoute(this.fetch);
    }
}
export { Adapter as MisskeyApiAdapter };
//# sourceMappingURL=misskey.js.map