import BlueskyAccountsRouter from '../collections/accounts/bluesky.js';
import { BlueskyInstanceRouter } from '../collections/servers/bluesky.js';
import { BlueskyListRoute } from '../collections/lists/bluesky.js';
import { BlueskyMeRouter } from '../collections/me/bluesky.js';
import BlueskyMediaRouter from '../collections/media/bluesky.js';
import BlueskyNotificationsRouter from '../collections/notifications/bluesky.js';
import BlueskyProfileRouter from '../collections/profile/bluesky.js';
import BlueskySearchRouter from '../collections/search/bluesky.js';
import BlueskyStatusesRouter from '../collections/posts/bluesky.js';
import BlueskyTagsRouter from '../collections/tags/bluesky.js';
import BlueskyTimelinesRouter from '../collections/timelines/bluesky.js';
import BlueskyTrendsRouter from '../collections/trends/bluesky.js';
import BlueskyFeedRouter from '../collections/feeds/bluesky.js';
import { getXrpcAgent } from '../../utils/atproto.js';
class Adapter {
    driver;
    server;
    key;
    users;
    instances;
    lists;
    me;
    media;
    notifications;
    profile;
    search;
    posts;
    tags;
    timelines;
    trends;
    feeds;
    dto;
    constructor(driver, server, dto) {
        this.driver = driver;
        this.server = server;
        this.key = dto.clientId.toString();
        this.dto = dto;
        this.users = new BlueskyAccountsRouter(this.dto);
        this.instances = new BlueskyInstanceRouter();
        this.lists = new BlueskyListRoute();
        this.me = new BlueskyMeRouter(this.dto);
        this.media = new BlueskyMediaRouter();
        this.notifications = new BlueskyNotificationsRouter(this.dto);
        this.profile = new BlueskyProfileRouter();
        this.search = new BlueskySearchRouter(this.dto);
        this.posts = new BlueskyStatusesRouter(this.dto);
        this.tags = new BlueskyTagsRouter();
        this.timelines = new BlueskyTimelinesRouter(this.dto);
        this.trends = new BlueskyTrendsRouter(this.dto);
        this.feeds = new BlueskyFeedRouter(this.dto);
    }
    getAgent() {
        return getXrpcAgent(this.dto);
    }
}
export { Adapter as AtprotoApiAdapter };
//# sourceMappingURL=bluesky.js.map