import { getXrpcAgent } from '#/utils/atproto.js';
class BlueskyTrendsRouter {
    dto;
    constructor(dto) {
        this.dto = dto;
    }
    async links(opts) {
        throw new Error('Method not implemented.');
    }
    async posts(opts) {
        throw new Error('Method not implemented.');
    }
    async tags(opts) {
        const agent = getXrpcAgent(this.dto);
        const data = await agent.app.bsky.unspecced.getTrends({
            limit: opts.limit,
        });
        return data.data.trends;
    }
    async fetchPopularFeedGenerators(params) {
        const agent = getXrpcAgent(this.dto);
        const data = await agent.app.bsky.unspecced.getPopularFeedGenerators(params);
        return {
            data: data.data.feeds,
            maxId: data.data.cursor,
        };
    }
    async fetchSuggestedStarterPacks(params) {
        const agent = getXrpcAgent(this.dto);
        const data = await agent.app.bsky.unspecced.getSuggestedStarterPacks(params);
        return data.data.starterPacks;
    }
    async fetchSuggestedFeeds(params) {
        const agent = getXrpcAgent(this.dto);
        const data = await agent.app.bsky.unspecced.getSuggestedFeeds(params);
        return data.data.feeds;
    }
    async fetchSuggestedUsers(params) {
        const agent = getXrpcAgent(this.dto);
        const data = await agent.app.bsky.unspecced.getSuggestedUsers(params);
        return data.data.actors;
    }
}
export default BlueskyTrendsRouter;
//# sourceMappingURL=bluesky.js.map