import { TrendsRoute } from './_interface.js';
import { GetTrendingDTO } from '#/client/typings.js';
import { MastoStatus, MastoTrendLink } from '#/types/mastojs.types.js';
import { AppBskyActorDefs, AppBskyFeedDefs, AppBskyGraphDefs, AppBskyUnspeccedDefs } from '@atproto/api';
import { AppAtpSessionData } from '#/types/atproto.js';
import { PaginatedPromise } from '#/types/api-response.js';
type TrendQueryParams = {
    limit?: number;
    cursor?: string;
    query?: string;
};
declare class BlueskyTrendsRouter implements TrendsRoute {
    dto: AppAtpSessionData;
    constructor(dto: AppAtpSessionData);
    links(opts: GetTrendingDTO): Promise<MastoTrendLink[]>;
    posts(opts: GetTrendingDTO): Promise<MastoStatus[]>;
    tags(opts: GetTrendingDTO): Promise<AppBskyUnspeccedDefs.TrendView[]>;
    fetchPopularFeedGenerators(params: TrendQueryParams): PaginatedPromise<AppBskyFeedDefs.GeneratorView[]>;
    fetchSuggestedStarterPacks(params: TrendQueryParams): Promise<AppBskyGraphDefs.StarterPackView[]>;
    fetchSuggestedFeeds(params: TrendQueryParams): Promise<AppBskyFeedDefs.GeneratorView[]>;
    fetchSuggestedUsers(params: TrendQueryParams): Promise<AppBskyActorDefs.ProfileView[]>;
}
export default BlueskyTrendsRouter;
//# sourceMappingURL=bluesky.d.ts.map