import { MisskeyJsWrapper } from '#/client/utils/api-wrappers.js';
export class MisskeyTimelinesRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MisskeyJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    publicAsGuest(urlLike, query) {
        throw new Error('Method not implemented.');
    }
    hashtagAsGuest(urlLike, q, query) {
        throw new Error('Method not implemented.');
    }
    async home(query) {
        const data = await this.client.client.request('notes/timeline', {
            ...query,
        });
        return {
            data: data,
            maxId: data.length > 0 ? data[data.length - 1].id : null,
        };
    }
    async public(query) {
        if (query?.local) {
            const data = await this.client.client.request('notes/local-timeline', {
                ...query,
                allowPartial: true,
                withBots: true,
                local: undefined,
            });
            return { data, maxId: data.length > 0 ? data[data.length - 1].id : null };
        }
        if (query?.social) {
            const data = await this.client.client.request('notes/hybrid-timeline', query);
            return { data, maxId: data.length > 0 ? data[data.length - 1].id : null };
        }
        else {
            const data = await this.client.client.request('notes/global-timeline', query);
            return { data, maxId: data.length > 0 ? data[data.length - 1].id : null };
        }
    }
    async bubble(query) {
        return this.direct.post('/api/notes/bubble-timeline', query, {});
    }
    async hashtag(q, query) {
        const data = await this.client.client.request('notes/search-by-tag', {
            tag: q,
            ...query,
        });
        return { data };
    }
    async list(q, query) {
        const data = await this.client.client.request('notes/user-list-timeline', { listId: q, ...query });
        return { data };
    }
}
//# sourceMappingURL=misskey.js.map