import { DriverTimelineGetApiResponse, TimelinesRoute } from './_interface.js';
import { Endpoints } from 'misskey-js';
import FetchWrapper from '#/client/utils/fetch.js';
import { MisskeyJsWrapper } from '#/client/utils/api-wrappers.js';
import { PaginatedPromise } from '#/types/api-response.js';
import { DhaagaJsTimelineQueryOptions } from '#/client/typings.js';
export declare class MisskeyTimelinesRouter implements TimelinesRoute {
    direct: FetchWrapper;
    client: MisskeyJsWrapper;
    constructor(forwarded: FetchWrapper);
    publicAsGuest(urlLike: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    hashtagAsGuest(urlLike: string, q: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    home(query: DhaagaJsTimelineQueryOptions): PaginatedPromise<Endpoints['notes/timeline']['res']>;
    public(query: DhaagaJsTimelineQueryOptions & {
        withReplies?: boolean | null;
    }): PaginatedPromise<Endpoints['notes/global-timeline']['res']>;
    bubble(query: DhaagaJsTimelineQueryOptions): Promise<any[]>;
    hashtag(q: string, query: DhaagaJsTimelineQueryOptions): PaginatedPromise<Endpoints['notes/search-by-tag']['res']>;
    list(q: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
}
//# sourceMappingURL=misskey.d.ts.map