import { DriverTimelineGetApiResponse, TimelinesRoute } from './_interface.js';
import type { AppBskyFeedDefs } from '@atproto/api';
import { AppAtpSessionData } from '#/types/atproto.js';
import { PaginatedPromise } from '#/types/api-response.js';
import { DhaagaJsTimelineQueryOptions } from '#/client/typings.js';
type FeedGetQueryDto = {
    feed: string;
    limit?: number;
    cursor?: string;
};
declare class BlueskyTimelinesRouter implements TimelinesRoute {
    dto: AppAtpSessionData;
    constructor(dto: AppAtpSessionData);
    hashtag(q: string, query: DhaagaJsTimelineQueryOptions): PaginatedPromise<AppBskyFeedDefs.PostView[]>;
    hashtagAsGuest(urlLike: string, q: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    home(query: DhaagaJsTimelineQueryOptions): PaginatedPromise<AppBskyFeedDefs.FeedViewPost[]>;
    list(q: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    public(query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    publicAsGuest(urlLike: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    getFeed(params: FeedGetQueryDto): PaginatedPromise<AppBskyFeedDefs.FeedViewPost[]>;
    getFeedGenerator(uri: string): Promise<import("@atproto/api/dist/client/types/app/bsky/feed/getFeedGenerator.js").Response>;
    getFeedGenerators(uriList: string[]): Promise<import("@atproto/api/dist/client/types/app/bsky/feed/getFeedGenerators.js").Response>;
}
export default BlueskyTimelinesRouter;
//# sourceMappingURL=bluesky.d.ts.map