import { MastoJsWrapper } from '#/client/utils/api-wrappers.js';
export class MastodonTagRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async followedTags(query) {
        return this.direct.getCamelCaseWithLinkPagination('/api/v1/followed_tags', query);
    }
    async follow(id) {
        return this.client.lib.v1.tags.$select(id).follow();
    }
    async get(id) {
        return this.client.lib.v1.tags.$select(id).fetch();
    }
    async unfollow(id) {
        return this.client.lib.v1.tags.$select(id).unfollow();
    }
}
//# sourceMappingURL=mastodon.js.map