import { MastoJsWrapper } from '#/client/utils/api-wrappers.js';
export class MastodonInstanceRouter {
    direct;
    constructor(forwarded) {
        this.direct = forwarded;
    }
    async getCustomEmojis(urlLike) {
        const data = await MastoJsWrapper.create(urlLike).lib.v1.customEmojis.list();
        return (data?.map((o) => ({
            shortCode: o.shortcode,
            url: o.url,
            staticUrl: o.staticUrl,
            visibleInPicker: o.visibleInPicker,
            category: o.category,
            aliases: [],
            tags: [],
        })) ?? []);
    }
    async getTranslation(id, lang) {
        const _client = MastoJsWrapper.create(this.direct.baseUrl, this.direct.token);
        return _client.lib.v1.statuses.$select(id).translate({ lang: 'en' });
    }
}
//# sourceMappingURL=mastodon.js.map