import { MastoJsWrapper } from '#/client/utils/api-wrappers.js';
import { errorBuilder } from '#/types/index.js';
import { ApiErrorCode } from '#/types/api-response.js';
export class MastodonSearchRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async findUsers(query) {
        const data = await this.client.lib.v2.search.list({
            ...query,
            q: query.query,
        });
        return {
            data: data.accounts,
            maxId: data.accounts.length
                ? data.accounts[data.accounts.length - 1].id
                : undefined,
        };
    }
    async findPosts(query) {
        const data = await this.client.lib.v2.search.list({
            ...query,
            q: query.query,
        });
        return {
            data: data.statuses,
            maxId: data.statuses.length
                ? data.statuses[data.statuses.length - 1].id
                : undefined,
        };
    }
    async unifiedSearch(query) {
        try {
            return await this.client.lib.v2.search.list({
                ...query,
            });
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
}
//# sourceMappingURL=mastodon.js.map