import { getBskyAgent, getXrpcAgent } from '#/utils/atproto.js';
import { errorBuilder } from '#/types/index.js';
import { ApiErrorCode } from '#/types/api-response.js';
class BlueskySearchRouter {
    dto;
    constructor(dto) {
        this.dto = dto;
    }
    async findPosts(q) {
        const agent = getBskyAgent(this.dto);
        const data = await agent.app.bsky.feed.searchPosts({
            q: q.q,
            limit: 10,
            sort: q.sort,
            cursor: q.maxId === null ? undefined : q.maxId,
        });
        if (!data.success)
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        return {
            data: data.data.posts,
            maxId: data.data.cursor,
            hitsTotal: data.data.hitsTotal,
        };
    }
    async findUsers(q) {
        const agent = getBskyAgent(this.dto);
        const data = await agent.app.bsky.actor.searchActors({
            q: q.q,
            limit: q.limit || 8,
        });
        return { data: data.data.actors, maxId: null };
    }
    async findUsersTypeAhead(q) {
        const agent = getBskyAgent(this.dto);
        const data = await agent.app.bsky.actor.searchActorsTypeahead({
            q: q.q,
            limit: q.limit || 8,
        });
        return { data: data.data.actors, maxId: null };
    }
    async findFeeds(query) {
        const agent = getXrpcAgent(this.dto);
        const data = await agent.app.bsky.unspecced.getPopularFeedGenerators(query);
        return { data: data.data.feeds, maxId: data.data.cursor };
    }
}
export default BlueskySearchRouter;
//# sourceMappingURL=bluesky.js.map