import { StatusesRoute } from './_interface.js';
import { MegaReaction, MegaScheduledStatus, MegaStatus } from '#/types/megalodon.types.js';
import FetchWrapper from '#/client/utils/fetch.js';
import { MastoJsWrapper, MegalodonPleromaWrapper } from '#/client/utils/api-wrappers.js';
import { DriverBookmarkStateResult, DriverLikeStateResult } from '#/types/driver.types.js';
import { PaginatedPromise } from '#/types/api-response.js';
import type { MastoAccount, MastoStatus } from '#/types/index.js';
import { DhaagaJsPostCreateDto } from '#/client/typings.js';
export declare class PleromaStatusesRouter implements StatusesRoute {
    direct: FetchWrapper;
    client: MegalodonPleromaWrapper;
    mastoClient: MastoJsWrapper;
    constructor(forwarded: FetchWrapper);
    getPost(id: string): Promise<MegaStatus>;
    create(dto: DhaagaJsPostCreateDto): Promise<MegaStatus | MegaScheduledStatus>;
    delete(id: string): Promise<{
        success: boolean;
        deleted: boolean;
    }>;
    getReactions(id: string): Promise<MegaReaction[]>;
    getReactionDetails(postId: string, reactionId: string): Promise<MegaReaction[]>;
    addReaction(id: string, shortCode: string): Promise<any>;
    removeReaction(id: string, shortCode: string): Promise<any>;
    bookmark(id: string): DriverBookmarkStateResult;
    unBookmark(id: string): DriverBookmarkStateResult;
    like(id: string): DriverLikeStateResult;
    removeLike(id: string): DriverLikeStateResult;
    getPostContext(id: string): Promise<any>;
    boost(id: string): Promise<MegaStatus>;
    removeBoost(id: string): Promise<MegaStatus>;
    getLikedBy(id: string): Promise<{
        data: import("masto/mastodon/entities/v1/account.js").Account[];
    }>;
    getSharedBy(id: string): PaginatedPromise<MastoAccount[]>;
    getQuotedBy(id: string): PaginatedPromise<MastoStatus[]>;
}
//# sourceMappingURL=pleroma.d.ts.map