import { MastoJsWrapper } from '#/client/utils/api-wrappers.js';
export class MastodonStatusesRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async create(dto) {
        return this.client.lib.v1.statuses.create({
            ...dto,
            visibility: dto.mastoVisibility,
        });
    }
    async delete(id) {
        const data = this.client.lib.v1.statuses.$select(id).remove();
        if (!data)
            return { success: false, deleted: false };
        return { success: true, deleted: true };
    }
    async getPost(id) {
        return this.client.lib.v1.statuses.$select(id).fetch();
    }
    async bookmark(id) {
        const data = await this.client.lib.v1.statuses.$select(id).bookmark();
        return { state: !!data.bookmarked };
    }
    async unBookmark(id) {
        const data = await this.client.lib.v1.statuses.$select(id).unbookmark();
        return { state: !!data.bookmarked };
    }
    async like(id) {
        const data = await this.client.lib.v1.statuses.$select(id).favourite();
        return { state: !!data.favourited, counter: data.favouritesCount };
    }
    async removeLike(id) {
        const data = await this.client.lib.v1.statuses.$select(id).unfavourite();
        return { state: !!data.favourited, counter: data.favouritesCount };
    }
    async getPostContext(id) {
        return this.client.lib.v1.statuses.$select(id).context.fetch();
    }
    async boost(id) {
        return this.client.lib.v1.statuses
            .$select(id)
            .reblog({ visibility: 'public' });
    }
    async removeBoost(id) {
        return this.client.lib.v1.statuses.$select(id).unreblog();
    }
    async getLikedBy(id) {
        const data = await this.client.lib.v1.statuses
            .$select(id)
            .favouritedBy.list();
        return {
            data,
        };
    }
    async getSharedBy(id) {
        const data = await this.client.lib.v1.statuses
            .$select(id)
            .rebloggedBy.list();
        return {
            data,
        };
    }
    async getQuotedBy(id) {
        return {
            data: [],
        };
    }
}
//# sourceMappingURL=mastodon.js.map