import { StatusesRoute } from './_interface.js';
import type { MastoAccount, MastoContext, MastoStatus } from '#/types/mastojs.types.js';
import FetchWrapper from '#/client/utils/fetch.js';
import { MastoJsWrapper } from '#/client/utils/api-wrappers.js';
import { DriverBookmarkStateResult, DriverLikeStateResult } from '#/types/driver.types.js';
import { PaginatedPromise } from '#/types/api-response.js';
import { DhaagaJsPostCreateDto } from '#/client/typings.js';
export declare class MastodonStatusesRouter implements StatusesRoute {
    direct: FetchWrapper;
    client: MastoJsWrapper;
    constructor(forwarded: FetchWrapper);
    create(dto: DhaagaJsPostCreateDto): Promise<MastoStatus>;
    delete(id: string): Promise<{
        success: boolean;
        deleted: boolean;
    }>;
    getPost(id: string): Promise<MastoStatus>;
    bookmark(id: string): DriverBookmarkStateResult;
    unBookmark(id: string): DriverBookmarkStateResult;
    like(id: string): DriverLikeStateResult;
    removeLike(id: string): DriverLikeStateResult;
    getPostContext(id: string): Promise<MastoContext>;
    boost(id: string): Promise<MastoStatus>;
    removeBoost(id: string): Promise<MastoStatus>;
    getLikedBy(id: string): PaginatedPromise<MastoAccount[]>;
    getSharedBy(id: string): PaginatedPromise<MastoAccount[]>;
    getQuotedBy(id: string): PaginatedPromise<MastoStatus[]>;
}
//# sourceMappingURL=mastodon.d.ts.map