import { StatusesRoute } from './_interface.js';
import { MastoContext, MastoScheduledStatus, MastoStatus } from '#/types/mastojs.types.js';
import { MissContext } from '#/types/misskey-js.types.js';
import { DriverBookmarkStateResult, DriverLikeStateResult } from '#/types/driver.types.js';
import { DhaagaJsPostCreateDto } from '#/client/typings.js';
export declare class DefaultStatusesRouter implements StatusesRoute {
    getPost(id: string): Promise<MastoStatus>;
    create(dto: DhaagaJsPostCreateDto): Promise<MastoScheduledStatus>;
    delete(id: string): Promise<{
        success: boolean;
        deleted: boolean;
    }>;
    bookmark(id: string): DriverBookmarkStateResult;
    unBookmark(id: string): DriverBookmarkStateResult;
    like(id: string): DriverLikeStateResult;
    removeLike(id: string): DriverLikeStateResult;
    getPostContext(id: string): Promise<MastoContext | MissContext>;
    getLikedBy(id: string): Promise<any>;
    getSharedBy(id: string): Promise<any>;
    getQuotedBy(id: string): Promise<any>;
}
//# sourceMappingURL=default.d.ts.map