import { getBskyAgent, getXrpcAgent } from '#/utils/atproto.js';
class BlueskyStatusesRouter {
    dto;
    constructor(dto) {
        this.dto = dto;
    }
    bookmark(id) {
        throw new Error('incorrect method. please use atProtoBookmark');
    }
    async atProtoBookmark(uri, cid) {
        const agent = getXrpcAgent(this.dto);
        await agent.app.bsky.bookmark.createBookmark({
            cid,
            uri,
        });
        return { state: true };
    }
    async unBookmark(uri) {
        const agent = getXrpcAgent(this.dto);
        await agent.app.bsky.bookmark.deleteBookmark({
            uri,
        });
        return { state: false };
    }
    async create(dto) {
        const agent = getBskyAgent(this.dto);
        return agent.post({
            text: dto.status,
        });
    }
    async delete(id) {
        const agent = getBskyAgent(this.dto);
        try {
            await agent.deletePost(id);
            return { success: true, deleted: true };
        }
        catch (e) {
            return { success: false, deleted: false };
        }
    }
    async getPost(uri) {
        const agent = getBskyAgent(this.dto);
        const data = await agent.getPostThread({ uri, depth: 0 });
        if (data.data.thread.$type !== 'app.bsky.feed.defs#threadViewPost') {
            throw new Error('Current version of Dhaaga is unable to handle Blocked or Missing posts :(');
        }
        return data.data.thread.post;
    }
    async getPosts(ids) {
        const agent = getBskyAgent(this.dto);
        const data = await agent.getPosts({
            uris: ids,
        });
        return data.data.posts;
    }
    async getPostContext(id, limit, sort) {
        const agent = getXrpcAgent(this.dto);
        const data = await agent.app.bsky.unspecced.getPostThreadV2({
            anchor: id,
            branchingFactor: 1,
            below: 10,
            sort: 'top',
        });
        return data.data;
    }
    async like(uri, cid) {
        if (!cid)
            throw new Error('invalid input. missing cid');
        const agent = getBskyAgent(this.dto);
        const result = await agent.like(uri, cid);
        return { state: true, uri: result.uri };
    }
    async removeLike(uri, cid) {
        if (!cid)
            throw new Error('invalid input. missing cid');
        const agent = getBskyAgent(this.dto);
        await agent.deleteLike(uri);
        return { state: false };
    }
    async getConvoForMembers(members) {
        const agent = getBskyAgent(this.dto);
        return await agent.chat.bsky.convo.getConvoForMembers({
            members,
        });
    }
    async getConvo(id) {
        const agent = getBskyAgent(this.dto);
        return await agent.chat.bsky.convo.getConvo({
            convoId: id,
        });
    }
    async sendMessage(id, msg) {
        const agent = getBskyAgent(this.dto);
        return agent.chat.bsky.convo.sendMessage({
            convoId: id,
            message: { text: msg },
        });
    }
    async atProtoLike(uri, cid) {
        const agent = getBskyAgent(this.dto);
        const result = await agent.like(uri, cid);
        return { state: true, uri: result.uri };
    }
    async atProtoDeleteLike(uri) {
        const agent = getBskyAgent(this.dto);
        await agent.deleteLike(uri);
        return { state: false };
    }
    async atProtoRepost(uri, cid) {
        try {
            const agent = getBskyAgent(this.dto);
            const result = await agent.repost(uri, cid);
            return { success: true, liked: true, uri: result.uri };
        }
        catch (e) {
            console.log(e);
            return { success: false };
        }
    }
    async atProtoDeleteRepost(uri) {
        const agent = getBskyAgent(this.dto);
        try {
            await agent.deleteRepost(uri);
            return { success: true, liked: false };
        }
        catch (e) {
            console.log(e);
            return { success: false };
        }
    }
    async getLikedBy(id, limit, maxId) {
        const agent = getBskyAgent(this.dto);
        const data = await agent.getLikes({
            uri: id,
            cursor: maxId === null ? undefined : maxId,
            limit,
        });
        return {
            data: data.data.likes.map((o) => o.actor),
            maxId: data.data.cursor,
        };
    }
    async getSharedBy(id, limit, maxId) {
        const agent = getBskyAgent(this.dto);
        const data = await agent.getRepostedBy({
            uri: id,
            cursor: maxId === null ? undefined : maxId,
            limit,
        });
        return {
            data: data.data.repostedBy,
            maxId: data.data.cursor,
        };
    }
    async getQuotedBy(id, limit, maxId) {
        const agent = getXrpcAgent(this.dto);
        const data = await agent.app.bsky.feed.getQuotes({
            uri: id,
            cursor: maxId === null ? undefined : maxId,
            limit,
        });
        return {
            data: data.data.posts,
            maxId: data.data.cursor,
        };
    }
}
export default BlueskyStatusesRouter;
//# sourceMappingURL=bluesky.js.map