import { NotificationsRoute } from './_interface.js';
import FetchWrapper from '#/client/utils/fetch.js';
import { MastoConversation, MastoGroupedNotificationsResults, MastoNotification } from '#/types/mastojs.types.js';
import { MastoJsWrapper } from '#/client/utils/api-wrappers.js';
import { PaginatedPromise } from '#/types/api-response.js';
import { NotificationGetQueryDto } from '#/client/typings.js';
export declare class MastodonNotificationsRouter implements NotificationsRoute {
    direct: FetchWrapper;
    mastoClient: MastoJsWrapper;
    constructor(forwarded: FetchWrapper);
    getAllNotifications(query: NotificationGetQueryDto): PaginatedPromise<MastoNotification[]>;
    getMentions(query: NotificationGetQueryDto): PaginatedPromise<MastoGroupedNotificationsResults>;
    getSocialUpdates(query: NotificationGetQueryDto): Promise<{
        data: import("masto/mastodon/entities/v1/grouped-notifications.js").GroupedNotificationsResults;
        minId?: string | null | undefined;
        maxId?: string | null | undefined;
        hitsTotal?: number | undefined;
    }>;
    getSubscriptions(maxId?: string): Promise<{
        data: import("masto/mastodon/entities/v1/grouped-notifications.js").GroupedNotificationsResults;
        minId?: string | null | undefined;
        maxId?: string | null | undefined;
        hitsTotal?: number | undefined;
    }>;
    getChats(): PaginatedPromise<MastoConversation[]>;
    getChatDetails(): PaginatedPromise<any>;
    getChatMessages(): PaginatedPromise<any>;
    markChatAsRead(id: string): Promise<MastoConversation>;
    markChatAsUnread(id: string): Promise<MastoConversation>;
    markChatRemove(id: string): Promise<void>;
    sendMessage(): Promise<void>;
}
//# sourceMappingURL=mastodon.d.ts.map