import type { AppBskyNotificationListNotifications, ChatBskyConvoDefs, Facet } from '@atproto/api';
import { NotificationsRoute } from './_interface.js';
import type { AppAtpSessionData } from '#/types/atproto.js';
import { PaginatedPromise } from '#/types/api-response.js';
import { NotificationGetQueryDto } from '#/client/typings.js';
declare class BlueskyNotificationsRouter implements NotificationsRoute {
    dto: AppAtpSessionData;
    constructor(dto: AppAtpSessionData);
    getAllNotifications(query: NotificationGetQueryDto): PaginatedPromise<AppBskyNotificationListNotifications.Notification[]>;
    getChats(): PaginatedPromise<ChatBskyConvoDefs.ConvoView[]>;
    getChatDetails(convoId: string): Promise<ChatBskyConvoDefs.ConvoView>;
    getChatMessages(convoId: string): PaginatedPromise<ChatBskyConvoDefs.MessageView[]>;
    getMentions(query: NotificationGetQueryDto): PaginatedPromise<AppBskyNotificationListNotifications.Notification[]>;
    getSubscriptions(maxId?: string): PaginatedPromise<AppBskyNotificationListNotifications.Notification[]>;
    sendMessage(convoId: string, content: {
        text: string;
        facets?: Facet[];
    }): Promise<ChatBskyConvoDefs.MessageView>;
    getSocialUpdates(query: NotificationGetQueryDto): PaginatedPromise<AppBskyNotificationListNotifications.Notification[]>;
}
export default BlueskyNotificationsRouter;
//# sourceMappingURL=bluesky.d.ts.map