import type { AppBskyNotificationListNotifications, ChatBskyConvoDefs, Facet } from '@atproto/api';
import type { MastoGroupedNotificationsResults, MastoNotification } from '#/types/mastojs.types.js';
import type { MegaNotification } from '#/types/megalodon.types.js';
import { Endpoints } from 'misskey-js';
import { PaginatedPromise } from '#/types/api-response.js';
import { NotificationGetQueryDto } from '#/client/typings.js';
export interface NotificationsRoute {
    getAllNotifications(query: NotificationGetQueryDto): PaginatedPromise<MastoNotification[] | MegaNotification[] | MastoGroupedNotificationsResults | AppBskyNotificationListNotifications.Notification[] | Endpoints['i/notifications-grouped']['res']>;
    getMentions(query: NotificationGetQueryDto): PaginatedPromise<AppBskyNotificationListNotifications.Notification[] | MastoGroupedNotificationsResults | any>;
    getChats(roomId: string): PaginatedPromise<ChatBskyConvoDefs.ConvoView[] | any>;
    getSocialUpdates(query: NotificationGetQueryDto): PaginatedPromise<AppBskyNotificationListNotifications.Notification[] | any>;
    getSubscriptions(maxId?: string): PaginatedPromise<AppBskyNotificationListNotifications.Notification[] | any>;
    getChatDetails(roomId: string): Promise<ChatBskyConvoDefs.ConvoView | any>;
    getChatMessages(roomId: string): PaginatedPromise<any>;
    sendMessage(convoId: string, content: {
        text?: string;
        facets?: Facet[];
    }): Promise<ChatBskyConvoDefs.MessageView | void>;
}
//# sourceMappingURL=_interface.d.ts.map