import { RandomUtil } from '#/utils/random.js';
import { AppBskyActorDefs, } from '@atproto/api';
import { getXrpcAgent } from '#/utils/atproto.js';
import { notImplementedErrorBuilder } from '#/types/api-response.js';
class BlueskyFeedRouter {
    dto;
    xrpc;
    constructor(dto) {
        this.dto = dto;
        this.xrpc = getXrpcAgent(this.dto);
    }
    async ensureUserPref(pref) {
        if (pref)
            return pref;
        return (await this.xrpc.app.bsky.actor.getPreferences()).data;
    }
    findFeedPref(pref, uri) {
        const i = pref.preferences.findIndex(AppBskyActorDefs.isSavedFeedsPrefV2);
        if (i === -1)
            return [-1, -1];
        const j = pref.preferences[i].items.findIndex((o) => o.value === uri);
        return [i, j];
    }
    async getFeedGenerator(uri) {
        const data = await this.xrpc.app.bsky.feed.getFeedGenerator({
            feed: uri,
        });
        return data.data;
    }
    async getFeedGenerators(uriList) {
        const data = await this.xrpc.app.bsky.feed.getFeedGenerators({
            feeds: uriList,
        });
        return data.data.feeds;
    }
    async like(uri) {
        return notImplementedErrorBuilder();
    }
    async removeLike(uri) {
        return notImplementedErrorBuilder();
    }
    async addSubscription(uri, cached) {
        const pref = await this.ensureUserPref(cached);
        const [i, j] = this.findFeedPref(pref, uri);
        if (i === -1)
            return { success: false, subscribed: false };
        if (j !== -1)
            return { success: true, subscribed: true };
        pref.preferences[i].items.push({
            value: uri,
            pinned: true,
            type: 'feed',
            id: RandomUtil.nanoId(13),
        });
        const result = await this.xrpc.app.bsky.actor.putPreferences(pref);
        return { success: result.success, subscribed: false };
    }
    async removeSubscription(uri, cached) {
        const pref = await this.ensureUserPref(cached);
        const [i, j] = this.findFeedPref(pref, uri);
        if (i === -1 || j === -1)
            return { success: false, subscribed: false };
        pref.preferences[i].items.splice(j, 1);
        const result = await this.xrpc.app.bsky.actor.putPreferences(pref);
        return { success: result.success, subscribed: false };
    }
    async pin(uri, cached) {
        const pref = await this.ensureUserPref(cached);
        const [i, j] = this.findFeedPref(pref, uri);
        if (i === -1 || j === -1)
            return { success: false, pinned: false };
        pref.preferences[i].items[j].pinned = true;
        const result = await this.xrpc.app.bsky.actor.putPreferences(pref);
        return { success: result.success, pinned: true };
    }
    async removePin(uri, cached) {
        const pref = await this.ensureUserPref(cached);
        const [i, j] = this.findFeedPref(pref, uri);
        if (i === -1 || j === -1)
            return { success: false, pinned: false };
        pref.preferences[i].items[j].pinned = false;
        const result = await this.xrpc.app.bsky.actor.putPreferences(pref);
        return { success: result.success, pinned: false };
    }
}
export default BlueskyFeedRouter;
//# sourceMappingURL=bluesky.js.map