import { MegalodonPleromaWrapper } from '#/client/utils/api-wrappers.js';
import { CasingUtil } from '#/utils/casing.js';
import { errorBuilder } from '#/types/index.js';
export class PleromaAccountsRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MegalodonPleromaWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async get(id) {
        const data = await this.client.client.getAccount(id);
        return CasingUtil.camelCaseKeys(data.data);
    }
    async lookup(webfinger) {
        const data = await this.client.client.lookupAccount(webfinger.host
            ? `${webfinger.username}@${webfinger.host}`
            : webfinger.username);
        if (data.status !== 200)
            throw new Error(data.statusText);
        return data.data;
    }
    async getPosts(id, query) {
        const data = await this.client.client.getAccountStatuses(id, CasingUtil.snakeCaseKeys(query));
        return {
            data: CasingUtil.camelCaseKeys(data.data),
            maxId: null,
            minId: null,
        };
    }
    async relationships(ids) {
        const data = await this.client.client.getRelationships(ids);
        return CasingUtil.camelCaseKeys(data.data);
    }
    async likes(query) {
        return this.direct.getCamelCaseWithLinkPagination('/api/v1/favourites', query);
    }
    async bookmarks(query) {
        return this.direct.getCamelCaseWithLinkPagination('/api/v1/bookmarks', query);
    }
    async follow(id) {
        const data = await this.client.client.followAccount(id);
        if (data.status !== 200) {
            return errorBuilder(data.statusText);
        }
        return { data: CasingUtil.camelCaseKeys(data.data) };
    }
    async unfollow(id) {
        const data = await this.client.client.unfollowAccount(id);
        if (data.status !== 200) {
            return errorBuilder(data.statusText);
        }
        return { data: CasingUtil.camelCaseKeys(data.data) };
    }
    async getFollowers(query) {
        const { id, ...rest } = query;
        return await this.direct.getCamelCaseWithLinkPagination(`/api/v1/accounts/${id}/followers`, rest);
    }
    async getFollowings(query) {
        const { id, ...rest } = query;
        return await this.direct.getCamelCaseWithLinkPagination(`/api/v1/accounts/${id}/following`, rest);
    }
    block(id) {
        throw new Error('Method not implemented.');
    }
    featuredTags(id) {
        throw new Error('Method not implemented.');
    }
    getLists(id) {
        throw new Error('Method not implemented.');
    }
    knownFollowers(ids) {
        throw new Error('Method not implemented.');
    }
    mute(id, opts) {
        throw new Error('Method not implemented.');
    }
    removeFollower(id) {
        throw new Error('Method not implemented.');
    }
    resolveMany(ids) {
        throw new Error('Method not implemented.');
    }
    unblock(id) {
        throw new Error('Method not implemented.');
    }
    unmute(id) {
        throw new Error('Method not implemented.');
    }
}
//# sourceMappingURL=pleroma.js.map