import { AccountRoute } from './_interface.js';
import { AccountMutePostDto, AccountRouteStatusQueryDto, BookmarkGetQueryDTO, FollowerGetQueryDTO, GetPostsQueryDTO } from '../../typings.js';
import FetchWrapper from '#/client/utils/fetch.js';
import type { MastoAccount, MastoFamiliarFollowers, MastoFeaturedTag, MastoList, MastoRelationship } from '#/types/mastojs.types.js';
import type { MegaAccount, MegaRelationship, MegaStatus } from '#/types/megalodon.types.js';
import { MegalodonPleromaWrapper } from '#/client/utils/api-wrappers.js';
import { DriverWebfingerType } from '#/types/query.types.js';
import { MissUserDetailed } from '#/types/index.js';
import { PaginatedPromise } from '#/types/api-response.js';
export declare class PleromaAccountsRouter implements AccountRoute {
    direct: FetchWrapper;
    client: MegalodonPleromaWrapper;
    constructor(forwarded: FetchWrapper);
    get(id: string): Promise<MegaAccount>;
    lookup(webfinger: DriverWebfingerType): Promise<MegaAccount>;
    getPosts(id: string, query: AccountRouteStatusQueryDto): Promise<any>;
    relationships(ids: string[]): Promise<MegaRelationship[]>;
    likes(query: GetPostsQueryDTO): PaginatedPromise<MegaStatus[]>;
    bookmarks(query: BookmarkGetQueryDTO): PaginatedPromise<MegaStatus[]>;
    follow(id: string): Promise<MegaRelationship>;
    unfollow(id: string): Promise<MegaRelationship>;
    getFollowers(query: FollowerGetQueryDTO): PaginatedPromise<MastoAccount[]>;
    getFollowings(query: FollowerGetQueryDTO): PaginatedPromise<MastoAccount[]>;
    block(id: string): Promise<MegaRelationship>;
    featuredTags(id: string): Promise<MastoFeaturedTag[]>;
    getLists(id: string): PaginatedPromise<MastoList[]>;
    knownFollowers(ids: string[]): Promise<MastoFamiliarFollowers[]>;
    mute(id: string, opts: AccountMutePostDto): Promise<MastoRelationship | MegaRelationship>;
    removeFollower(id: string): Promise<void>;
    resolveMany(ids: string[]): Promise<MastoAccount[] | MissUserDetailed[]>;
    unblock(id: string): Promise<MegaRelationship>;
    unmute(id: string): Promise<MastoRelationship | MegaRelationship>;
}
//# sourceMappingURL=pleroma.d.ts.map