import { AccountRoute } from './_interface.js';
import { Endpoints } from 'misskey-js';
import { AccountRouteStatusQueryDto, BookmarkGetQueryDTO, FollowerGetQueryDTO, FollowPostDto, GetPostsQueryDTO } from '../../typings.js';
import FetchWrapper from '#/client/utils/fetch.js';
import type { MastoFamiliarFollowers, MastoFeaturedTag, MastoRelationship } from '#/types/mastojs.types.js';
import { MissUserDetailed } from '#/types/misskey-js.types.js';
import { MisskeyJsWrapper } from '#/client/utils/api-wrappers.js';
import { PaginatedPromise } from '#/types/api-response.js';
export declare class MisskeyAccountsRouter implements AccountRoute {
    direct: FetchWrapper;
    client: MisskeyJsWrapper;
    constructor(forwarded: FetchWrapper);
    getPosts(id: string, query: AccountRouteStatusQueryDto): PaginatedPromise<Endpoints['users/notes']['res']>;
    relationships(ids: string[]): Promise<MastoRelationship[]>;
    get(id: string): Promise<MissUserDetailed>;
    resolveMany(ids: string[]): Promise<MissUserDetailed[]>;
    follow(id: string, opts: FollowPostDto): Promise<Endpoints['following/create']['res']>;
    unfollow(id: string): Promise<Endpoints['following/delete']['res']>;
    block(id: string): Promise<Endpoints['blocking/create']['res']>;
    unblock(id: string): Promise<Endpoints['blocking/delete']['res']>;
    findByWebfinger({ username, host }: {
        username: string;
        host: string | null;
    }): Promise<{
        data: any;
    }>;
    findByUserId(id: string): Promise<{
        data: any;
    }>;
    findByUserIds(ids: string[]): Promise<{
        data: any;
    }>;
    renoteMute(id: string): Promise<{
        renoteMuted: true;
    }>;
    renoteUnmute(id: string): Promise<{
        renoteMuted: false;
    }>;
    likes(query: GetPostsQueryDTO): Promise<any>;
    bookmarks(query: BookmarkGetQueryDTO): PaginatedPromise<Endpoints['i/favorites']['res']>;
    getFollowers(query: FollowerGetQueryDTO): PaginatedPromise<MissUserDetailed[]>;
    getFollowings(query: FollowerGetQueryDTO): PaginatedPromise<MissUserDetailed[]>;
    mute(): Promise<void>;
    unmute(): Promise<void>;
    removeFollower(): Promise<void>;
    lookup(): Promise<void>;
    featuredTags(id: string): Promise<MastoFeaturedTag[]>;
    knownFollowers(ids: string[]): Promise<MastoFamiliarFollowers[]>;
    getLists(): PaginatedPromise<Endpoints['users/lists/list']['res']>;
}
//# sourceMappingURL=misskey.d.ts.map