import FetchWrapper from '#/client/utils/fetch.js';
import { MastoJsWrapper } from '#/client/utils/api-wrappers.js';
export class MastodonAccountsRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async lookup(webfinger) {
        return await this.client.lib.v1.accounts.lookup({
            acct: webfinger.host
                ? `${webfinger.username}@${webfinger.host}`
                : webfinger.username,
        });
    }
    async follow(id, opts) {
        return this.client.lib.v1.accounts.$select(id).follow(opts);
    }
    async unfollow(id) {
        return this.client.lib.v1.accounts.$select(id).unfollow();
    }
    async block(id) {
        return this.client.lib.v1.accounts.$select(id).block();
    }
    async unblock(id) {
        return this.client.lib.v1.accounts.$select(id).unblock();
    }
    async mute(id, opts) {
        return this.client.lib.v1.accounts.$select(id).mute(opts);
    }
    async unmute(id) {
        return this.client.lib.v1.accounts.$select(id).unmute();
    }
    async removeFollower(id) {
        return this.client.lib.v1.accounts.$select(id).removeFromFollowers();
    }
    async featuredTags(id) {
        return this.client.lib.v1.accounts.$select(id).featuredTags.list();
    }
    async knownFollowers(ids) {
        return this.client.lib.v1.accounts.familiarFollowers.fetch(ids);
    }
    async getLists(id) {
        const data = await this.client.lib.v1.lists.list();
        return { data };
    }
    async getPosts(id, query) {
        const data = await this.client.lib.v1.accounts
            .$select(id)
            .statuses.list(query);
        return {
            data,
            maxId: data.length > 0 ? data[data.length - 1]?.id : null,
            minId: data.length > 0 ? data[0]?.id : null,
        };
    }
    async get(id) {
        return this.client.lib.v1.accounts.$select(id).fetch();
    }
    async resolveMany(ids) {
        return (await new FetchWrapper(this.direct.baseUrl, this.direct.token).getCamelCase('/api/v1/accounts', { id: ids }));
    }
    async relationships(ids) {
        return await this.client.lib.v1.accounts.relationships.fetch({
            id: ids,
            withSuspended: true,
        });
    }
    async likes(query) {
        return this.direct.getCamelCaseWithLinkPagination('/api/v1/favourites', query);
    }
    async bookmarks(query) {
        return this.direct.getCamelCaseWithLinkPagination('/api/v1/bookmarks', query);
    }
    async getFollowers(query) {
        const { id, ...rest } = query;
        return await this.direct.getCamelCaseWithLinkPagination(`/api/v1/accounts/${id}/followers`, rest);
    }
    async getFollowings(query) {
        const { id, ...rest } = query;
        return await this.direct.getCamelCaseWithLinkPagination(`/api/v1/accounts/${id}/following`, rest);
    }
}
//# sourceMappingURL=mastodon.js.map