import { identifyBackendSoftware } from '#/client/utils/detect-software.js';
import { KNOWN_SOFTWARE } from '#/client/utils/driver.js';
import { generateMiAuthUrl } from '#/auth/mi-auth.js';
import { generateActivitypubLoginUrl } from '#/auth/activitypub.js';
export async function generateDhaagaAuthStrategy(urlLike, { appName, appWebsite, appCallback, }, tokens) {
    const data = await identifyBackendSoftware(urlLike);
    switch (data.software) {
        case KNOWN_SOFTWARE.FIREFISH: {
            throw new Error('firefish is no longer supported by @dhaaga/bridge');
        }
        case KNOWN_SOFTWARE.SHARKEY:
        case KNOWN_SOFTWARE.MEISSKEY:
        case KNOWN_SOFTWARE.CHERRYPICK:
        case KNOWN_SOFTWARE.KMYBLUE:
        case KNOWN_SOFTWARE.ICESHRIMP:
        case KNOWN_SOFTWARE.MISSKEY: {
            return {
                loginUrl: generateMiAuthUrl({
                    urlLike,
                    appName,
                    appCallback,
                }),
                loginStrategy: 'miauth',
                version: data.version,
                software: data.software,
            };
        }
        case KNOWN_SOFTWARE.PLEROMA:
        case KNOWN_SOFTWARE.AKKOMA:
        case KNOWN_SOFTWARE.MASTODON: {
            const { loginUrl, clientSecret, clientId } = await generateActivitypubLoginUrl(urlLike, {
                appName,
                appWebsite,
            }, {
                appId: tokens?.clientId,
                appSecret: tokens?.clientSecret,
            });
            return {
                loginUrl,
                loginStrategy: 'code',
                version: data.version,
                software: data.software,
                clientId,
                clientSecret,
            };
        }
        default:
            throw new Error(`backend software incompatible for ${urlLike}`);
    }
}
//# sourceMappingURL=unified.js.map