export async function getMastodonAccessToken(instanceUrl, code, clientId, clientSecret) {
    const res = await fetch(`https://${instanceUrl}/oauth/token`, {
        method: 'POST',
        body: JSON.stringify({
            client_id: clientId,
            client_secret: clientSecret,
            redirect_uri: 'urn:ietf:wg:oauth:2.0:oob',
            grant_type: 'authorization_code',
            code,
            scope: 'read write push follow',
        }),
        headers: {
            'Content-Type': 'application/json',
        },
    });
    const data = await res.json();
    return data?.access_token;
}
export async function verifyCredentialsActivitypub(urlLike, token) {
    const res = await fetch(`https://${urlLike}/api/v1/accounts/verify_credentials`, {
        method: 'GET',
        headers: {
            Authorization: `Bearer ${token}`,
            'Content-Type': 'application/json',
        },
    });
    return res.json();
}
export async function generateActivitypubLoginUrl(urlLike, { appName, appWebsite }, tokens) {
    let _appClientId = tokens?.appId;
    let _appClientSecret = tokens?.appSecret;
    if (!_appClientId || !_appClientSecret) {
        const clientIdFormData = {
            client_name: appName,
            redirect_uris: 'urn:ietf:wg:oauth:2.0:oob',
            scopes: 'read write follow push',
            website: appWebsite,
        };
        const clientIdQueryString = Object.keys(clientIdFormData)
            .map((key) => `${key}=${encodeURIComponent(clientIdFormData[key])}`)
            .join('&');
        const clientId = await fetch(`https://${urlLike}/api/v1/apps`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: clientIdQueryString,
        });
        if (!clientId.ok)
            throw new Error('failed to generate app tokens ');
        const _body = await clientId.json();
        _appClientId = _body?.['client_id'];
        _appClientSecret = _body?.['client_secret'];
    }
    const authEndpoint = `https://${urlLike}/oauth/authorize`;
    const options = {
        client_id: _appClientId,
        redirect_uri: 'urn:ietf:wg:oauth:2.0:oob',
        response_type: 'code',
        scope: 'read write follow push',
    };
    const queryString = Object.keys(options)
        .map((key) => `${key}=${encodeURIComponent(options[key])}`)
        .join('&');
    return {
        loginUrl: `${authEndpoint}?${queryString}`,
        clientId: _appClientId,
        clientSecret: _appClientSecret,
    };
}
export async function exchangeCodeForAccessToken(urlLike, code, clientId, clientSecret) {
    const res = await fetch(`https://${urlLike}/oauth/token`, {
        method: 'POST',
        body: JSON.stringify({
            client_id: clientId,
            client_secret: clientSecret,
            redirect_uri: 'urn:ietf:wg:oauth:2.0:oob',
            grant_type: 'authorization_code',
            code,
            scope: 'read write push follow',
        }),
        headers: {
            'Content-Type': 'application/json',
        },
    });
    const data = await res.json();
    return data?.access_token;
}
//# sourceMappingURL=activitypub.js.map