export type paths = {
    '/admin/abuse-report/notification-recipient/create': {
        post: operations['admin___abuse-report___notification-recipient___create'];
    };
    '/admin/abuse-report/notification-recipient/delete': {
        post: operations['admin___abuse-report___notification-recipient___delete'];
    };
    '/admin/abuse-report/notification-recipient/list': {
        post: operations['admin___abuse-report___notification-recipient___list'];
    };
    '/admin/abuse-report/notification-recipient/show': {
        post: operations['admin___abuse-report___notification-recipient___show'];
    };
    '/admin/abuse-report/notification-recipient/update': {
        post: operations['admin___abuse-report___notification-recipient___update'];
    };
    '/admin/abuse-user-reports': {
        post: operations['admin___abuse-user-reports'];
    };
    '/admin/accounts/create': {
        post: operations['admin___accounts___create'];
    };
    '/admin/accounts/delete': {
        post: operations['admin___accounts___delete'];
    };
    '/admin/accounts/find-by-email': {
        post: operations['admin___accounts___find-by-email'];
    };
    '/admin/ad/create': {
        post: operations['admin___ad___create'];
    };
    '/admin/ad/delete': {
        post: operations['admin___ad___delete'];
    };
    '/admin/ad/list': {
        post: operations['admin___ad___list'];
    };
    '/admin/ad/update': {
        post: operations['admin___ad___update'];
    };
    '/admin/announcements/create': {
        post: operations['admin___announcements___create'];
    };
    '/admin/announcements/delete': {
        post: operations['admin___announcements___delete'];
    };
    '/admin/announcements/list': {
        post: operations['admin___announcements___list'];
    };
    '/admin/announcements/update': {
        post: operations['admin___announcements___update'];
    };
    '/admin/avatar-decorations/create': {
        post: operations['admin___avatar-decorations___create'];
    };
    '/admin/avatar-decorations/delete': {
        post: operations['admin___avatar-decorations___delete'];
    };
    '/admin/avatar-decorations/list': {
        post: operations['admin___avatar-decorations___list'];
    };
    '/admin/avatar-decorations/update': {
        post: operations['admin___avatar-decorations___update'];
    };
    '/admin/captcha/current': {
        post: operations['admin___captcha___current'];
    };
    '/admin/captcha/save': {
        post: operations['admin___captcha___save'];
    };
    '/admin/delete-account': {
        post: operations['admin___delete-account'];
    };
    '/admin/delete-all-files-of-a-user': {
        post: operations['admin___delete-all-files-of-a-user'];
    };
    '/admin/drive/clean-remote-files': {
        post: operations['admin___drive___clean-remote-files'];
    };
    '/admin/drive/cleanup': {
        post: operations['admin___drive___cleanup'];
    };
    '/admin/drive/files': {
        post: operations['admin___drive___files'];
    };
    '/admin/drive/show-file': {
        post: operations['admin___drive___show-file'];
    };
    '/admin/emoji/add': {
        post: operations['admin___emoji___add'];
    };
    '/admin/emoji/add-aliases-bulk': {
        post: operations['admin___emoji___add-aliases-bulk'];
    };
    '/admin/emoji/copy': {
        post: operations['admin___emoji___copy'];
    };
    '/admin/emoji/delete': {
        post: operations['admin___emoji___delete'];
    };
    '/admin/emoji/delete-bulk': {
        post: operations['admin___emoji___delete-bulk'];
    };
    '/admin/emoji/import-zip': {
        post: operations['admin___emoji___import-zip'];
    };
    '/admin/emoji/list': {
        post: operations['admin___emoji___list'];
    };
    '/admin/emoji/list-remote': {
        post: operations['admin___emoji___list-remote'];
    };
    '/admin/emoji/remove-aliases-bulk': {
        post: operations['admin___emoji___remove-aliases-bulk'];
    };
    '/admin/emoji/set-aliases-bulk': {
        post: operations['admin___emoji___set-aliases-bulk'];
    };
    '/admin/emoji/set-category-bulk': {
        post: operations['admin___emoji___set-category-bulk'];
    };
    '/admin/emoji/set-license-bulk': {
        post: operations['admin___emoji___set-license-bulk'];
    };
    '/admin/emoji/update': {
        post: operations['admin___emoji___update'];
    };
    '/admin/federation/delete-all-files': {
        post: operations['admin___federation___delete-all-files'];
    };
    '/admin/federation/refresh-remote-instance-metadata': {
        post: operations['admin___federation___refresh-remote-instance-metadata'];
    };
    '/admin/federation/remove-all-following': {
        post: operations['admin___federation___remove-all-following'];
    };
    '/admin/federation/update-instance': {
        post: operations['admin___federation___update-instance'];
    };
    '/admin/forward-abuse-user-report': {
        post: operations['admin___forward-abuse-user-report'];
    };
    '/admin/get-index-stats': {
        post: operations['admin___get-index-stats'];
    };
    '/admin/get-table-stats': {
        post: operations['admin___get-table-stats'];
    };
    '/admin/get-user-ips': {
        post: operations['admin___get-user-ips'];
    };
    '/admin/invite/create': {
        post: operations['admin___invite___create'];
    };
    '/admin/invite/list': {
        post: operations['admin___invite___list'];
    };
    '/admin/meta': {
        post: operations['admin___meta'];
    };
    '/admin/promo/create': {
        post: operations['admin___promo___create'];
    };
    '/admin/queue/clear': {
        post: operations['admin___queue___clear'];
    };
    '/admin/queue/deliver-delayed': {
        post: operations['admin___queue___deliver-delayed'];
    };
    '/admin/queue/inbox-delayed': {
        post: operations['admin___queue___inbox-delayed'];
    };
    '/admin/queue/jobs': {
        post: operations['admin___queue___jobs'];
    };
    '/admin/queue/promote-jobs': {
        post: operations['admin___queue___promote-jobs'];
    };
    '/admin/queue/queue-stats': {
        post: operations['admin___queue___queue-stats'];
    };
    '/admin/queue/queues': {
        post: operations['admin___queue___queues'];
    };
    '/admin/queue/remove-job': {
        post: operations['admin___queue___remove-job'];
    };
    '/admin/queue/retry-job': {
        post: operations['admin___queue___retry-job'];
    };
    '/admin/queue/show-job': {
        post: operations['admin___queue___show-job'];
    };
    '/admin/queue/show-job-logs': {
        post: operations['admin___queue___show-job-logs'];
    };
    '/admin/queue/stats': {
        post: operations['admin___queue___stats'];
    };
    '/admin/relays/add': {
        post: operations['admin___relays___add'];
    };
    '/admin/relays/list': {
        post: operations['admin___relays___list'];
    };
    '/admin/relays/remove': {
        post: operations['admin___relays___remove'];
    };
    '/admin/reset-password': {
        post: operations['admin___reset-password'];
    };
    '/admin/resolve-abuse-user-report': {
        post: operations['admin___resolve-abuse-user-report'];
    };
    '/admin/roles/assign': {
        post: operations['admin___roles___assign'];
    };
    '/admin/roles/create': {
        post: operations['admin___roles___create'];
    };
    '/admin/roles/delete': {
        post: operations['admin___roles___delete'];
    };
    '/admin/roles/list': {
        post: operations['admin___roles___list'];
    };
    '/admin/roles/show': {
        post: operations['admin___roles___show'];
    };
    '/admin/roles/unassign': {
        post: operations['admin___roles___unassign'];
    };
    '/admin/roles/update': {
        post: operations['admin___roles___update'];
    };
    '/admin/roles/update-default-policies': {
        post: operations['admin___roles___update-default-policies'];
    };
    '/admin/roles/users': {
        post: operations['admin___roles___users'];
    };
    '/admin/send-email': {
        post: operations['admin___send-email'];
    };
    '/admin/server-info': {
        post: operations['admin___server-info'];
    };
    '/admin/show-moderation-logs': {
        post: operations['admin___show-moderation-logs'];
    };
    '/admin/show-user': {
        post: operations['admin___show-user'];
    };
    '/admin/show-users': {
        post: operations['admin___show-users'];
    };
    '/admin/suspend-user': {
        post: operations['admin___suspend-user'];
    };
    '/admin/system-webhook/create': {
        post: operations['admin___system-webhook___create'];
    };
    '/admin/system-webhook/delete': {
        post: operations['admin___system-webhook___delete'];
    };
    '/admin/system-webhook/list': {
        post: operations['admin___system-webhook___list'];
    };
    '/admin/system-webhook/show': {
        post: operations['admin___system-webhook___show'];
    };
    '/admin/system-webhook/test': {
        post: operations['admin___system-webhook___test'];
    };
    '/admin/system-webhook/update': {
        post: operations['admin___system-webhook___update'];
    };
    '/admin/unset-user-avatar': {
        post: operations['admin___unset-user-avatar'];
    };
    '/admin/unset-user-banner': {
        post: operations['admin___unset-user-banner'];
    };
    '/admin/unsuspend-user': {
        post: operations['admin___unsuspend-user'];
    };
    '/admin/update-abuse-user-report': {
        post: operations['admin___update-abuse-user-report'];
    };
    '/admin/update-meta': {
        post: operations['admin___update-meta'];
    };
    '/admin/update-proxy-account': {
        post: operations['admin___update-proxy-account'];
    };
    '/admin/update-user-note': {
        post: operations['admin___update-user-note'];
    };
    '/announcements': {
        post: operations['announcements'];
    };
    '/announcements/show': {
        post: operations['announcements___show'];
    };
    '/antennas/create': {
        post: operations['antennas___create'];
    };
    '/antennas/delete': {
        post: operations['antennas___delete'];
    };
    '/antennas/list': {
        post: operations['antennas___list'];
    };
    '/antennas/notes': {
        post: operations['antennas___notes'];
    };
    '/antennas/show': {
        post: operations['antennas___show'];
    };
    '/antennas/update': {
        post: operations['antennas___update'];
    };
    '/ap/get': {
        post: operations['ap___get'];
    };
    '/ap/show': {
        post: operations['ap___show'];
    };
    '/app/create': {
        post: operations['app___create'];
    };
    '/app/show': {
        post: operations['app___show'];
    };
    '/auth/accept': {
        post: operations['auth___accept'];
    };
    '/auth/session/generate': {
        post: operations['auth___session___generate'];
    };
    '/auth/session/show': {
        post: operations['auth___session___show'];
    };
    '/auth/session/userkey': {
        post: operations['auth___session___userkey'];
    };
    '/blocking/create': {
        post: operations['blocking___create'];
    };
    '/blocking/delete': {
        post: operations['blocking___delete'];
    };
    '/blocking/list': {
        post: operations['blocking___list'];
    };
    '/bubble-game/ranking': {
        post: operations['bubble-game___ranking'];
    };
    '/bubble-game/register': {
        post: operations['bubble-game___register'];
    };
    '/channels/create': {
        post: operations['channels___create'];
    };
    '/channels/favorite': {
        post: operations['channels___favorite'];
    };
    '/channels/featured': {
        post: operations['channels___featured'];
    };
    '/channels/follow': {
        post: operations['channels___follow'];
    };
    '/channels/followed': {
        post: operations['channels___followed'];
    };
    '/channels/mute/create': {
        post: operations['channels___mute___create'];
    };
    '/channels/mute/delete': {
        post: operations['channels___mute___delete'];
    };
    '/channels/mute/list': {
        post: operations['channels___mute___list'];
    };
    '/channels/my-favorites': {
        post: operations['channels___my-favorites'];
    };
    '/channels/owned': {
        post: operations['channels___owned'];
    };
    '/channels/search': {
        post: operations['channels___search'];
    };
    '/channels/show': {
        post: operations['channels___show'];
    };
    '/channels/timeline': {
        post: operations['channels___timeline'];
    };
    '/channels/unfavorite': {
        post: operations['channels___unfavorite'];
    };
    '/channels/unfollow': {
        post: operations['channels___unfollow'];
    };
    '/channels/update': {
        post: operations['channels___update'];
    };
    '/charts/active-users': {
        post: operations['charts___active-users'];
    };
    '/charts/ap-request': {
        post: operations['charts___ap-request'];
    };
    '/charts/drive': {
        post: operations['charts___drive'];
    };
    '/charts/federation': {
        post: operations['charts___federation'];
    };
    '/charts/instance': {
        post: operations['charts___instance'];
    };
    '/charts/notes': {
        post: operations['charts___notes'];
    };
    '/charts/user/drive': {
        post: operations['charts___user___drive'];
    };
    '/charts/user/following': {
        post: operations['charts___user___following'];
    };
    '/charts/user/notes': {
        post: operations['charts___user___notes'];
    };
    '/charts/user/pv': {
        post: operations['charts___user___pv'];
    };
    '/charts/user/reactions': {
        post: operations['charts___user___reactions'];
    };
    '/charts/users': {
        post: operations['charts___users'];
    };
    '/chat/history': {
        post: operations['chat___history'];
    };
    '/chat/messages/create-to-room': {
        post: operations['chat___messages___create-to-room'];
    };
    '/chat/messages/create-to-user': {
        post: operations['chat___messages___create-to-user'];
    };
    '/chat/messages/delete': {
        post: operations['chat___messages___delete'];
    };
    '/chat/messages/react': {
        post: operations['chat___messages___react'];
    };
    '/chat/messages/room-timeline': {
        post: operations['chat___messages___room-timeline'];
    };
    '/chat/messages/search': {
        post: operations['chat___messages___search'];
    };
    '/chat/messages/show': {
        post: operations['chat___messages___show'];
    };
    '/chat/messages/unreact': {
        post: operations['chat___messages___unreact'];
    };
    '/chat/messages/user-timeline': {
        post: operations['chat___messages___user-timeline'];
    };
    '/chat/read-all': {
        post: operations['chat___read-all'];
    };
    '/chat/rooms/create': {
        post: operations['chat___rooms___create'];
    };
    '/chat/rooms/delete': {
        post: operations['chat___rooms___delete'];
    };
    '/chat/rooms/invitations/create': {
        post: operations['chat___rooms___invitations___create'];
    };
    '/chat/rooms/invitations/ignore': {
        post: operations['chat___rooms___invitations___ignore'];
    };
    '/chat/rooms/invitations/inbox': {
        post: operations['chat___rooms___invitations___inbox'];
    };
    '/chat/rooms/invitations/outbox': {
        post: operations['chat___rooms___invitations___outbox'];
    };
    '/chat/rooms/join': {
        post: operations['chat___rooms___join'];
    };
    '/chat/rooms/joining': {
        post: operations['chat___rooms___joining'];
    };
    '/chat/rooms/leave': {
        post: operations['chat___rooms___leave'];
    };
    '/chat/rooms/members': {
        post: operations['chat___rooms___members'];
    };
    '/chat/rooms/mute': {
        post: operations['chat___rooms___mute'];
    };
    '/chat/rooms/owned': {
        post: operations['chat___rooms___owned'];
    };
    '/chat/rooms/show': {
        post: operations['chat___rooms___show'];
    };
    '/chat/rooms/update': {
        post: operations['chat___rooms___update'];
    };
    '/clips/add-note': {
        post: operations['clips___add-note'];
    };
    '/clips/create': {
        post: operations['clips___create'];
    };
    '/clips/delete': {
        post: operations['clips___delete'];
    };
    '/clips/favorite': {
        post: operations['clips___favorite'];
    };
    '/clips/list': {
        post: operations['clips___list'];
    };
    '/clips/my-favorites': {
        post: operations['clips___my-favorites'];
    };
    '/clips/notes': {
        post: operations['clips___notes'];
    };
    '/clips/remove-note': {
        post: operations['clips___remove-note'];
    };
    '/clips/show': {
        post: operations['clips___show'];
    };
    '/clips/unfavorite': {
        post: operations['clips___unfavorite'];
    };
    '/clips/update': {
        post: operations['clips___update'];
    };
    '/drive': {
        post: operations['drive'];
    };
    '/drive/files': {
        post: operations['drive___files'];
    };
    '/drive/files/attached-chat-messages': {
        post: operations['drive___files___attached-chat-messages'];
    };
    '/drive/files/attached-notes': {
        post: operations['drive___files___attached-notes'];
    };
    '/drive/files/check-existence': {
        post: operations['drive___files___check-existence'];
    };
    '/drive/files/create': {
        post: operations['drive___files___create'];
    };
    '/drive/files/delete': {
        post: operations['drive___files___delete'];
    };
    '/drive/files/find': {
        post: operations['drive___files___find'];
    };
    '/drive/files/find-by-hash': {
        post: operations['drive___files___find-by-hash'];
    };
    '/drive/files/move-bulk': {
        post: operations['drive___files___move-bulk'];
    };
    '/drive/files/show': {
        post: operations['drive___files___show'];
    };
    '/drive/files/update': {
        post: operations['drive___files___update'];
    };
    '/drive/files/upload-from-url': {
        post: operations['drive___files___upload-from-url'];
    };
    '/drive/folders': {
        post: operations['drive___folders'];
    };
    '/drive/folders/create': {
        post: operations['drive___folders___create'];
    };
    '/drive/folders/delete': {
        post: operations['drive___folders___delete'];
    };
    '/drive/folders/find': {
        post: operations['drive___folders___find'];
    };
    '/drive/folders/show': {
        post: operations['drive___folders___show'];
    };
    '/drive/folders/update': {
        post: operations['drive___folders___update'];
    };
    '/drive/stream': {
        post: operations['drive___stream'];
    };
    '/email-address/available': {
        post: operations['email-address___available'];
    };
    '/emoji': {
        post: operations['emoji'];
    };
    '/emojis': {
        post: operations['emojis'];
    };
    '/endpoint': {
        post: operations['endpoint'];
    };
    '/endpoints': {
        post: operations['endpoints'];
    };
    '/export-custom-emojis': {
        post: operations['export-custom-emojis'];
    };
    '/federation/followers': {
        post: operations['federation___followers'];
    };
    '/federation/following': {
        post: operations['federation___following'];
    };
    '/federation/instances': {
        post: operations['federation___instances'];
    };
    '/federation/show-instance': {
        post: operations['federation___show-instance'];
    };
    '/federation/stats': {
        post: operations['federation___stats'];
    };
    '/federation/update-remote-user': {
        post: operations['federation___update-remote-user'];
    };
    '/federation/users': {
        post: operations['federation___users'];
    };
    '/fetch-external-resources': {
        post: operations['fetch-external-resources'];
    };
    '/fetch-rss': {
        post: operations['fetch-rss'];
    };
    '/flash/create': {
        post: operations['flash___create'];
    };
    '/flash/delete': {
        post: operations['flash___delete'];
    };
    '/flash/featured': {
        post: operations['flash___featured'];
    };
    '/flash/like': {
        post: operations['flash___like'];
    };
    '/flash/my': {
        post: operations['flash___my'];
    };
    '/flash/my-likes': {
        post: operations['flash___my-likes'];
    };
    '/flash/search': {
        post: operations['flash___search'];
    };
    '/flash/show': {
        post: operations['flash___show'];
    };
    '/flash/unlike': {
        post: operations['flash___unlike'];
    };
    '/flash/update': {
        post: operations['flash___update'];
    };
    '/following/create': {
        post: operations['following___create'];
    };
    '/following/delete': {
        post: operations['following___delete'];
    };
    '/following/invalidate': {
        post: operations['following___invalidate'];
    };
    '/following/requests/accept': {
        post: operations['following___requests___accept'];
    };
    '/following/requests/cancel': {
        post: operations['following___requests___cancel'];
    };
    '/following/requests/list': {
        post: operations['following___requests___list'];
    };
    '/following/requests/reject': {
        post: operations['following___requests___reject'];
    };
    '/following/requests/sent': {
        post: operations['following___requests___sent'];
    };
    '/following/update': {
        post: operations['following___update'];
    };
    '/following/update-all': {
        post: operations['following___update-all'];
    };
    '/gallery/featured': {
        post: operations['gallery___featured'];
    };
    '/gallery/popular': {
        post: operations['gallery___popular'];
    };
    '/gallery/posts': {
        post: operations['gallery___posts'];
    };
    '/gallery/posts/create': {
        post: operations['gallery___posts___create'];
    };
    '/gallery/posts/delete': {
        post: operations['gallery___posts___delete'];
    };
    '/gallery/posts/like': {
        post: operations['gallery___posts___like'];
    };
    '/gallery/posts/show': {
        post: operations['gallery___posts___show'];
    };
    '/gallery/posts/unlike': {
        post: operations['gallery___posts___unlike'];
    };
    '/gallery/posts/update': {
        post: operations['gallery___posts___update'];
    };
    '/get-avatar-decorations': {
        post: operations['get-avatar-decorations'];
    };
    '/get-online-users-count': {
        post: operations['get-online-users-count'];
    };
    '/hashtags/list': {
        post: operations['hashtags___list'];
    };
    '/hashtags/search': {
        post: operations['hashtags___search'];
    };
    '/hashtags/show': {
        post: operations['hashtags___show'];
    };
    '/hashtags/trend': {
        post: operations['hashtags___trend'];
    };
    '/hashtags/users': {
        post: operations['hashtags___users'];
    };
    '/i': {
        post: operations['i'];
    };
    '/i/2fa/done': {
        post: operations['i___2fa___done'];
    };
    '/i/2fa/key-done': {
        post: operations['i___2fa___key-done'];
    };
    '/i/2fa/password-less': {
        post: operations['i___2fa___password-less'];
    };
    '/i/2fa/register': {
        post: operations['i___2fa___register'];
    };
    '/i/2fa/register-key': {
        post: operations['i___2fa___register-key'];
    };
    '/i/2fa/remove-key': {
        post: operations['i___2fa___remove-key'];
    };
    '/i/2fa/unregister': {
        post: operations['i___2fa___unregister'];
    };
    '/i/2fa/update-key': {
        post: operations['i___2fa___update-key'];
    };
    '/i/apps': {
        post: operations['i___apps'];
    };
    '/i/authorized-apps': {
        post: operations['i___authorized-apps'];
    };
    '/i/change-password': {
        post: operations['i___change-password'];
    };
    '/i/claim-achievement': {
        post: operations['i___claim-achievement'];
    };
    '/i/delete-account': {
        post: operations['i___delete-account'];
    };
    '/i/export-antennas': {
        post: operations['i___export-antennas'];
    };
    '/i/export-blocking': {
        post: operations['i___export-blocking'];
    };
    '/i/export-clips': {
        post: operations['i___export-clips'];
    };
    '/i/export-favorites': {
        post: operations['i___export-favorites'];
    };
    '/i/export-following': {
        post: operations['i___export-following'];
    };
    '/i/export-mute': {
        post: operations['i___export-mute'];
    };
    '/i/export-notes': {
        post: operations['i___export-notes'];
    };
    '/i/export-user-lists': {
        post: operations['i___export-user-lists'];
    };
    '/i/favorites': {
        post: operations['i___favorites'];
    };
    '/i/gallery/likes': {
        post: operations['i___gallery___likes'];
    };
    '/i/gallery/posts': {
        post: operations['i___gallery___posts'];
    };
    '/i/import-antennas': {
        post: operations['i___import-antennas'];
    };
    '/i/import-blocking': {
        post: operations['i___import-blocking'];
    };
    '/i/import-following': {
        post: operations['i___import-following'];
    };
    '/i/import-muting': {
        post: operations['i___import-muting'];
    };
    '/i/import-user-lists': {
        post: operations['i___import-user-lists'];
    };
    '/i/move': {
        post: operations['i___move'];
    };
    '/i/notifications': {
        post: operations['i___notifications'];
    };
    '/i/notifications-grouped': {
        post: operations['i___notifications-grouped'];
    };
    '/i/page-likes': {
        post: operations['i___page-likes'];
    };
    '/i/pages': {
        post: operations['i___pages'];
    };
    '/i/pin': {
        post: operations['i___pin'];
    };
    '/i/read-announcement': {
        post: operations['i___read-announcement'];
    };
    '/i/regenerate-token': {
        post: operations['i___regenerate-token'];
    };
    '/i/registry/get': {
        post: operations['i___registry___get'];
    };
    '/i/registry/get-all': {
        post: operations['i___registry___get-all'];
    };
    '/i/registry/get-detail': {
        post: operations['i___registry___get-detail'];
    };
    '/i/registry/keys': {
        post: operations['i___registry___keys'];
    };
    '/i/registry/keys-with-type': {
        post: operations['i___registry___keys-with-type'];
    };
    '/i/registry/remove': {
        post: operations['i___registry___remove'];
    };
    '/i/registry/scopes-with-domain': {
        post: operations['i___registry___scopes-with-domain'];
    };
    '/i/registry/set': {
        post: operations['i___registry___set'];
    };
    '/i/revoke-token': {
        post: operations['i___revoke-token'];
    };
    '/i/signin-history': {
        post: operations['i___signin-history'];
    };
    '/i/unpin': {
        post: operations['i___unpin'];
    };
    '/i/update': {
        post: operations['i___update'];
    };
    '/i/update-email': {
        post: operations['i___update-email'];
    };
    '/i/webhooks/create': {
        post: operations['i___webhooks___create'];
    };
    '/i/webhooks/delete': {
        post: operations['i___webhooks___delete'];
    };
    '/i/webhooks/list': {
        post: operations['i___webhooks___list'];
    };
    '/i/webhooks/show': {
        post: operations['i___webhooks___show'];
    };
    '/i/webhooks/test': {
        post: operations['i___webhooks___test'];
    };
    '/i/webhooks/update': {
        post: operations['i___webhooks___update'];
    };
    '/invite/create': {
        post: operations['invite___create'];
    };
    '/invite/delete': {
        post: operations['invite___delete'];
    };
    '/invite/limit': {
        post: operations['invite___limit'];
    };
    '/invite/list': {
        post: operations['invite___list'];
    };
    '/meta': {
        post: operations['meta'];
    };
    '/miauth/gen-token': {
        post: operations['miauth___gen-token'];
    };
    '/mute/create': {
        post: operations['mute___create'];
    };
    '/mute/delete': {
        post: operations['mute___delete'];
    };
    '/mute/list': {
        post: operations['mute___list'];
    };
    '/my/apps': {
        post: operations['my___apps'];
    };
    '/notes': {
        post: operations['notes'];
    };
    '/notes/children': {
        post: operations['notes___children'];
    };
    '/notes/clips': {
        post: operations['notes___clips'];
    };
    '/notes/conversation': {
        post: operations['notes___conversation'];
    };
    '/notes/create': {
        post: operations['notes___create'];
    };
    '/notes/delete': {
        post: operations['notes___delete'];
    };
    '/notes/drafts/count': {
        post: operations['notes___drafts___count'];
    };
    '/notes/drafts/create': {
        post: operations['notes___drafts___create'];
    };
    '/notes/drafts/delete': {
        post: operations['notes___drafts___delete'];
    };
    '/notes/drafts/list': {
        post: operations['notes___drafts___list'];
    };
    '/notes/drafts/update': {
        post: operations['notes___drafts___update'];
    };
    '/notes/favorites/create': {
        post: operations['notes___favorites___create'];
    };
    '/notes/favorites/delete': {
        post: operations['notes___favorites___delete'];
    };
    '/notes/featured': {
        post: operations['notes___featured'];
    };
    '/notes/global-timeline': {
        post: operations['notes___global-timeline'];
    };
    '/notes/hybrid-timeline': {
        post: operations['notes___hybrid-timeline'];
    };
    '/notes/local-timeline': {
        post: operations['notes___local-timeline'];
    };
    '/notes/mentions': {
        post: operations['notes___mentions'];
    };
    '/notes/polls/recommendation': {
        post: operations['notes___polls___recommendation'];
    };
    '/notes/polls/vote': {
        post: operations['notes___polls___vote'];
    };
    '/notes/reactions': {
        post: operations['notes___reactions'];
    };
    '/notes/reactions/create': {
        post: operations['notes___reactions___create'];
    };
    '/notes/reactions/delete': {
        post: operations['notes___reactions___delete'];
    };
    '/notes/renotes': {
        post: operations['notes___renotes'];
    };
    '/notes/replies': {
        post: operations['notes___replies'];
    };
    '/notes/search': {
        post: operations['notes___search'];
    };
    '/notes/search-by-tag': {
        post: operations['notes___search-by-tag'];
    };
    '/notes/show': {
        post: operations['notes___show'];
    };
    '/notes/show-partial-bulk': {
        post: operations['notes___show-partial-bulk'];
    };
    '/notes/state': {
        post: operations['notes___state'];
    };
    '/notes/thread-muting/create': {
        post: operations['notes___thread-muting___create'];
    };
    '/notes/thread-muting/delete': {
        post: operations['notes___thread-muting___delete'];
    };
    '/notes/timeline': {
        post: operations['notes___timeline'];
    };
    '/notes/translate': {
        post: operations['notes___translate'];
    };
    '/notes/unrenote': {
        post: operations['notes___unrenote'];
    };
    '/notes/user-list-timeline': {
        post: operations['notes___user-list-timeline'];
    };
    '/notifications/create': {
        post: operations['notifications___create'];
    };
    '/notifications/flush': {
        post: operations['notifications___flush'];
    };
    '/notifications/mark-all-as-read': {
        post: operations['notifications___mark-all-as-read'];
    };
    '/notifications/test-notification': {
        post: operations['notifications___test-notification'];
    };
    '/page-push': {
        post: operations['page-push'];
    };
    '/pages/create': {
        post: operations['pages___create'];
    };
    '/pages/delete': {
        post: operations['pages___delete'];
    };
    '/pages/featured': {
        post: operations['pages___featured'];
    };
    '/pages/like': {
        post: operations['pages___like'];
    };
    '/pages/show': {
        post: operations['pages___show'];
    };
    '/pages/unlike': {
        post: operations['pages___unlike'];
    };
    '/pages/update': {
        post: operations['pages___update'];
    };
    '/ping': {
        post: operations['ping'];
    };
    '/pinned-users': {
        post: operations['pinned-users'];
    };
    '/promo/read': {
        post: operations['promo___read'];
    };
    '/renote-mute/create': {
        post: operations['renote-mute___create'];
    };
    '/renote-mute/delete': {
        post: operations['renote-mute___delete'];
    };
    '/renote-mute/list': {
        post: operations['renote-mute___list'];
    };
    '/request-reset-password': {
        post: operations['request-reset-password'];
    };
    '/reset-db': {
        post: operations['reset-db'];
    };
    '/reset-password': {
        post: operations['reset-password'];
    };
    '/retention': {
        post: operations['retention'];
    };
    '/reversi/cancel-match': {
        post: operations['reversi___cancel-match'];
    };
    '/reversi/games': {
        post: operations['reversi___games'];
    };
    '/reversi/invitations': {
        post: operations['reversi___invitations'];
    };
    '/reversi/match': {
        post: operations['reversi___match'];
    };
    '/reversi/show-game': {
        post: operations['reversi___show-game'];
    };
    '/reversi/surrender': {
        post: operations['reversi___surrender'];
    };
    '/reversi/verify': {
        post: operations['reversi___verify'];
    };
    '/roles/list': {
        post: operations['roles___list'];
    };
    '/roles/notes': {
        post: operations['roles___notes'];
    };
    '/roles/show': {
        post: operations['roles___show'];
    };
    '/roles/users': {
        post: operations['roles___users'];
    };
    '/server-info': {
        post: operations['server-info'];
    };
    '/stats': {
        post: operations['stats'];
    };
    '/sw/register': {
        post: operations['sw___register'];
    };
    '/sw/show-registration': {
        post: operations['sw___show-registration'];
    };
    '/sw/unregister': {
        post: operations['sw___unregister'];
    };
    '/sw/update-registration': {
        post: operations['sw___update-registration'];
    };
    '/test': {
        post: operations['test'];
    };
    '/username/available': {
        post: operations['username___available'];
    };
    '/users': {
        post: operations['users'];
    };
    '/users/achievements': {
        post: operations['users___achievements'];
    };
    '/users/clips': {
        post: operations['users___clips'];
    };
    '/users/featured-notes': {
        post: operations['users___featured-notes'];
    };
    '/users/flashs': {
        post: operations['users___flashs'];
    };
    '/users/followers': {
        post: operations['users___followers'];
    };
    '/users/following': {
        post: operations['users___following'];
    };
    '/users/gallery/posts': {
        post: operations['users___gallery___posts'];
    };
    '/users/get-frequently-replied-users': {
        post: operations['users___get-frequently-replied-users'];
    };
    '/users/lists/create': {
        post: operations['users___lists___create'];
    };
    '/users/lists/create-from-public': {
        post: operations['users___lists___create-from-public'];
    };
    '/users/lists/delete': {
        post: operations['users___lists___delete'];
    };
    '/users/lists/favorite': {
        post: operations['users___lists___favorite'];
    };
    '/users/lists/get-memberships': {
        post: operations['users___lists___get-memberships'];
    };
    '/users/lists/list': {
        post: operations['users___lists___list'];
    };
    '/users/lists/pull': {
        post: operations['users___lists___pull'];
    };
    '/users/lists/push': {
        post: operations['users___lists___push'];
    };
    '/users/lists/show': {
        post: operations['users___lists___show'];
    };
    '/users/lists/unfavorite': {
        post: operations['users___lists___unfavorite'];
    };
    '/users/lists/update': {
        post: operations['users___lists___update'];
    };
    '/users/lists/update-membership': {
        post: operations['users___lists___update-membership'];
    };
    '/users/notes': {
        post: operations['users___notes'];
    };
    '/users/pages': {
        post: operations['users___pages'];
    };
    '/users/reactions': {
        post: operations['users___reactions'];
    };
    '/users/recommendation': {
        post: operations['users___recommendation'];
    };
    '/users/relation': {
        post: operations['users___relation'];
    };
    '/users/report-abuse': {
        post: operations['users___report-abuse'];
    };
    '/users/search': {
        post: operations['users___search'];
    };
    '/users/search-by-username-and-host': {
        post: operations['users___search-by-username-and-host'];
    };
    '/users/show': {
        post: operations['users___show'];
    };
    '/users/update-memo': {
        post: operations['users___update-memo'];
    };
    '/v2/admin/emoji/list': {
        post: operations['v2___admin___emoji___list'];
    };
    '/verify-email': {
        post: operations['verify-email'];
    };
};
export type webhooks = Record<string, never>;
export type components = {
    schemas: {
        Error: {
            error: {
                code: string;
                message: string;
                id: string;
            };
        };
        UserLite: {
            id: string;
            name: string | null;
            username: string;
            host: string | null;
            avatarUrl: string;
            avatarBlurhash: string | null;
            avatarDecorations: {
                id: string;
                angle?: number;
                flipH?: boolean;
                url: string;
                offsetX?: number;
                offsetY?: number;
            }[];
            isBot?: boolean;
            isCat?: boolean;
            requireSigninToViewContents?: boolean;
            makeNotesFollowersOnlyBefore?: number | null;
            makeNotesHiddenBefore?: number | null;
            instance?: {
                name: string | null;
                softwareName: string | null;
                softwareVersion: string | null;
                iconUrl: string | null;
                faviconUrl: string | null;
                themeColor: string | null;
            };
            emojis: {
                [key: string]: string;
            };
            onlineStatus: 'unknown' | 'online' | 'active' | 'offline';
            badgeRoles?: {
                name: string;
                iconUrl: string | null;
                displayOrder: number;
            }[];
        };
        UserDetailedNotMeOnly: {
            url: string | null;
            uri: string | null;
            movedTo: string | null;
            alsoKnownAs: string[] | null;
            createdAt: string;
            updatedAt: string | null;
            lastFetchedAt: string | null;
            bannerUrl: string | null;
            bannerBlurhash: string | null;
            isLocked: boolean;
            isSilenced: boolean;
            isSuspended: boolean;
            description: string | null;
            location: string | null;
            birthday: string | null;
            lang: string | null;
            fields: {
                name: string;
                value: string;
            }[];
            verifiedLinks: string[];
            followersCount: number;
            followingCount: number;
            notesCount: number;
            pinnedNoteIds: string[];
            pinnedNotes: components['schemas']['Note'][];
            pinnedPageId: string | null;
            pinnedPage: components['schemas']['Page'] | null;
            publicReactions: boolean;
            followingVisibility: 'public' | 'followers' | 'private';
            followersVisibility: 'public' | 'followers' | 'private';
            chatScope: 'everyone' | 'following' | 'followers' | 'mutual' | 'none';
            canChat: boolean;
            roles: components['schemas']['RoleLite'][];
            followedMessage?: string | null;
            memo: string | null;
            moderationNote?: string;
            twoFactorEnabled?: boolean;
            usePasswordLessLogin?: boolean;
            securityKeys?: boolean;
            isFollowing?: boolean;
            isFollowed?: boolean;
            hasPendingFollowRequestFromYou?: boolean;
            hasPendingFollowRequestToYou?: boolean;
            isBlocking?: boolean;
            isBlocked?: boolean;
            isMuted?: boolean;
            isRenoteMuted?: boolean;
            notify?: 'normal' | 'none';
            withReplies?: boolean;
        };
        MeDetailedOnly: {
            avatarId: string | null;
            bannerId: string | null;
            followedMessage: string | null;
            isModerator: boolean;
            isAdmin: boolean;
            injectFeaturedNote: boolean;
            receiveAnnouncementEmail: boolean;
            alwaysMarkNsfw: boolean;
            autoSensitive: boolean;
            carefulBot: boolean;
            autoAcceptFollowed: boolean;
            noCrawle: boolean;
            preventAiLearning: boolean;
            isExplorable: boolean;
            isDeleted: boolean;
            twoFactorBackupCodesStock: 'full' | 'partial' | 'none';
            hideOnlineStatus: boolean;
            hasUnreadSpecifiedNotes: boolean;
            hasUnreadMentions: boolean;
            hasUnreadAnnouncement: boolean;
            unreadAnnouncements: components['schemas']['Announcement'][];
            hasUnreadAntenna: boolean;
            hasUnreadChannel: boolean;
            hasUnreadChatMessages: boolean;
            hasUnreadNotification: boolean;
            hasPendingReceivedFollowRequest: boolean;
            unreadNotificationsCount: number;
            mutedWords: string[][];
            hardMutedWords: string[][];
            mutedInstances: string[];
            notificationRecieveConfig: {
                note?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                follow?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                mention?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                reply?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                renote?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                quote?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                reaction?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                pollEnded?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                scheduledNotePosted?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                scheduledNotePostFailed?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                receiveFollowRequest?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                followRequestAccepted?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                roleAssigned?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                chatRoomInvitationReceived?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                achievementEarned?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                app?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
                test?: {
                    type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                } | {
                    type: 'list';
                    userListId: string;
                };
            };
            emailNotificationTypes: string[];
            achievements: components['schemas']['Achievement'][];
            loggedInDays: number;
            policies: components['schemas']['RolePolicies'];
            twoFactorEnabled: boolean;
            usePasswordLessLogin: boolean;
            securityKeys: boolean;
            email?: string | null;
            emailVerified?: boolean | null;
            securityKeysList?: {
                id: string;
                name: string;
                lastUsed: string;
            }[];
        };
        UserDetailedNotMe: components['schemas']['UserLite'] & components['schemas']['UserDetailedNotMeOnly'];
        MeDetailed: components['schemas']['UserLite'] & components['schemas']['UserDetailedNotMeOnly'] & components['schemas']['MeDetailedOnly'];
        UserDetailed: components['schemas']['UserDetailedNotMe'] | components['schemas']['MeDetailed'];
        User: components['schemas']['UserLite'] | components['schemas']['UserDetailed'];
        UserList: {
            id: string;
            createdAt: string;
            name: string;
            userIds?: string[];
            isPublic: boolean;
        };
        Achievement: {
            name: components['schemas']['AchievementName'];
            unlockedAt: number;
        };
        AchievementName: 'notes1' | 'notes10' | 'notes100' | 'notes500' | 'notes1000' | 'notes5000' | 'notes10000' | 'notes20000' | 'notes30000' | 'notes40000' | 'notes50000' | 'notes60000' | 'notes70000' | 'notes80000' | 'notes90000' | 'notes100000' | 'login3' | 'login7' | 'login15' | 'login30' | 'login60' | 'login100' | 'login200' | 'login300' | 'login400' | 'login500' | 'login600' | 'login700' | 'login800' | 'login900' | 'login1000' | 'passedSinceAccountCreated1' | 'passedSinceAccountCreated2' | 'passedSinceAccountCreated3' | 'loggedInOnBirthday' | 'loggedInOnNewYearsDay' | 'noteClipped1' | 'noteFavorited1' | 'myNoteFavorited1' | 'profileFilled' | 'markedAsCat' | 'following1' | 'following10' | 'following50' | 'following100' | 'following300' | 'followers1' | 'followers10' | 'followers50' | 'followers100' | 'followers300' | 'followers500' | 'followers1000' | 'collectAchievements30' | 'viewAchievements3min' | 'iLoveMisskey' | 'foundTreasure' | 'client30min' | 'client60min' | 'noteDeletedWithin1min' | 'postedAtLateNight' | 'postedAt0min0sec' | 'selfQuote' | 'htl20npm' | 'viewInstanceChart' | 'outputHelloWorldOnScratchpad' | 'open3windows' | 'driveFolderCircularReference' | 'reactWithoutRead' | 'clickedClickHere' | 'justPlainLucky' | 'setNameToSyuilo' | 'cookieClicked' | 'brainDiver' | 'smashTestNotificationButton' | 'tutorialCompleted' | 'bubbleGameExplodingHead' | 'bubbleGameDoubleExplodingHead';
        Ad: {
            id: string;
            expiresAt: string;
            startsAt: string;
            place: string;
            priority: string;
            ratio: number;
            url: string;
            imageUrl: string;
            memo: string;
            dayOfWeek: number;
            isSensitive: boolean;
        };
        Announcement: {
            id: string;
            createdAt: string;
            updatedAt: string | null;
            text: string;
            title: string;
            imageUrl: string | null;
            icon: 'info' | 'warning' | 'error' | 'success';
            display: 'dialog' | 'normal' | 'banner';
            needConfirmationToRead: boolean;
            silence: boolean;
            forYou: boolean;
            isRead?: boolean;
        };
        App: {
            id: string;
            name: string;
            callbackUrl: string | null;
            permission: string[];
            secret?: string;
            isAuthorized?: boolean;
        };
        Note: {
            id: string;
            createdAt: string;
            deletedAt?: string | null;
            text: string | null;
            cw?: string | null;
            userId: string;
            user: components['schemas']['UserLite'];
            replyId?: string | null;
            renoteId?: string | null;
            reply?: components['schemas']['Note'] | null;
            renote?: components['schemas']['Note'] | null;
            isHidden?: boolean;
            visibility: 'public' | 'home' | 'followers' | 'specified';
            mentions?: string[];
            visibleUserIds?: string[];
            fileIds?: string[];
            files?: components['schemas']['DriveFile'][];
            tags?: string[];
            poll?: {
                expiresAt?: string | null;
                multiple: boolean;
                choices: {
                    isVoted: boolean;
                    text: string;
                    votes: number;
                }[];
            } | null;
            emojis?: {
                [key: string]: string;
            };
            channelId?: string | null;
            channel?: {
                id: string;
                name: string;
                color: string;
                isSensitive: boolean;
                allowRenoteToExternal: boolean;
                userId: string | null;
            } | null;
            localOnly?: boolean;
            reactionAcceptance: 'likeOnly' | 'likeOnlyForRemote' | 'nonSensitiveOnly' | 'nonSensitiveOnlyForLocalLikeOnlyForRemote' | null;
            reactionEmojis: {
                [key: string]: string;
            };
            reactions: {
                [key: string]: number;
            };
            reactionCount: number;
            renoteCount: number;
            repliesCount: number;
            uri?: string;
            url?: string;
            reactionAndUserPairCache?: string[];
            clippedCount?: number;
            hasPoll?: boolean;
            myReaction?: string | null;
        };
        NoteDraft: {
            id: string;
            createdAt: string;
            text: string | null;
            cw: string | null;
            userId: string;
            user: components['schemas']['UserLite'];
            replyId: string | null;
            renoteId: string | null;
            reply?: components['schemas']['Note'] | null;
            renote?: components['schemas']['Note'] | null;
            visibility: 'public' | 'home' | 'followers' | 'specified';
            visibleUserIds: string[];
            fileIds: string[];
            files?: components['schemas']['DriveFile'][];
            hashtag: string | null;
            poll: {
                expiresAt?: string | null;
                expiredAfter?: number | null;
                multiple: boolean;
                choices: string[];
            } | null;
            channelId: string | null;
            channel?: {
                id: string;
                name: string;
                color: string;
                isSensitive: boolean;
                allowRenoteToExternal: boolean;
                userId: string | null;
            } | null;
            localOnly: boolean;
            reactionAcceptance: 'likeOnly' | 'likeOnlyForRemote' | 'nonSensitiveOnly' | 'nonSensitiveOnlyForLocalLikeOnlyForRemote' | null;
            scheduledAt: number | null;
            isActuallyScheduled: boolean;
        };
        NoteReaction: {
            id: string;
            createdAt: string;
            user: components['schemas']['UserLite'];
            type: string;
        };
        NoteReactionWithNote: {
            id: string;
            createdAt: string;
            user: components['schemas']['UserLite'];
            type: string;
            note: components['schemas']['Note'];
        };
        NoteFavorite: {
            id: string;
            createdAt: string;
            note: components['schemas']['Note'];
            noteId: string;
        };
        Notification: {
            id: string;
            createdAt: string;
            type: 'note';
            user: components['schemas']['UserLite'];
            userId: string;
            note: components['schemas']['Note'];
        } | {
            id: string;
            createdAt: string;
            type: 'mention';
            user: components['schemas']['UserLite'];
            userId: string;
            note: components['schemas']['Note'];
        } | {
            id: string;
            createdAt: string;
            type: 'reply';
            user: components['schemas']['UserLite'];
            userId: string;
            note: components['schemas']['Note'];
        } | {
            id: string;
            createdAt: string;
            type: 'renote';
            user: components['schemas']['UserLite'];
            userId: string;
            note: components['schemas']['Note'];
        } | {
            id: string;
            createdAt: string;
            type: 'quote';
            user: components['schemas']['UserLite'];
            userId: string;
            note: components['schemas']['Note'];
        } | {
            id: string;
            createdAt: string;
            type: 'reaction';
            user: components['schemas']['UserLite'];
            userId: string;
            note: components['schemas']['Note'];
            reaction: string;
        } | {
            id: string;
            createdAt: string;
            type: 'pollEnded';
            user: components['schemas']['UserLite'];
            userId: string;
            note: components['schemas']['Note'];
        } | {
            id: string;
            createdAt: string;
            type: 'scheduledNotePosted';
            note: components['schemas']['Note'];
        } | {
            id: string;
            createdAt: string;
            type: 'scheduledNotePostFailed';
            noteDraft: components['schemas']['NoteDraft'];
        } | {
            id: string;
            createdAt: string;
            type: 'follow';
            user: components['schemas']['UserLite'];
            userId: string;
        } | {
            id: string;
            createdAt: string;
            type: 'receiveFollowRequest';
            user: components['schemas']['UserLite'];
            userId: string;
        } | {
            id: string;
            createdAt: string;
            type: 'followRequestAccepted';
            user: components['schemas']['UserLite'];
            userId: string;
            message: string | null;
        } | {
            id: string;
            createdAt: string;
            type: 'roleAssigned';
            role: components['schemas']['Role'];
        } | {
            id: string;
            createdAt: string;
            type: 'chatRoomInvitationReceived';
            invitation: components['schemas']['ChatRoomInvitation'];
        } | {
            id: string;
            createdAt: string;
            type: 'achievementEarned';
            achievement: components['schemas']['AchievementName'];
        } | {
            id: string;
            createdAt: string;
            type: 'exportCompleted';
            exportedEntity: 'antenna' | 'blocking' | 'clip' | 'customEmoji' | 'favorite' | 'following' | 'muting' | 'note' | 'userList';
            fileId: string;
        } | {
            id: string;
            createdAt: string;
            type: 'login';
        } | {
            id: string;
            createdAt: string;
            type: 'createToken';
        } | {
            id: string;
            createdAt: string;
            type: 'app';
            body: string;
            header: string | null;
            icon: string | null;
        } | {
            id: string;
            createdAt: string;
            type: 'reaction:grouped';
            note: components['schemas']['Note'];
            reactions: {
                user: components['schemas']['UserLite'];
                reaction: string;
            }[];
        } | {
            id: string;
            createdAt: string;
            type: 'renote:grouped';
            note: components['schemas']['Note'];
            users: components['schemas']['UserLite'][];
        } | {
            id: string;
            createdAt: string;
            type: 'test';
        };
        DriveFile: {
            id: string;
            createdAt: string;
            name: string;
            type: string;
            md5: string;
            size: number;
            isSensitive: boolean;
            blurhash: string | null;
            properties: {
                width?: number;
                height?: number;
                orientation?: number;
                avgColor?: string;
            };
            url: string;
            thumbnailUrl: string | null;
            comment: string | null;
            folderId: string | null;
            folder?: components['schemas']['DriveFolder'] | null;
            userId: string | null;
            user?: components['schemas']['UserLite'] | null;
        };
        DriveFolder: {
            id: string;
            createdAt: string;
            name: string;
            parentId: string | null;
            foldersCount?: number;
            filesCount?: number;
            parent?: components['schemas']['DriveFolder'] | null;
        };
        Following: {
            id: string;
            createdAt: string;
            followeeId: string;
            followerId: string;
            followee?: components['schemas']['UserDetailedNotMe'];
            follower?: components['schemas']['UserDetailedNotMe'];
        };
        Muting: {
            id: string;
            createdAt: string;
            expiresAt: string | null;
            muteeId: string;
            mutee: components['schemas']['UserDetailedNotMe'];
        };
        RenoteMuting: {
            id: string;
            createdAt: string;
            muteeId: string;
            mutee: components['schemas']['UserDetailedNotMe'];
        };
        Blocking: {
            id: string;
            createdAt: string;
            blockeeId: string;
            blockee: components['schemas']['UserDetailedNotMe'];
        };
        Hashtag: {
            tag: string;
            mentionedUsersCount: number;
            mentionedLocalUsersCount: number;
            mentionedRemoteUsersCount: number;
            attachedUsersCount: number;
            attachedLocalUsersCount: number;
            attachedRemoteUsersCount: number;
        };
        InviteCode: {
            id: string;
            code: string;
            expiresAt: string | null;
            createdAt: string;
            createdBy: components['schemas']['UserLite'] | null;
            usedBy: components['schemas']['UserLite'] | null;
            usedAt: string | null;
            used: boolean;
        };
        Page: {
            id: string;
            createdAt: string;
            updatedAt: string;
            userId: string;
            user: components['schemas']['UserLite'];
            content: components['schemas']['PageBlock'][];
            variables: Record<string, never>[];
            title: string;
            name: string;
            summary: string | null;
            hideTitleWhenPinned: boolean;
            alignCenter: boolean;
            font: 'serif' | 'sans-serif';
            script: string;
            eyeCatchingImageId: string | null;
            eyeCatchingImage: components['schemas']['DriveFile'] | null;
            attachedFiles: components['schemas']['DriveFile'][];
            likedCount: number;
            isLiked?: boolean;
        };
        PageBlock: {
            id: string;
            type: 'text';
            text: string;
        } | {
            id: string;
            type: 'section';
            title: string;
            children: components['schemas']['PageBlock'][];
        } | {
            id: string;
            type: 'image';
            fileId: string | null;
        } | {
            id: string;
            type: 'note';
            detailed: boolean;
            note: string | null;
        };
        Channel: {
            id: string;
            createdAt: string;
            lastNotedAt: string | null;
            name: string;
            description: string | null;
            userId: string | null;
            bannerUrl: string | null;
            bannerId: string | null;
            pinnedNoteIds: string[];
            color: string;
            isArchived: boolean;
            usersCount: number;
            notesCount: number;
            isSensitive: boolean;
            allowRenoteToExternal: boolean;
            isFollowing?: boolean;
            isFavorited?: boolean;
            isMuting?: boolean;
            pinnedNotes?: components['schemas']['Note'][];
        };
        QueueCount: {
            waiting: number;
            active: number;
            completed: number;
            failed: number;
            delayed: number;
        };
        QueueMetrics: {
            meta: {
                count: number;
                prevTS: number;
                prevCount: number;
            };
            data: number[];
            count: number;
        };
        QueueJob: {
            id: string;
            name: string;
            data: Record<string, never>;
            opts: Record<string, never>;
            timestamp: number;
            processedOn?: number;
            processedBy?: string;
            finishedOn?: number;
            progress: Record<string, never>;
            attempts: number;
            delay: number;
            failedReason: string;
            stacktrace: string[];
            returnValue: Record<string, never>;
            isFailed: boolean;
        };
        Antenna: {
            id: string;
            createdAt: string;
            name: string;
            keywords: string[][];
            excludeKeywords: string[][];
            src: 'home' | 'all' | 'users' | 'list' | 'users_blacklist';
            userListId: string | null;
            users: string[];
            caseSensitive: boolean;
            localOnly: boolean;
            excludeBots: boolean;
            withReplies: boolean;
            withFile: boolean;
            isActive: boolean;
            hasUnreadNote: boolean;
            notify: boolean;
            excludeNotesInSensitiveChannel: boolean;
        };
        Clip: {
            id: string;
            createdAt: string;
            lastClippedAt: string | null;
            userId: string;
            user: components['schemas']['UserLite'];
            name: string;
            description: string | null;
            isPublic: boolean;
            favoritedCount: number;
            isFavorited?: boolean;
            notesCount?: number;
        };
        FederationInstance: {
            id: string;
            firstRetrievedAt: string;
            host: string;
            usersCount: number;
            notesCount: number;
            followingCount: number;
            followersCount: number;
            isNotResponding: boolean;
            isSuspended: boolean;
            suspensionState: 'none' | 'manuallySuspended' | 'goneSuspended' | 'autoSuspendedForNotResponding' | 'softwareSuspended';
            isBlocked: boolean;
            softwareName: string | null;
            softwareVersion: string | null;
            openRegistrations: boolean | null;
            name: string | null;
            description: string | null;
            maintainerName: string | null;
            maintainerEmail: string | null;
            isSilenced: boolean;
            isMediaSilenced: boolean;
            iconUrl: string | null;
            faviconUrl: string | null;
            themeColor: string | null;
            infoUpdatedAt: string | null;
            latestRequestReceivedAt: string | null;
            moderationNote?: string | null;
        };
        GalleryPost: {
            id: string;
            createdAt: string;
            updatedAt: string;
            userId: string;
            user: components['schemas']['UserLite'];
            title: string;
            description: string | null;
            fileIds?: string[];
            files?: components['schemas']['DriveFile'][];
            tags?: string[];
            isSensitive: boolean;
            likedCount: number;
            isLiked?: boolean;
        };
        EmojiSimple: {
            aliases: string[];
            name: string;
            category: string | null;
            url: string;
            localOnly?: boolean;
            isSensitive?: boolean;
            roleIdsThatCanBeUsedThisEmojiAsReaction?: string[];
        };
        EmojiDetailed: {
            id: string;
            aliases: string[];
            name: string;
            category: string | null;
            host: string | null;
            url: string;
            license: string | null;
            isSensitive: boolean;
            localOnly: boolean;
            roleIdsThatCanBeUsedThisEmojiAsReaction: string[];
        };
        EmojiDetailedAdmin: {
            id: string;
            updatedAt: string | null;
            name: string;
            host: string | null;
            publicUrl: string;
            originalUrl: string;
            uri: string | null;
            type: string | null;
            aliases: string[];
            category: string | null;
            license: string | null;
            localOnly: boolean;
            isSensitive: boolean;
            roleIdsThatCanBeUsedThisEmojiAsReaction: {
                id: string;
                name: string;
            }[];
        };
        Flash: {
            id: string;
            createdAt: string;
            updatedAt: string;
            userId: string;
            user: components['schemas']['UserLite'];
            title: string;
            summary: string;
            script: string;
            visibility: 'private' | 'public';
            likedCount: number;
            isLiked?: boolean;
        };
        Signin: {
            id: string;
            createdAt: string;
            ip: string;
            headers: Record<string, never>;
            success: boolean;
        };
        RoleCondFormulaLogics: {
            id: string;
            type: 'and' | 'or';
            values: components['schemas']['RoleCondFormulaValue'][];
        };
        RoleCondFormulaValueNot: {
            id: string;
            type: 'not';
            value: components['schemas']['RoleCondFormulaValue'];
        };
        RoleCondFormulaValueIsLocalOrRemote: {
            id: string;
            type: 'isLocal' | 'isRemote';
        };
        RoleCondFormulaValueUserSettingBooleanSchema: {
            id: string;
            type: 'isSuspended' | 'isLocked' | 'isBot' | 'isCat' | 'isExplorable';
        };
        RoleCondFormulaValueAssignedRole: {
            id: string;
            type: 'roleAssignedTo';
            roleId: string;
        };
        RoleCondFormulaValueCreated: {
            id: string;
            type: 'createdLessThan' | 'createdMoreThan';
            sec: number;
        };
        RoleCondFormulaFollowersOrFollowingOrNotes: {
            id: string;
            type: 'followersLessThanOrEq' | 'followersMoreThanOrEq' | 'followingLessThanOrEq' | 'followingMoreThanOrEq' | 'notesLessThanOrEq' | 'notesMoreThanOrEq';
            value: number;
        };
        RoleCondFormulaValue: components['schemas']['RoleCondFormulaLogics'] | components['schemas']['RoleCondFormulaValueNot'] | components['schemas']['RoleCondFormulaValueIsLocalOrRemote'] | components['schemas']['RoleCondFormulaValueUserSettingBooleanSchema'] | components['schemas']['RoleCondFormulaValueAssignedRole'] | components['schemas']['RoleCondFormulaValueCreated'] | components['schemas']['RoleCondFormulaFollowersOrFollowingOrNotes'];
        RoleLite: {
            id: string;
            name: string;
            color: string | null;
            iconUrl: string | null;
            description: string;
            isModerator: boolean;
            isAdministrator: boolean;
            displayOrder: number;
        };
        Role: components['schemas']['RoleLite'] & {
            createdAt: string;
            updatedAt: string;
            target: 'manual' | 'conditional';
            condFormula: components['schemas']['RoleCondFormulaValue'];
            isPublic: boolean;
            isExplorable: boolean;
            asBadge: boolean;
            preserveAssignmentOnMoveAccount: boolean;
            canEditMembersByModerator: boolean;
            policies: {
                [key: string]: {
                    value?: number | boolean;
                    priority?: number;
                    useDefault?: boolean;
                };
            };
            usersCount: number;
        };
        RolePolicies: {
            gtlAvailable: boolean;
            ltlAvailable: boolean;
            canPublicNote: boolean;
            mentionLimit: number;
            canInvite: boolean;
            inviteLimit: number;
            inviteLimitCycle: number;
            inviteExpirationTime: number;
            canManageCustomEmojis: boolean;
            canManageAvatarDecorations: boolean;
            canSearchNotes: boolean;
            canSearchUsers: boolean;
            canUseTranslator: boolean;
            canHideAds: boolean;
            driveCapacityMb: number;
            maxFileSizeMb: number;
            uploadableFileTypes: string[];
            alwaysMarkNsfw: boolean;
            canUpdateBioMedia: boolean;
            pinLimit: number;
            antennaLimit: number;
            wordMuteLimit: number;
            webhookLimit: number;
            clipLimit: number;
            noteEachClipsLimit: number;
            userListLimit: number;
            userEachUserListsLimit: number;
            rateLimitFactor: number;
            avatarDecorationLimit: number;
            canImportAntennas: boolean;
            canImportBlocking: boolean;
            canImportFollowing: boolean;
            canImportMuting: boolean;
            canImportUserLists: boolean;
            chatAvailability: 'available' | 'readonly' | 'unavailable';
            noteDraftLimit: number;
            scheduledNoteLimit: number;
            watermarkAvailable: boolean;
        };
        ReversiGameLite: {
            id: string;
            createdAt: string;
            startedAt: string | null;
            endedAt: string | null;
            isStarted: boolean;
            isEnded: boolean;
            user1Id: string;
            user2Id: string;
            user1: components['schemas']['UserLite'];
            user2: components['schemas']['UserLite'];
            winnerId: string | null;
            winner: components['schemas']['UserLite'] | null;
            surrenderedUserId: string | null;
            timeoutUserId: string | null;
            black: number | null;
            bw: string;
            noIrregularRules: boolean;
            isLlotheo: boolean;
            canPutEverywhere: boolean;
            loopedBoard: boolean;
            timeLimitForEachTurn: number;
        };
        ReversiGameDetailed: {
            id: string;
            createdAt: string;
            startedAt: string | null;
            endedAt: string | null;
            isStarted: boolean;
            isEnded: boolean;
            form1: Record<string, never> | null;
            form2: Record<string, never> | null;
            user1Ready: boolean;
            user2Ready: boolean;
            user1Id: string;
            user2Id: string;
            user1: components['schemas']['UserLite'];
            user2: components['schemas']['UserLite'];
            winnerId: string | null;
            winner: components['schemas']['UserLite'] | null;
            surrenderedUserId: string | null;
            timeoutUserId: string | null;
            black: number | null;
            bw: string;
            noIrregularRules: boolean;
            isLlotheo: boolean;
            canPutEverywhere: boolean;
            loopedBoard: boolean;
            timeLimitForEachTurn: number;
            logs: number[][];
            map: string[];
        };
        MetaLite: {
            maintainerName: string | null;
            maintainerEmail: string | null;
            version: string;
            providesTarball: boolean;
            name: string | null;
            shortName: string | null;
            uri: string;
            description: string | null;
            langs: string[];
            tosUrl: string | null;
            repositoryUrl: string | null;
            feedbackUrl: string | null;
            defaultDarkTheme: string | null;
            defaultLightTheme: string | null;
            clientOptions: Record<string, never>;
            disableRegistration: boolean;
            emailRequiredForSignup: boolean;
            enableHcaptcha: boolean;
            hcaptchaSiteKey: string | null;
            enableMcaptcha: boolean;
            mcaptchaSiteKey: string | null;
            mcaptchaInstanceUrl: string | null;
            enableRecaptcha: boolean;
            recaptchaSiteKey: string | null;
            enableTurnstile: boolean;
            turnstileSiteKey: string | null;
            enableTestcaptcha: boolean;
            googleAnalyticsMeasurementId: string | null;
            swPublickey: string | null;
            mascotImageUrl: string;
            bannerUrl: string | null;
            serverErrorImageUrl: string | null;
            infoImageUrl: string | null;
            notFoundImageUrl: string | null;
            iconUrl: string | null;
            maxNoteTextLength: number;
            ads: {
                id: string;
                url: string;
                place: string;
                ratio: number;
                imageUrl: string;
                dayOfWeek: number;
                isSensitive?: boolean;
            }[];
            notesPerOneAd: number;
            enableEmail: boolean;
            enableServiceWorker: boolean;
            translatorAvailable: boolean;
            sentryForFrontend: {
                options: {
                    dsn: string;
                } & {
                    [key: string]: unknown;
                };
                vueIntegration?: {
                    [key: string]: unknown;
                } | null;
                browserTracingIntegration?: {
                    [key: string]: unknown;
                } | null;
                replayIntegration?: {
                    [key: string]: unknown;
                } | null;
            } | null;
            mediaProxy: string;
            enableUrlPreview: boolean;
            backgroundImageUrl: string | null;
            impressumUrl: string | null;
            logoImageUrl: string | null;
            privacyPolicyUrl: string | null;
            inquiryUrl: string | null;
            serverRules: string[];
            themeColor: string | null;
            policies: components['schemas']['RolePolicies'];
            noteSearchableScope: 'local' | 'global';
            maxFileSize: number;
            federation: 'all' | 'specified' | 'none';
        };
        MetaDetailedOnly: {
            features?: {
                registration: boolean;
                emailRequiredForSignup: boolean;
                localTimeline: boolean;
                globalTimeline: boolean;
                hcaptcha: boolean;
                turnstile: boolean;
                recaptcha: boolean;
                objectStorage: boolean;
                serviceWorker: boolean;
                miauth: boolean;
            };
            proxyAccountName: string | null;
            requireSetup: boolean;
            cacheRemoteFiles: boolean;
            cacheRemoteSensitiveFiles: boolean;
        };
        MetaDetailed: components['schemas']['MetaLite'] & components['schemas']['MetaDetailedOnly'];
        UserWebhook: {
            id: string;
            userId: string;
            name: string;
            on: ('mention' | 'unfollow' | 'follow' | 'followed' | 'note' | 'reply' | 'renote' | 'reaction')[];
            url: string;
            secret: string;
            active: boolean;
            latestSentAt: string | null;
            latestStatus: number | null;
        };
        SystemWebhook: {
            id: string;
            isActive: boolean;
            updatedAt: string;
            latestSentAt: string | null;
            latestStatus: number | null;
            name: string;
            on: ('abuseReport' | 'abuseReportResolved' | 'userCreated' | 'inactiveModeratorsWarning' | 'inactiveModeratorsInvitationOnlyChanged')[];
            url: string;
            secret: string;
        };
        AbuseReportNotificationRecipient: {
            id: string;
            isActive: boolean;
            updatedAt: string;
            name: string;
            method: 'email' | 'webhook';
            userId?: string;
            user?: components['schemas']['UserLite'];
            systemWebhookId?: string;
            systemWebhook?: components['schemas']['SystemWebhook'];
        };
        ChatMessage: {
            id: string;
            createdAt: string;
            fromUserId: string;
            fromUser: components['schemas']['UserLite'];
            toUserId?: string | null;
            toUser?: components['schemas']['UserLite'] | null;
            toRoomId?: string | null;
            toRoom?: components['schemas']['ChatRoom'] | null;
            text?: string | null;
            fileId?: string | null;
            file?: components['schemas']['DriveFile'] | null;
            isRead?: boolean;
            reactions: {
                reaction: string;
                user: components['schemas']['UserLite'];
            }[];
        };
        ChatMessageLite: {
            id: string;
            createdAt: string;
            fromUserId: string;
            fromUser?: components['schemas']['UserLite'];
            toUserId?: string | null;
            toRoomId?: string | null;
            text?: string | null;
            fileId?: string | null;
            file?: components['schemas']['DriveFile'] | null;
            reactions: {
                reaction: string;
                user?: components['schemas']['UserLite'] | null;
            }[];
        };
        ChatMessageLiteFor1on1: {
            id: string;
            createdAt: string;
            fromUserId: string;
            toUserId: string;
            text?: string | null;
            fileId?: string | null;
            file?: components['schemas']['DriveFile'] | null;
            reactions: {
                reaction: string;
            }[];
        };
        ChatMessageLiteForRoom: {
            id: string;
            createdAt: string;
            fromUserId: string;
            fromUser: components['schemas']['UserLite'];
            toRoomId: string;
            text?: string | null;
            fileId?: string | null;
            file?: components['schemas']['DriveFile'] | null;
            reactions: {
                reaction: string;
                user: components['schemas']['UserLite'];
            }[];
        };
        ChatRoom: {
            id: string;
            createdAt: string;
            ownerId: string;
            owner: components['schemas']['UserLite'];
            name: string;
            description: string;
            isMuted?: boolean;
            invitationExists?: boolean;
        };
        ChatRoomInvitation: {
            id: string;
            createdAt: string;
            userId: string;
            user: components['schemas']['UserLite'];
            roomId: string;
            room: components['schemas']['ChatRoom'];
        };
        ChatRoomMembership: {
            id: string;
            createdAt: string;
            userId: string;
            user?: components['schemas']['UserLite'];
            roomId: string;
            room?: components['schemas']['ChatRoom'];
        };
    };
    responses: never;
    parameters: never;
    requestBodies: never;
    headers: never;
    pathItems: never;
};
export type $defs = Record<string, never>;
export interface operations {
    'admin___abuse-report___notification-recipient___create': {
        requestBody: {
            content: {
                'application/json': {
                    isActive: boolean;
                    name: string;
                    method: 'email' | 'webhook';
                    userId?: string;
                    systemWebhookId?: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['AbuseReportNotificationRecipient'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___abuse-report___notification-recipient___delete': {
        requestBody: {
            content: {
                'application/json': {
                    id: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___abuse-report___notification-recipient___list': {
        requestBody: {
            content: {
                'application/json': {
                    method?: ('email' | 'webhook')[];
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['AbuseReportNotificationRecipient'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___abuse-report___notification-recipient___show': {
        requestBody: {
            content: {
                'application/json': {
                    id: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['AbuseReportNotificationRecipient'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___abuse-report___notification-recipient___update': {
        requestBody: {
            content: {
                'application/json': {
                    id: string;
                    isActive: boolean;
                    name: string;
                    method: 'email' | 'webhook';
                    userId?: string;
                    systemWebhookId?: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['AbuseReportNotificationRecipient'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___abuse-user-reports': {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    state?: string | null;
                    reporterOrigin?: 'combined' | 'local' | 'remote';
                    targetUserOrigin?: 'combined' | 'local' | 'remote';
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        createdAt: string;
                        comment: string;
                        resolved: boolean;
                        reporterId: string;
                        targetUserId: string;
                        assigneeId: string | null;
                        reporter: components['schemas']['UserDetailedNotMe'];
                        targetUser: components['schemas']['UserDetailedNotMe'];
                        assignee: components['schemas']['UserDetailedNotMe'] | null;
                        forwarded: boolean;
                        resolvedAs: 'accept' | 'reject' | null;
                        moderationNote: string;
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___accounts___create: {
        requestBody: {
            content: {
                'application/json': {
                    username: string;
                    password: string;
                    setupPassword?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['MeDetailed'] & {
                        token: string;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___accounts___delete: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___accounts___find-by-email': {
        requestBody: {
            content: {
                'application/json': {
                    email: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserDetailedNotMe'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___ad___create: {
        requestBody: {
            content: {
                'application/json': {
                    url: string;
                    memo: string;
                    place: string;
                    priority: string;
                    ratio: number;
                    expiresAt: number;
                    startsAt: number;
                    imageUrl: string;
                    dayOfWeek: number;
                    isSensitive?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Ad'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___ad___delete: {
        requestBody: {
            content: {
                'application/json': {
                    id: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___ad___list: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    publishing?: boolean | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Ad'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___ad___update: {
        requestBody: {
            content: {
                'application/json': {
                    id: string;
                    memo?: string;
                    url?: string;
                    imageUrl?: string;
                    place?: string;
                    priority?: string;
                    ratio?: number;
                    expiresAt?: number;
                    startsAt?: number;
                    dayOfWeek?: number;
                    isSensitive?: boolean;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___announcements___create: {
        requestBody: {
            content: {
                'application/json': {
                    title: string;
                    text: string;
                    imageUrl: string | null;
                    icon?: 'info' | 'warning' | 'error' | 'success';
                    display?: 'normal' | 'banner' | 'dialog';
                    forExistingUsers?: boolean;
                    silence?: boolean;
                    needConfirmationToRead?: boolean;
                    userId?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        createdAt: string;
                        updatedAt: string | null;
                        title: string;
                        text: string;
                        imageUrl: string | null;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___announcements___delete: {
        requestBody: {
            content: {
                'application/json': {
                    id: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___announcements___list: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    userId?: string | null;
                    status?: 'all' | 'active' | 'archived';
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        createdAt: string;
                        updatedAt: string | null;
                        text: string;
                        title: string;
                        icon: string | null;
                        display: string;
                        isActive: boolean;
                        forExistingUsers: boolean;
                        silence: boolean;
                        needConfirmationToRead: boolean;
                        userId: string | null;
                        imageUrl: string | null;
                        reads: number;
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___announcements___update: {
        requestBody: {
            content: {
                'application/json': {
                    id: string;
                    title?: string;
                    text?: string;
                    imageUrl?: string | null;
                    icon?: 'info' | 'warning' | 'error' | 'success';
                    display?: 'normal' | 'banner' | 'dialog';
                    forExistingUsers?: boolean;
                    silence?: boolean;
                    needConfirmationToRead?: boolean;
                    isActive?: boolean;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___avatar-decorations___create': {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                    description: string;
                    url: string;
                    roleIdsThatCanBeUsedThisDecoration?: string[];
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        createdAt: string;
                        updatedAt: string | null;
                        name: string;
                        description: string;
                        url: string;
                        roleIdsThatCanBeUsedThisDecoration: string[];
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___avatar-decorations___delete': {
        requestBody: {
            content: {
                'application/json': {
                    id: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___avatar-decorations___list': {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    userId?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        createdAt: string;
                        updatedAt: string | null;
                        name: string;
                        description: string;
                        url: string;
                        roleIdsThatCanBeUsedThisDecoration: string[];
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___avatar-decorations___update': {
        requestBody: {
            content: {
                'application/json': {
                    id: string;
                    name?: string;
                    description?: string;
                    url?: string;
                    roleIdsThatCanBeUsedThisDecoration?: string[];
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___captcha___current: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        provider: 'none' | 'hcaptcha' | 'mcaptcha' | 'recaptcha' | 'turnstile' | 'testcaptcha';
                        hcaptcha: {
                            siteKey: string | null;
                            secretKey: string | null;
                        };
                        mcaptcha: {
                            siteKey: string | null;
                            secretKey: string | null;
                            instanceUrl: string | null;
                        };
                        recaptcha: {
                            siteKey: string | null;
                            secretKey: string | null;
                        };
                        turnstile: {
                            siteKey: string | null;
                            secretKey: string | null;
                        };
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___captcha___save: {
        requestBody: {
            content: {
                'application/json': {
                    provider: 'none' | 'hcaptcha' | 'mcaptcha' | 'recaptcha' | 'turnstile' | 'testcaptcha';
                    captchaResult?: string | null;
                    sitekey?: string | null;
                    secret?: string | null;
                    instanceUrl?: string | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___delete-account': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___delete-all-files-of-a-user': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___drive___clean-remote-files': {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___drive___cleanup: {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___drive___files: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    userId?: string | null;
                    type?: string | null;
                    origin?: 'combined' | 'local' | 'remote';
                    hostname?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['DriveFile'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___drive___show-file': {
        requestBody: {
            content: {
                'application/json': {
                    fileId: string;
                } | {
                    url: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        createdAt: string;
                        userId: string | null;
                        userHost: string | null;
                        md5: string;
                        name: string;
                        type: string;
                        size: number;
                        comment: string | null;
                        blurhash: string | null;
                        properties: {
                            width?: number;
                            height?: number;
                            orientation?: number;
                            avgColor?: string;
                        };
                        storedInternal: boolean | null;
                        url: string | null;
                        thumbnailUrl: string | null;
                        webpublicUrl: string | null;
                        accessKey: string | null;
                        thumbnailAccessKey: string | null;
                        webpublicAccessKey: string | null;
                        uri: string | null;
                        src: string | null;
                        folderId: string | null;
                        isSensitive: boolean;
                        isLink: boolean;
                        maybeSensitive: boolean;
                        maybePorn: boolean;
                        requestIp: string | null;
                        requestHeaders: Record<string, never> | null;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___emoji___add: {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                    fileId: string;
                    category?: string | null;
                    aliases?: string[];
                    license?: string | null;
                    isSensitive?: boolean;
                    localOnly?: boolean;
                    roleIdsThatCanBeUsedThisEmojiAsReaction?: string[];
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['EmojiDetailed'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___emoji___add-aliases-bulk': {
        requestBody: {
            content: {
                'application/json': {
                    ids: string[];
                    aliases: string[];
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___emoji___copy: {
        requestBody: {
            content: {
                'application/json': {
                    emojiId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___emoji___delete: {
        requestBody: {
            content: {
                'application/json': {
                    id: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___emoji___delete-bulk': {
        requestBody: {
            content: {
                'application/json': {
                    ids: string[];
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___emoji___import-zip': {
        requestBody: {
            content: {
                'application/json': {
                    fileId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___emoji___list: {
        requestBody: {
            content: {
                'application/json': {
                    query?: string | null;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        aliases: string[];
                        name: string;
                        category: string | null;
                        host: string | null;
                        url: string;
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___emoji___list-remote': {
        requestBody: {
            content: {
                'application/json': {
                    query?: string | null;
                    host?: string | null;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        aliases: string[];
                        name: string;
                        category: string | null;
                        host: string | null;
                        url: string;
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___emoji___remove-aliases-bulk': {
        requestBody: {
            content: {
                'application/json': {
                    ids: string[];
                    aliases: string[];
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___emoji___set-aliases-bulk': {
        requestBody: {
            content: {
                'application/json': {
                    ids: string[];
                    aliases: string[];
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___emoji___set-category-bulk': {
        requestBody: {
            content: {
                'application/json': {
                    ids: string[];
                    category?: string | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___emoji___set-license-bulk': {
        requestBody: {
            content: {
                'application/json': {
                    ids: string[];
                    license?: string | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___emoji___update: {
        requestBody: {
            content: {
                'application/json': ({
                    id: string;
                } | {
                    name: string;
                }) & {
                    fileId?: string;
                    category?: string | null;
                    aliases?: string[];
                    license?: string | null;
                    isSensitive?: boolean;
                    localOnly?: boolean;
                    roleIdsThatCanBeUsedThisEmojiAsReaction?: string[];
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___federation___delete-all-files': {
        requestBody: {
            content: {
                'application/json': {
                    host: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___federation___refresh-remote-instance-metadata': {
        requestBody: {
            content: {
                'application/json': {
                    host: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___federation___remove-all-following': {
        requestBody: {
            content: {
                'application/json': {
                    host: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___federation___update-instance': {
        requestBody: {
            content: {
                'application/json': {
                    host: string;
                    isSuspended?: boolean;
                    moderationNote?: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___forward-abuse-user-report': {
        requestBody: {
            content: {
                'application/json': {
                    reportId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___get-index-stats': {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        tablename: string;
                        indexname: string;
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___get-table-stats': {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        [key: string]: {
                            count: number;
                            size: number;
                        };
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___get-user-ips': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        ip: string;
                        createdAt: string;
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___invite___create: {
        requestBody: {
            content: {
                'application/json': {
                    count?: number;
                    expiresAt?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['InviteCode'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___invite___list: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    offset?: number;
                    type?: 'unused' | 'used' | 'expired' | 'all';
                    sort?: '+createdAt' | '-createdAt' | '+usedAt' | '-usedAt';
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['InviteCode'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___meta: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        cacheRemoteFiles: boolean;
                        cacheRemoteSensitiveFiles: boolean;
                        emailRequiredForSignup: boolean;
                        enableHcaptcha: boolean;
                        hcaptchaSiteKey: string | null;
                        enableMcaptcha: boolean;
                        mcaptchaSiteKey: string | null;
                        mcaptchaInstanceUrl: string | null;
                        enableRecaptcha: boolean;
                        recaptchaSiteKey: string | null;
                        enableTurnstile: boolean;
                        turnstileSiteKey: string | null;
                        enableTestcaptcha: boolean;
                        googleAnalyticsMeasurementId: string | null;
                        swPublickey: string | null;
                        mascotImageUrl: string | null;
                        bannerUrl: string | null;
                        serverErrorImageUrl: string | null;
                        infoImageUrl: string | null;
                        notFoundImageUrl: string | null;
                        iconUrl: string | null;
                        app192IconUrl: string | null;
                        app512IconUrl: string | null;
                        enableEmail: boolean;
                        enableServiceWorker: boolean;
                        translatorAvailable: boolean;
                        silencedHosts?: string[];
                        mediaSilencedHosts: string[];
                        pinnedUsers: string[];
                        hiddenTags: string[];
                        blockedHosts: string[];
                        sensitiveWords: string[];
                        prohibitedWords: string[];
                        prohibitedWordsForNameOfUser: string[];
                        bannedEmailDomains?: string[];
                        preservedUsernames: string[];
                        hcaptchaSecretKey: string | null;
                        mcaptchaSecretKey: string | null;
                        recaptchaSecretKey: string | null;
                        turnstileSecretKey: string | null;
                        sensitiveMediaDetection: 'none' | 'all' | 'local' | 'remote';
                        sensitiveMediaDetectionSensitivity: 'medium' | 'low' | 'high' | 'veryLow' | 'veryHigh';
                        setSensitiveFlagAutomatically: boolean;
                        enableSensitiveMediaDetectionForVideos: boolean;
                        proxyAccountId: string;
                        email: string | null;
                        smtpSecure: boolean;
                        smtpHost: string | null;
                        smtpPort: number | null;
                        smtpUser: string | null;
                        smtpPass: string | null;
                        swPrivateKey: string | null;
                        useObjectStorage: boolean;
                        objectStorageBaseUrl: string | null;
                        objectStorageBucket: string | null;
                        objectStoragePrefix: string | null;
                        objectStorageEndpoint: string | null;
                        objectStorageRegion: string | null;
                        objectStoragePort: number | null;
                        objectStorageAccessKey: string | null;
                        objectStorageSecretKey: string | null;
                        objectStorageUseSSL: boolean;
                        objectStorageUseProxy: boolean;
                        objectStorageSetPublicRead: boolean;
                        enableIpLogging: boolean;
                        enableActiveEmailValidation: boolean;
                        enableVerifymailApi: boolean;
                        verifymailAuthKey: string | null;
                        enableTruemailApi: boolean;
                        truemailInstance: string | null;
                        truemailAuthKey: string | null;
                        enableChartsForRemoteUser: boolean;
                        enableChartsForFederatedInstances: boolean;
                        enableStatsForFederatedInstances: boolean;
                        enableServerMachineStats: boolean;
                        enableIdenticonGeneration: boolean;
                        manifestJsonOverride: string;
                        policies: Record<string, never>;
                        enableFanoutTimeline: boolean;
                        enableFanoutTimelineDbFallback: boolean;
                        perLocalUserUserTimelineCacheMax: number;
                        perRemoteUserUserTimelineCacheMax: number;
                        perUserHomeTimelineCacheMax: number;
                        perUserListTimelineCacheMax: number;
                        enableReactionsBuffering: boolean;
                        notesPerOneAd: number;
                        backgroundImageUrl: string | null;
                        deeplAuthKey: string | null;
                        deeplIsPro: boolean;
                        defaultDarkTheme: string | null;
                        defaultLightTheme: string | null;
                        clientOptions: Record<string, never>;
                        description: string | null;
                        disableRegistration: boolean;
                        impressumUrl: string | null;
                        maintainerEmail: string | null;
                        maintainerName: string | null;
                        name: string | null;
                        shortName: string | null;
                        objectStorageS3ForcePathStyle: boolean;
                        privacyPolicyUrl: string | null;
                        inquiryUrl: string | null;
                        repositoryUrl: string | null;
                        feedbackUrl: string | null;
                        summalyProxy: string | null;
                        themeColor: string | null;
                        tosUrl: string | null;
                        uri: string;
                        version: string;
                        urlPreviewEnabled: boolean;
                        urlPreviewAllowRedirect: boolean;
                        urlPreviewTimeout: number;
                        urlPreviewMaximumContentLength: number;
                        urlPreviewRequireContentLength: boolean;
                        urlPreviewUserAgent: string | null;
                        urlPreviewSummaryProxyUrl: string | null;
                        federation: 'all' | 'specified' | 'none';
                        federationHosts: string[];
                        deliverSuspendedSoftware: {
                            software: string;
                            versionRange: string;
                        }[];
                        singleUserMode: boolean;
                        ugcVisibilityForVisitor: 'all' | 'local' | 'none';
                        proxyRemoteFiles: boolean;
                        signToActivityPubGet: boolean;
                        allowExternalApRedirect: boolean;
                        enableRemoteNotesCleaning: boolean;
                        remoteNotesCleaningExpiryDaysForEachNotes: number;
                        remoteNotesCleaningMaxProcessingDurationInMinutes: number;
                        showRoleBadgesOfRemoteUsers: boolean;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___promo___create: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                    expiresAt: number;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___queue___clear: {
        requestBody: {
            content: {
                'application/json': {
                    queue: 'system' | 'endedPollNotification' | 'postScheduledNote' | 'deliver' | 'inbox' | 'db' | 'relationship' | 'objectStorage' | 'userWebhookDeliver' | 'systemWebhookDeliver';
                    state: '*' | 'completed' | 'wait' | 'active' | 'paused' | 'prioritized' | 'delayed' | 'failed';
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___queue___deliver-delayed': {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': [
                        string,
                        number
                    ][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___queue___inbox-delayed': {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': [
                        string,
                        number
                    ][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___queue___jobs: {
        requestBody: {
            content: {
                'application/json': {
                    queue: 'system' | 'endedPollNotification' | 'postScheduledNote' | 'deliver' | 'inbox' | 'db' | 'relationship' | 'objectStorage' | 'userWebhookDeliver' | 'systemWebhookDeliver';
                    state: ('active' | 'wait' | 'delayed' | 'completed' | 'failed' | 'paused')[];
                    search?: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['QueueJob'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___queue___promote-jobs': {
        requestBody: {
            content: {
                'application/json': {
                    queue: 'system' | 'endedPollNotification' | 'postScheduledNote' | 'deliver' | 'inbox' | 'db' | 'relationship' | 'objectStorage' | 'userWebhookDeliver' | 'systemWebhookDeliver';
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___queue___queue-stats': {
        requestBody: {
            content: {
                'application/json': {
                    queue: 'system' | 'endedPollNotification' | 'postScheduledNote' | 'deliver' | 'inbox' | 'db' | 'relationship' | 'objectStorage' | 'userWebhookDeliver' | 'systemWebhookDeliver';
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        name: 'system' | 'endedPollNotification' | 'postScheduledNote' | 'deliver' | 'inbox' | 'db' | 'relationship' | 'objectStorage' | 'userWebhookDeliver' | 'systemWebhookDeliver';
                        qualifiedName: string;
                        counts: {
                            [key: string]: number;
                        };
                        isPaused: boolean;
                        metrics: {
                            completed: components['schemas']['QueueMetrics'];
                            failed: components['schemas']['QueueMetrics'];
                        };
                        db: {
                            version: string;
                            mode: 'cluster' | 'standalone' | 'sentinel';
                            runId: string;
                            processId: string;
                            port: number;
                            os: string;
                            uptime: number;
                            memory: {
                                total: number;
                                used: number;
                                fragmentationRatio: number;
                                peak: number;
                            };
                            clients: {
                                blocked: number;
                                connected: number;
                            };
                        };
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___queue___queues: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        name: 'system' | 'endedPollNotification' | 'postScheduledNote' | 'deliver' | 'inbox' | 'db' | 'relationship' | 'objectStorage' | 'userWebhookDeliver' | 'systemWebhookDeliver';
                        counts: {
                            [key: string]: number;
                        };
                        isPaused: boolean;
                        metrics: {
                            completed: components['schemas']['QueueMetrics'];
                            failed: components['schemas']['QueueMetrics'];
                        };
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___queue___remove-job': {
        requestBody: {
            content: {
                'application/json': {
                    queue: 'system' | 'endedPollNotification' | 'postScheduledNote' | 'deliver' | 'inbox' | 'db' | 'relationship' | 'objectStorage' | 'userWebhookDeliver' | 'systemWebhookDeliver';
                    jobId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___queue___retry-job': {
        requestBody: {
            content: {
                'application/json': {
                    queue: 'system' | 'endedPollNotification' | 'postScheduledNote' | 'deliver' | 'inbox' | 'db' | 'relationship' | 'objectStorage' | 'userWebhookDeliver' | 'systemWebhookDeliver';
                    jobId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___queue___show-job': {
        requestBody: {
            content: {
                'application/json': {
                    queue: 'system' | 'endedPollNotification' | 'postScheduledNote' | 'deliver' | 'inbox' | 'db' | 'relationship' | 'objectStorage' | 'userWebhookDeliver' | 'systemWebhookDeliver';
                    jobId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['QueueJob'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___queue___show-job-logs': {
        requestBody: {
            content: {
                'application/json': {
                    queue: 'system' | 'endedPollNotification' | 'postScheduledNote' | 'deliver' | 'inbox' | 'db' | 'relationship' | 'objectStorage' | 'userWebhookDeliver' | 'systemWebhookDeliver';
                    jobId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': string[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___queue___stats: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        deliver: components['schemas']['QueueCount'];
                        inbox: components['schemas']['QueueCount'];
                        db: components['schemas']['QueueCount'];
                        objectStorage: components['schemas']['QueueCount'];
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___relays___add: {
        requestBody: {
            content: {
                'application/json': {
                    inbox: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        inbox: string;
                        status: 'requesting' | 'accepted' | 'rejected';
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___relays___list: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        inbox: string;
                        status: 'requesting' | 'accepted' | 'rejected';
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___relays___remove: {
        requestBody: {
            content: {
                'application/json': {
                    inbox: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___reset-password': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        password: string;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___resolve-abuse-user-report': {
        requestBody: {
            content: {
                'application/json': {
                    reportId: string;
                    resolvedAs?: 'accept' | 'reject' | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___roles___assign: {
        requestBody: {
            content: {
                'application/json': {
                    roleId: string;
                    userId: string;
                    expiresAt?: number | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___roles___create: {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                    description: string;
                    color: string | null;
                    iconUrl: string | null;
                    target: 'manual' | 'conditional';
                    condFormula: Record<string, never>;
                    isPublic: boolean;
                    isModerator: boolean;
                    isAdministrator: boolean;
                    isExplorable?: boolean;
                    asBadge: boolean;
                    preserveAssignmentOnMoveAccount?: boolean;
                    canEditMembersByModerator: boolean;
                    displayOrder: number;
                    policies: Record<string, never>;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Role'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___roles___delete: {
        requestBody: {
            content: {
                'application/json': {
                    roleId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___roles___list: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Role'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___roles___show: {
        requestBody: {
            content: {
                'application/json': {
                    roleId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Role'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___roles___unassign: {
        requestBody: {
            content: {
                'application/json': {
                    roleId: string;
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___roles___update: {
        requestBody: {
            content: {
                'application/json': {
                    roleId: string;
                    name?: string;
                    description?: string;
                    color?: string | null;
                    iconUrl?: string | null;
                    target?: 'manual' | 'conditional';
                    condFormula?: Record<string, never>;
                    isPublic?: boolean;
                    isModerator?: boolean;
                    isAdministrator?: boolean;
                    isExplorable?: boolean;
                    asBadge?: boolean;
                    preserveAssignmentOnMoveAccount?: boolean;
                    canEditMembersByModerator?: boolean;
                    displayOrder?: number;
                    policies?: Record<string, never>;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___roles___update-default-policies': {
        requestBody: {
            content: {
                'application/json': {
                    policies: Record<string, never>;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    admin___roles___users: {
        requestBody: {
            content: {
                'application/json': {
                    roleId: string;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        createdAt: string;
                        user: components['schemas']['UserDetailed'];
                        expiresAt: string | null;
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___send-email': {
        requestBody: {
            content: {
                'application/json': {
                    to: string;
                    subject: string;
                    text: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___server-info': {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        machine: string;
                        os: string;
                        node: string;
                        psql: string;
                        cpu: {
                            model: string;
                            cores: number;
                        };
                        mem: {
                            total: number;
                        };
                        fs: {
                            total: number;
                            used: number;
                        };
                        net: {
                            interface: string;
                        };
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___show-moderation-logs': {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    type?: string | null;
                    userId?: string | null;
                    search?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        createdAt: string;
                        type: string;
                        info: Record<string, never>;
                        userId: string;
                        user: components['schemas']['UserDetailedNotMe'];
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___show-user': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        email: string | null;
                        emailVerified: boolean;
                        followedMessage: string | null;
                        autoAcceptFollowed: boolean;
                        noCrawle: boolean;
                        preventAiLearning: boolean;
                        alwaysMarkNsfw: boolean;
                        autoSensitive: boolean;
                        carefulBot: boolean;
                        injectFeaturedNote: boolean;
                        receiveAnnouncementEmail: boolean;
                        mutedWords: (string | string[])[];
                        mutedInstances: string[];
                        notificationRecieveConfig: {
                            note?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            follow?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            mention?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            reply?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            renote?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            quote?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            reaction?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            pollEnded?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            scheduledNotePosted?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            scheduledNotePostFailed?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            receiveFollowRequest?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            followRequestAccepted?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            roleAssigned?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            chatRoomInvitationReceived?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            achievementEarned?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            app?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                            test?: {
                                type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                            } | {
                                type: 'list';
                                userListId: string;
                            };
                        };
                        isModerator: boolean;
                        isSilenced: boolean;
                        isSuspended: boolean;
                        isHibernated: boolean;
                        lastActiveDate: string | null;
                        moderationNote: string;
                        signins: components['schemas']['Signin'][];
                        policies: components['schemas']['RolePolicies'];
                        roles: components['schemas']['Role'][];
                        roleAssigns: {
                            createdAt: string;
                            expiresAt: string | null;
                            roleId: string;
                        }[];
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___show-users': {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    offset?: number;
                    sort?: '+follower' | '-follower' | '+createdAt' | '-createdAt' | '+updatedAt' | '-updatedAt' | '+lastActiveDate' | '-lastActiveDate';
                    state?: 'all' | 'alive' | 'available' | 'admin' | 'moderator' | 'adminOrModerator' | 'suspended';
                    origin?: 'combined' | 'local' | 'remote';
                    username?: string | null;
                    hostname?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserDetailed'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___suspend-user': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___system-webhook___create': {
        requestBody: {
            content: {
                'application/json': {
                    isActive: boolean;
                    name: string;
                    on: ('abuseReport' | 'abuseReportResolved' | 'userCreated' | 'inactiveModeratorsWarning' | 'inactiveModeratorsInvitationOnlyChanged')[];
                    url: string;
                    secret?: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['SystemWebhook'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___system-webhook___delete': {
        requestBody: {
            content: {
                'application/json': {
                    id: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___system-webhook___list': {
        requestBody: {
            content: {
                'application/json': {
                    isActive?: boolean;
                    on?: ('abuseReport' | 'abuseReportResolved' | 'userCreated' | 'inactiveModeratorsWarning' | 'inactiveModeratorsInvitationOnlyChanged')[];
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['SystemWebhook'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___system-webhook___show': {
        requestBody: {
            content: {
                'application/json': {
                    id: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['SystemWebhook'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___system-webhook___test': {
        requestBody: {
            content: {
                'application/json': {
                    webhookId: string;
                    type: 'abuseReport' | 'abuseReportResolved' | 'userCreated' | 'inactiveModeratorsWarning' | 'inactiveModeratorsInvitationOnlyChanged';
                    override?: {
                        url?: string;
                        secret?: string;
                    };
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___system-webhook___update': {
        requestBody: {
            content: {
                'application/json': {
                    id: string;
                    isActive: boolean;
                    name: string;
                    on: ('abuseReport' | 'abuseReportResolved' | 'userCreated' | 'inactiveModeratorsWarning' | 'inactiveModeratorsInvitationOnlyChanged')[];
                    url: string;
                    secret?: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['SystemWebhook'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___unset-user-avatar': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___unset-user-banner': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___unsuspend-user': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___update-abuse-user-report': {
        requestBody: {
            content: {
                'application/json': {
                    reportId: string;
                    moderationNote?: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___update-meta': {
        requestBody: {
            content: {
                'application/json': {
                    disableRegistration?: boolean | null;
                    pinnedUsers?: string[] | null;
                    hiddenTags?: string[] | null;
                    blockedHosts?: string[] | null;
                    sensitiveWords?: string[] | null;
                    prohibitedWords?: string[] | null;
                    prohibitedWordsForNameOfUser?: string[] | null;
                    themeColor?: string | null;
                    mascotImageUrl?: string | null;
                    bannerUrl?: string | null;
                    serverErrorImageUrl?: string | null;
                    infoImageUrl?: string | null;
                    notFoundImageUrl?: string | null;
                    iconUrl?: string | null;
                    app192IconUrl?: string | null;
                    app512IconUrl?: string | null;
                    backgroundImageUrl?: string | null;
                    logoImageUrl?: string | null;
                    name?: string | null;
                    shortName?: string | null;
                    description?: string | null;
                    defaultLightTheme?: string | null;
                    defaultDarkTheme?: string | null;
                    clientOptions?: Record<string, never>;
                    cacheRemoteFiles?: boolean;
                    cacheRemoteSensitiveFiles?: boolean;
                    emailRequiredForSignup?: boolean;
                    enableHcaptcha?: boolean;
                    hcaptchaSiteKey?: string | null;
                    hcaptchaSecretKey?: string | null;
                    enableMcaptcha?: boolean;
                    mcaptchaSiteKey?: string | null;
                    mcaptchaInstanceUrl?: string | null;
                    mcaptchaSecretKey?: string | null;
                    enableRecaptcha?: boolean;
                    recaptchaSiteKey?: string | null;
                    recaptchaSecretKey?: string | null;
                    enableTurnstile?: boolean;
                    turnstileSiteKey?: string | null;
                    turnstileSecretKey?: string | null;
                    enableTestcaptcha?: boolean;
                    googleAnalyticsMeasurementId?: string | null;
                    sensitiveMediaDetection?: 'none' | 'all' | 'local' | 'remote';
                    sensitiveMediaDetectionSensitivity?: 'medium' | 'low' | 'high' | 'veryLow' | 'veryHigh';
                    setSensitiveFlagAutomatically?: boolean;
                    enableSensitiveMediaDetectionForVideos?: boolean;
                    maintainerName?: string | null;
                    maintainerEmail?: string | null;
                    langs?: string[];
                    deeplAuthKey?: string | null;
                    deeplIsPro?: boolean;
                    enableEmail?: boolean;
                    email?: string | null;
                    smtpSecure?: boolean;
                    smtpHost?: string | null;
                    smtpPort?: number | null;
                    smtpUser?: string | null;
                    smtpPass?: string | null;
                    enableServiceWorker?: boolean;
                    swPublicKey?: string | null;
                    swPrivateKey?: string | null;
                    tosUrl?: string | null;
                    repositoryUrl?: string | null;
                    feedbackUrl?: string | null;
                    impressumUrl?: string | null;
                    privacyPolicyUrl?: string | null;
                    inquiryUrl?: string | null;
                    useObjectStorage?: boolean;
                    objectStorageBaseUrl?: string | null;
                    objectStorageBucket?: string | null;
                    objectStoragePrefix?: string | null;
                    objectStorageEndpoint?: string | null;
                    objectStorageRegion?: string | null;
                    objectStoragePort?: number | null;
                    objectStorageAccessKey?: string | null;
                    objectStorageSecretKey?: string | null;
                    objectStorageUseSSL?: boolean;
                    objectStorageUseProxy?: boolean;
                    objectStorageSetPublicRead?: boolean;
                    objectStorageS3ForcePathStyle?: boolean;
                    enableIpLogging?: boolean;
                    enableActiveEmailValidation?: boolean;
                    enableVerifymailApi?: boolean;
                    verifymailAuthKey?: string | null;
                    enableTruemailApi?: boolean;
                    truemailInstance?: string | null;
                    truemailAuthKey?: string | null;
                    enableChartsForRemoteUser?: boolean;
                    enableChartsForFederatedInstances?: boolean;
                    enableStatsForFederatedInstances?: boolean;
                    enableServerMachineStats?: boolean;
                    enableIdenticonGeneration?: boolean;
                    serverRules?: string[];
                    bannedEmailDomains?: string[];
                    preservedUsernames?: string[];
                    manifestJsonOverride?: string;
                    enableFanoutTimeline?: boolean;
                    enableFanoutTimelineDbFallback?: boolean;
                    perLocalUserUserTimelineCacheMax?: number;
                    perRemoteUserUserTimelineCacheMax?: number;
                    perUserHomeTimelineCacheMax?: number;
                    perUserListTimelineCacheMax?: number;
                    enableReactionsBuffering?: boolean;
                    notesPerOneAd?: number;
                    silencedHosts?: string[] | null;
                    mediaSilencedHosts?: string[] | null;
                    summalyProxy?: string | null;
                    urlPreviewEnabled?: boolean;
                    urlPreviewAllowRedirect?: boolean;
                    urlPreviewTimeout?: number;
                    urlPreviewMaximumContentLength?: number;
                    urlPreviewRequireContentLength?: boolean;
                    urlPreviewUserAgent?: string | null;
                    urlPreviewSummaryProxyUrl?: string | null;
                    federation?: 'all' | 'none' | 'specified';
                    federationHosts?: string[];
                    deliverSuspendedSoftware?: {
                        software: string;
                        versionRange: string;
                    }[];
                    singleUserMode?: boolean;
                    ugcVisibilityForVisitor?: 'all' | 'local' | 'none';
                    proxyRemoteFiles?: boolean;
                    signToActivityPubGet?: boolean;
                    allowExternalApRedirect?: boolean;
                    enableRemoteNotesCleaning?: boolean;
                    remoteNotesCleaningExpiryDaysForEachNotes?: number;
                    remoteNotesCleaningMaxProcessingDurationInMinutes?: number;
                    showRoleBadgesOfRemoteUsers?: boolean;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___update-proxy-account': {
        requestBody: {
            content: {
                'application/json': {
                    description?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserDetailed'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'admin___update-user-note': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                    text: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    announcements: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    isActive?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Announcement'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    announcements___show: {
        requestBody: {
            content: {
                'application/json': {
                    announcementId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Announcement'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    antennas___create: {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                    src: 'home' | 'all' | 'users' | 'list' | 'users_blacklist';
                    userListId?: string | null;
                    keywords: string[][];
                    excludeKeywords: string[][];
                    users: string[];
                    caseSensitive: boolean;
                    localOnly?: boolean;
                    excludeBots?: boolean;
                    withReplies: boolean;
                    withFile: boolean;
                    excludeNotesInSensitiveChannel?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Antenna'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    antennas___delete: {
        requestBody: {
            content: {
                'application/json': {
                    antennaId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    antennas___list: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Antenna'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    antennas___notes: {
        requestBody: {
            content: {
                'application/json': {
                    antennaId: string;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    antennas___show: {
        requestBody: {
            content: {
                'application/json': {
                    antennaId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Antenna'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    antennas___update: {
        requestBody: {
            content: {
                'application/json': {
                    antennaId: string;
                    name?: string;
                    src?: 'home' | 'all' | 'users' | 'list' | 'users_blacklist';
                    userListId?: string | null;
                    keywords?: string[][];
                    excludeKeywords?: string[][];
                    users?: string[];
                    caseSensitive?: boolean;
                    localOnly?: boolean;
                    excludeBots?: boolean;
                    withReplies?: boolean;
                    withFile?: boolean;
                    excludeNotesInSensitiveChannel?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Antenna'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    ap___get: {
        requestBody: {
            content: {
                'application/json': {
                    uri: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': Record<string, never>;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    ap___show: {
        requestBody: {
            content: {
                'application/json': {
                    uri: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        type: 'User';
                        object: components['schemas']['UserDetailedNotMe'];
                    } | {
                        type: 'Note';
                        object: components['schemas']['Note'];
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    app___create: {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                    description: string;
                    permission: string[];
                    callbackUrl?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['App'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    app___show: {
        requestBody: {
            content: {
                'application/json': {
                    appId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['App'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    auth___accept: {
        requestBody: {
            content: {
                'application/json': {
                    token: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    auth___session___generate: {
        requestBody: {
            content: {
                'application/json': {
                    appSecret: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        token: string;
                        url: string;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    auth___session___show: {
        requestBody: {
            content: {
                'application/json': {
                    token: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        app: components['schemas']['App'];
                        token: string;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    auth___session___userkey: {
        requestBody: {
            content: {
                'application/json': {
                    appSecret: string;
                    token: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        accessToken: string;
                        user: components['schemas']['UserDetailedNotMe'];
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    blocking___create: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserDetailedNotMe'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    blocking___delete: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserDetailedNotMe'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    blocking___list: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Blocking'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'bubble-game___ranking': {
        requestBody: {
            content: {
                'application/json': {
                    gameMode: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        score: number;
                        user?: components['schemas']['UserLite'];
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'bubble-game___register': {
        requestBody: {
            content: {
                'application/json': {
                    score: number;
                    seed: string;
                    logs: number[][];
                    gameMode: string;
                    gameVersion: number;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___create: {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                    description?: string | null;
                    bannerId?: string | null;
                    color?: string;
                    isSensitive?: boolean | null;
                    allowRenoteToExternal?: boolean | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Channel'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___favorite: {
        requestBody: {
            content: {
                'application/json': {
                    channelId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___featured: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Channel'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___follow: {
        requestBody: {
            content: {
                'application/json': {
                    channelId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___followed: {
        requestBody: {
            content: {
                'application/json': {
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Channel'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___mute___create: {
        requestBody: {
            content: {
                'application/json': {
                    channelId: string;
                    expiresAt?: number | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___mute___delete: {
        requestBody: {
            content: {
                'application/json': {
                    channelId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___mute___list: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Channel'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'channels___my-favorites': {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Channel'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___owned: {
        requestBody: {
            content: {
                'application/json': {
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Channel'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___search: {
        requestBody: {
            content: {
                'application/json': {
                    query: string;
                    type?: 'nameAndDescription' | 'nameOnly';
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Channel'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___show: {
        requestBody: {
            content: {
                'application/json': {
                    channelId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Channel'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___timeline: {
        requestBody: {
            content: {
                'application/json': {
                    channelId: string;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    allowPartial?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___unfavorite: {
        requestBody: {
            content: {
                'application/json': {
                    channelId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___unfollow: {
        requestBody: {
            content: {
                'application/json': {
                    channelId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    channels___update: {
        requestBody: {
            content: {
                'application/json': {
                    channelId: string;
                    name?: string;
                    description?: string | null;
                    bannerId?: string | null;
                    isArchived?: boolean | null;
                    pinnedNoteIds?: string[];
                    color?: string;
                    isSensitive?: boolean | null;
                    allowRenoteToExternal?: boolean | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Channel'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'charts___active-users': {
        requestBody: {
            content: {
                'application/json': {
                    span: 'day' | 'hour';
                    limit?: number;
                    offset?: number | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        readWrite: number[];
                        read: number[];
                        write: number[];
                        registeredWithinWeek: number[];
                        registeredWithinMonth: number[];
                        registeredWithinYear: number[];
                        registeredOutsideWeek: number[];
                        registeredOutsideMonth: number[];
                        registeredOutsideYear: number[];
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'charts___ap-request': {
        requestBody: {
            content: {
                'application/json': {
                    span: 'day' | 'hour';
                    limit?: number;
                    offset?: number | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        deliverFailed: number[];
                        deliverSucceeded: number[];
                        inboxReceived: number[];
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    charts___drive: {
        requestBody: {
            content: {
                'application/json': {
                    span: 'day' | 'hour';
                    limit?: number;
                    offset?: number | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        local: {
                            incCount: number[];
                            incSize: number[];
                            decCount: number[];
                            decSize: number[];
                        };
                        remote: {
                            incCount: number[];
                            incSize: number[];
                            decCount: number[];
                            decSize: number[];
                        };
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    charts___federation: {
        requestBody: {
            content: {
                'application/json': {
                    span: 'day' | 'hour';
                    limit?: number;
                    offset?: number | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        deliveredInstances: number[];
                        inboxInstances: number[];
                        stalled: number[];
                        sub: number[];
                        pub: number[];
                        pubsub: number[];
                        subActive: number[];
                        pubActive: number[];
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    charts___instance: {
        requestBody: {
            content: {
                'application/json': {
                    span: 'day' | 'hour';
                    limit?: number;
                    offset?: number | null;
                    host: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        requests: {
                            failed: number[];
                            succeeded: number[];
                            received: number[];
                        };
                        notes: {
                            total: number[];
                            inc: number[];
                            dec: number[];
                            diffs: {
                                normal: number[];
                                reply: number[];
                                renote: number[];
                                withFile: number[];
                            };
                        };
                        users: {
                            total: number[];
                            inc: number[];
                            dec: number[];
                        };
                        following: {
                            total: number[];
                            inc: number[];
                            dec: number[];
                        };
                        followers: {
                            total: number[];
                            inc: number[];
                            dec: number[];
                        };
                        drive: {
                            totalFiles: number[];
                            incFiles: number[];
                            decFiles: number[];
                            incUsage: number[];
                            decUsage: number[];
                        };
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    charts___notes: {
        requestBody: {
            content: {
                'application/json': {
                    span: 'day' | 'hour';
                    limit?: number;
                    offset?: number | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        local: {
                            total: number[];
                            inc: number[];
                            dec: number[];
                            diffs: {
                                normal: number[];
                                reply: number[];
                                renote: number[];
                                withFile: number[];
                            };
                        };
                        remote: {
                            total: number[];
                            inc: number[];
                            dec: number[];
                            diffs: {
                                normal: number[];
                                reply: number[];
                                renote: number[];
                                withFile: number[];
                            };
                        };
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    charts___user___drive: {
        requestBody: {
            content: {
                'application/json': {
                    span: 'day' | 'hour';
                    limit?: number;
                    offset?: number | null;
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        totalCount: number[];
                        totalSize: number[];
                        incCount: number[];
                        incSize: number[];
                        decCount: number[];
                        decSize: number[];
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    charts___user___following: {
        requestBody: {
            content: {
                'application/json': {
                    span: 'day' | 'hour';
                    limit?: number;
                    offset?: number | null;
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        local: {
                            followings: {
                                total: number[];
                                inc: number[];
                                dec: number[];
                            };
                            followers: {
                                total: number[];
                                inc: number[];
                                dec: number[];
                            };
                        };
                        remote: {
                            followings: {
                                total: number[];
                                inc: number[];
                                dec: number[];
                            };
                            followers: {
                                total: number[];
                                inc: number[];
                                dec: number[];
                            };
                        };
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    charts___user___notes: {
        requestBody: {
            content: {
                'application/json': {
                    span: 'day' | 'hour';
                    limit?: number;
                    offset?: number | null;
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        total: number[];
                        inc: number[];
                        dec: number[];
                        diffs: {
                            normal: number[];
                            reply: number[];
                            renote: number[];
                            withFile: number[];
                        };
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    charts___user___pv: {
        requestBody: {
            content: {
                'application/json': {
                    span: 'day' | 'hour';
                    limit?: number;
                    offset?: number | null;
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        upv: {
                            user: number[];
                            visitor: number[];
                        };
                        pv: {
                            user: number[];
                            visitor: number[];
                        };
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    charts___user___reactions: {
        requestBody: {
            content: {
                'application/json': {
                    span: 'day' | 'hour';
                    limit?: number;
                    offset?: number | null;
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        local: {
                            count: number[];
                        };
                        remote: {
                            count: number[];
                        };
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    charts___users: {
        requestBody: {
            content: {
                'application/json': {
                    span: 'day' | 'hour';
                    limit?: number;
                    offset?: number | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        local: {
                            total: number[];
                            inc: number[];
                            dec: number[];
                        };
                        remote: {
                            total: number[];
                            inc: number[];
                            dec: number[];
                        };
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___history: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    room?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatMessage'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'chat___messages___create-to-room': {
        requestBody: {
            content: {
                'application/json': {
                    text?: string | null;
                    fileId?: string;
                    toRoomId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatMessageLiteForRoom'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'chat___messages___create-to-user': {
        requestBody: {
            content: {
                'application/json': {
                    text?: string | null;
                    fileId?: string;
                    toUserId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatMessageLiteFor1on1'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___messages___delete: {
        requestBody: {
            content: {
                'application/json': {
                    messageId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___messages___react: {
        requestBody: {
            content: {
                'application/json': {
                    messageId: string;
                    reaction: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'chat___messages___room-timeline': {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    roomId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatMessageLiteForRoom'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___messages___search: {
        requestBody: {
            content: {
                'application/json': {
                    query: string;
                    limit?: number;
                    userId?: string | null;
                    roomId?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatMessage'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___messages___show: {
        requestBody: {
            content: {
                'application/json': {
                    messageId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatMessage'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___messages___unreact: {
        requestBody: {
            content: {
                'application/json': {
                    messageId: string;
                    reaction: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'chat___messages___user-timeline': {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatMessageLiteFor1on1'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'chat___read-all': {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___rooms___create: {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                    description?: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatRoom'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___rooms___delete: {
        requestBody: {
            content: {
                'application/json': {
                    roomId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___rooms___invitations___create: {
        requestBody: {
            content: {
                'application/json': {
                    roomId: string;
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatRoomInvitation'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___rooms___invitations___ignore: {
        requestBody: {
            content: {
                'application/json': {
                    roomId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___rooms___invitations___inbox: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatRoomInvitation'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___rooms___invitations___outbox: {
        requestBody: {
            content: {
                'application/json': {
                    roomId: string;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatRoomInvitation'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___rooms___join: {
        requestBody: {
            content: {
                'application/json': {
                    roomId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___rooms___joining: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatRoomMembership'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___rooms___leave: {
        requestBody: {
            content: {
                'application/json': {
                    roomId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___rooms___members: {
        requestBody: {
            content: {
                'application/json': {
                    roomId: string;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatRoomMembership'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___rooms___mute: {
        requestBody: {
            content: {
                'application/json': {
                    roomId: string;
                    mute: boolean;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___rooms___owned: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatRoom'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___rooms___show: {
        requestBody: {
            content: {
                'application/json': {
                    roomId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatRoom'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    chat___rooms___update: {
        requestBody: {
            content: {
                'application/json': {
                    roomId: string;
                    name?: string;
                    description?: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatRoom'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'clips___add-note': {
        requestBody: {
            content: {
                'application/json': {
                    clipId: string;
                    noteId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    clips___create: {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                    isPublic?: boolean;
                    description?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Clip'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    clips___delete: {
        requestBody: {
            content: {
                'application/json': {
                    clipId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    clips___favorite: {
        requestBody: {
            content: {
                'application/json': {
                    clipId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    clips___list: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Clip'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'clips___my-favorites': {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Clip'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    clips___notes: {
        requestBody: {
            content: {
                'application/json': {
                    clipId: string;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    search?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'clips___remove-note': {
        requestBody: {
            content: {
                'application/json': {
                    clipId: string;
                    noteId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    clips___show: {
        requestBody: {
            content: {
                'application/json': {
                    clipId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Clip'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    clips___unfavorite: {
        requestBody: {
            content: {
                'application/json': {
                    clipId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    clips___update: {
        requestBody: {
            content: {
                'application/json': {
                    clipId: string;
                    name?: string;
                    isPublic?: boolean;
                    description?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Clip'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    drive: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        capacity: number;
                        usage: number;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    drive___files: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    folderId?: string | null;
                    type?: string | null;
                    sort?: '+createdAt' | '-createdAt' | '+name' | '-name' | '+size' | '-size' | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['DriveFile'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'drive___files___attached-chat-messages': {
        requestBody: {
            content: {
                'application/json': {
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                    fileId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ChatMessage'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'drive___files___attached-notes': {
        requestBody: {
            content: {
                'application/json': {
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                    fileId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'drive___files___check-existence': {
        requestBody: {
            content: {
                'application/json': {
                    md5: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': boolean;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    drive___files___create: {
        requestBody: {
            content: {
                'multipart/form-data': {
                    folderId?: string | null;
                    name?: string | null;
                    comment?: string | null;
                    isSensitive?: boolean;
                    force?: boolean;
                    file: Blob;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['DriveFile'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    drive___files___delete: {
        requestBody: {
            content: {
                'application/json': {
                    fileId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    drive___files___find: {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                    folderId?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['DriveFile'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'drive___files___find-by-hash': {
        requestBody: {
            content: {
                'application/json': {
                    md5: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['DriveFile'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'drive___files___move-bulk': {
        requestBody: {
            content: {
                'application/json': {
                    fileIds: string[];
                    folderId?: string | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    drive___files___show: {
        requestBody: {
            content: {
                'application/json': {
                    fileId: string;
                } | {
                    url: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['DriveFile'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    drive___files___update: {
        requestBody: {
            content: {
                'application/json': {
                    fileId: string;
                    folderId?: string | null;
                    name?: string;
                    isSensitive?: boolean;
                    comment?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['DriveFile'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'drive___files___upload-from-url': {
        requestBody: {
            content: {
                'application/json': {
                    url: string;
                    folderId?: string | null;
                    isSensitive?: boolean;
                    comment?: string | null;
                    marker?: string | null;
                    force?: boolean;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    drive___folders: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    folderId?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['DriveFolder'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    drive___folders___create: {
        requestBody: {
            content: {
                'application/json': {
                    name?: string;
                    parentId?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['DriveFolder'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    drive___folders___delete: {
        requestBody: {
            content: {
                'application/json': {
                    folderId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    drive___folders___find: {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                    parentId?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['DriveFolder'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    drive___folders___show: {
        requestBody: {
            content: {
                'application/json': {
                    folderId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['DriveFolder'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    drive___folders___update: {
        requestBody: {
            content: {
                'application/json': {
                    folderId: string;
                    name?: string;
                    parentId?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['DriveFolder'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    drive___stream: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    type?: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['DriveFile'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'email-address___available': {
        requestBody: {
            content: {
                'application/json': {
                    emailAddress: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        available: boolean;
                        reason: string | null;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    emoji: {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['EmojiDetailed'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    emojis: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        emojis: components['schemas']['EmojiSimple'][];
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    endpoint: {
        requestBody: {
            content: {
                'application/json': {
                    endpoint: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        params: {
                            name: string;
                            type: string;
                        }[];
                    } | null;
                };
            };
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    endpoints: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': string[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'export-custom-emojis': {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    federation___followers: {
        requestBody: {
            content: {
                'application/json': {
                    host: string;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Following'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    federation___following: {
        requestBody: {
            content: {
                'application/json': {
                    host: string;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Following'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    federation___instances: {
        requestBody: {
            content: {
                'application/json': {
                    host?: string | null;
                    blocked?: boolean | null;
                    notResponding?: boolean | null;
                    suspended?: boolean | null;
                    silenced?: boolean | null;
                    federating?: boolean | null;
                    subscribing?: boolean | null;
                    publishing?: boolean | null;
                    limit?: number;
                    offset?: number;
                    sort?: '+pubSub' | '-pubSub' | '+notes' | '-notes' | '+users' | '-users' | '+following' | '-following' | '+followers' | '-followers' | '+firstRetrievedAt' | '-firstRetrievedAt' | '+latestRequestReceivedAt' | '-latestRequestReceivedAt' | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['FederationInstance'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'federation___show-instance': {
        requestBody: {
            content: {
                'application/json': {
                    host: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['FederationInstance'] | null;
                };
            };
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    federation___stats: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        topSubInstances: components['schemas']['FederationInstance'][];
                        otherFollowersCount: number;
                        topPubInstances: components['schemas']['FederationInstance'][];
                        otherFollowingCount: number;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'federation___update-remote-user': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    federation___users: {
        requestBody: {
            content: {
                'application/json': {
                    host: string;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserDetailedNotMe'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'fetch-external-resources': {
        requestBody: {
            content: {
                'application/json': {
                    url: string;
                    hash: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        type: string;
                        data: string;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'fetch-rss': {
        requestBody: {
            content: {
                'application/json': {
                    url: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        image?: {
                            link?: string;
                            url: string;
                            title?: string;
                        };
                        paginationLinks?: {
                            self?: string;
                            first?: string;
                            next?: string;
                            last?: string;
                            prev?: string;
                        };
                        link?: string;
                        title?: string;
                        items: {
                            link?: string;
                            guid?: string;
                            title?: string;
                            pubDate?: string;
                            creator?: string;
                            summary?: string;
                            content?: string;
                            isoDate?: string;
                            categories?: string[];
                            contentSnippet?: string;
                            enclosure?: {
                                url: string;
                                length?: number;
                                type?: string;
                            };
                        }[];
                        feedUrl?: string;
                        description?: string;
                        itunes?: {
                            image?: string;
                            owner?: {
                                name?: string;
                                email?: string;
                            };
                            author?: string;
                            summary?: string;
                            explicit?: string;
                            categories?: string[];
                            keywords?: string[];
                        } & {
                            [key: string]: unknown;
                        };
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    flash___create: {
        requestBody: {
            content: {
                'application/json': {
                    title: string;
                    summary: string;
                    script: string;
                    permissions: string[];
                    visibility?: 'public' | 'private';
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Flash'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    flash___delete: {
        requestBody: {
            content: {
                'application/json': {
                    flashId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    flash___featured: {
        requestBody: {
            content: {
                'application/json': {
                    offset?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Flash'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    flash___like: {
        requestBody: {
            content: {
                'application/json': {
                    flashId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    flash___my: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Flash'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'flash___my-likes': {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    search?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        flash: components['schemas']['Flash'];
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    flash___search: {
        requestBody: {
            content: {
                'application/json': {
                    query: string;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Flash'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    flash___show: {
        requestBody: {
            content: {
                'application/json': {
                    flashId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Flash'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    flash___unlike: {
        requestBody: {
            content: {
                'application/json': {
                    flashId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    flash___update: {
        requestBody: {
            content: {
                'application/json': {
                    flashId: string;
                    title?: string;
                    summary?: string;
                    script?: string;
                    permissions?: string[];
                    visibility?: 'public' | 'private';
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    following___create: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                    withReplies?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserLite'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    following___delete: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserLite'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    following___invalidate: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserLite'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    following___requests___accept: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    following___requests___cancel: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserLite'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    following___requests___list: {
        requestBody: {
            content: {
                'application/json': {
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        follower: components['schemas']['UserLite'];
                        followee: components['schemas']['UserLite'];
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    following___requests___reject: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    following___requests___sent: {
        requestBody: {
            content: {
                'application/json': {
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        follower: components['schemas']['UserLite'];
                        followee: components['schemas']['UserLite'];
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    following___update: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                    notify?: 'normal' | 'none';
                    withReplies?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserLite'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'following___update-all': {
        requestBody: {
            content: {
                'application/json': {
                    notify?: 'normal' | 'none';
                    withReplies?: boolean;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    gallery___featured: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    untilId?: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['GalleryPost'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    gallery___popular: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['GalleryPost'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    gallery___posts: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['GalleryPost'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    gallery___posts___create: {
        requestBody: {
            content: {
                'application/json': {
                    title: string;
                    description?: string | null;
                    fileIds: string[];
                    isSensitive?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['GalleryPost'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    gallery___posts___delete: {
        requestBody: {
            content: {
                'application/json': {
                    postId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    gallery___posts___like: {
        requestBody: {
            content: {
                'application/json': {
                    postId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    gallery___posts___show: {
        requestBody: {
            content: {
                'application/json': {
                    postId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['GalleryPost'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    gallery___posts___unlike: {
        requestBody: {
            content: {
                'application/json': {
                    postId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    gallery___posts___update: {
        requestBody: {
            content: {
                'application/json': {
                    postId: string;
                    title?: string;
                    description?: string | null;
                    fileIds?: string[];
                    isSensitive?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['GalleryPost'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'get-avatar-decorations': {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        name: string;
                        description: string;
                        url: string;
                        roleIdsThatCanBeUsedThisDecoration: string[];
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'get-online-users-count': {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        count: number;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    hashtags___list: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    attachedToUserOnly?: boolean;
                    attachedToLocalUserOnly?: boolean;
                    attachedToRemoteUserOnly?: boolean;
                    sort: '+mentionedUsers' | '-mentionedUsers' | '+mentionedLocalUsers' | '-mentionedLocalUsers' | '+mentionedRemoteUsers' | '-mentionedRemoteUsers' | '+attachedUsers' | '-attachedUsers' | '+attachedLocalUsers' | '-attachedLocalUsers' | '+attachedRemoteUsers' | '-attachedRemoteUsers';
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Hashtag'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    hashtags___search: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    query: string;
                    offset?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': string[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    hashtags___show: {
        requestBody: {
            content: {
                'application/json': {
                    tag: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Hashtag'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    hashtags___trend: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        tag: string;
                        chart: number[];
                        usersCount: number;
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    hashtags___users: {
        requestBody: {
            content: {
                'application/json': {
                    tag: string;
                    limit?: number;
                    sort: '+follower' | '-follower' | '+createdAt' | '-createdAt' | '+updatedAt' | '-updatedAt';
                    state?: 'all' | 'alive';
                    origin?: 'combined' | 'local' | 'remote';
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserDetailed'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['MeDetailed'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___2fa___done: {
        requestBody: {
            content: {
                'application/json': {
                    token: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        backupCodes: string[];
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___2fa___key-done': {
        requestBody: {
            content: {
                'application/json': {
                    password: string;
                    token?: string | null;
                    name: string;
                    credential: Record<string, never>;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        name: string;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___2fa___password-less': {
        requestBody: {
            content: {
                'application/json': {
                    value: boolean;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___2fa___register: {
        requestBody: {
            content: {
                'application/json': {
                    password: string;
                    token?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        qr: string;
                        url: string;
                        secret: string;
                        label: string;
                        issuer: string;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___2fa___register-key': {
        requestBody: {
            content: {
                'application/json': {
                    password: string;
                    token?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        rp: {
                            id?: string;
                        };
                        user: {
                            id: string;
                            name: string;
                            displayName: string;
                        };
                        challenge: string;
                        pubKeyCredParams: {
                            type: string;
                            alg: number;
                        }[];
                        timeout: number | null;
                        excludeCredentials: {
                            id: string;
                            type: string;
                            transports: ('ble' | 'cable' | 'hybrid' | 'internal' | 'nfc' | 'smart-card' | 'usb')[];
                        }[] | null;
                        authenticatorSelection: {
                            authenticatorAttachment: 'cross-platform' | 'platform';
                            requireResidentKey: boolean;
                            userVerification: 'discouraged' | 'preferred' | 'required';
                        } | null;
                        attestation: 'direct' | 'enterprise' | 'indirect' | 'none' | null;
                        extensions: {
                            appid: string | null;
                            credProps: boolean | null;
                            hmacCreateSecret: boolean | null;
                        } | null;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___2fa___remove-key': {
        requestBody: {
            content: {
                'application/json': {
                    password: string;
                    token?: string | null;
                    credentialId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___2fa___unregister: {
        requestBody: {
            content: {
                'application/json': {
                    password: string;
                    token?: string | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___2fa___update-key': {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                    credentialId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___apps: {
        requestBody: {
            content: {
                'application/json': {
                    sort?: '+createdAt' | '-createdAt' | '+lastUsedAt' | '-lastUsedAt';
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        name?: string;
                        createdAt: string;
                        lastUsedAt?: string;
                        permission: string[];
                        iconUrl?: string | null;
                        description?: string | null;
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___authorized-apps': {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    offset?: number;
                    sort?: 'desc' | 'asc';
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        name: string;
                        callbackUrl: string | null;
                        permission: string[];
                        isAuthorized?: boolean;
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___change-password': {
        requestBody: {
            content: {
                'application/json': {
                    currentPassword: string;
                    newPassword: string;
                    token?: string | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___claim-achievement': {
        requestBody: {
            content: {
                'application/json': {
                    name: 'notes1' | 'notes10' | 'notes100' | 'notes500' | 'notes1000' | 'notes5000' | 'notes10000' | 'notes20000' | 'notes30000' | 'notes40000' | 'notes50000' | 'notes60000' | 'notes70000' | 'notes80000' | 'notes90000' | 'notes100000' | 'login3' | 'login7' | 'login15' | 'login30' | 'login60' | 'login100' | 'login200' | 'login300' | 'login400' | 'login500' | 'login600' | 'login700' | 'login800' | 'login900' | 'login1000' | 'passedSinceAccountCreated1' | 'passedSinceAccountCreated2' | 'passedSinceAccountCreated3' | 'loggedInOnBirthday' | 'loggedInOnNewYearsDay' | 'noteClipped1' | 'noteFavorited1' | 'myNoteFavorited1' | 'profileFilled' | 'markedAsCat' | 'following1' | 'following10' | 'following50' | 'following100' | 'following300' | 'followers1' | 'followers10' | 'followers50' | 'followers100' | 'followers300' | 'followers500' | 'followers1000' | 'collectAchievements30' | 'viewAchievements3min' | 'iLoveMisskey' | 'foundTreasure' | 'client30min' | 'client60min' | 'noteDeletedWithin1min' | 'postedAtLateNight' | 'postedAt0min0sec' | 'selfQuote' | 'htl20npm' | 'viewInstanceChart' | 'outputHelloWorldOnScratchpad' | 'open3windows' | 'driveFolderCircularReference' | 'reactWithoutRead' | 'clickedClickHere' | 'justPlainLucky' | 'setNameToSyuilo' | 'cookieClicked' | 'brainDiver' | 'smashTestNotificationButton' | 'tutorialCompleted' | 'bubbleGameExplodingHead' | 'bubbleGameDoubleExplodingHead';
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___delete-account': {
        requestBody: {
            content: {
                'application/json': {
                    password: string;
                    token?: string | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___export-antennas': {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___export-blocking': {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___export-clips': {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___export-favorites': {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___export-following': {
        requestBody: {
            content: {
                'application/json': {
                    excludeMuting?: boolean;
                    excludeInactive?: boolean;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___export-mute': {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___export-notes': {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___export-user-lists': {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___favorites: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['NoteFavorite'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___gallery___likes: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        post: components['schemas']['GalleryPost'];
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___gallery___posts: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['GalleryPost'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___import-antennas': {
        requestBody: {
            content: {
                'application/json': {
                    fileId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___import-blocking': {
        requestBody: {
            content: {
                'application/json': {
                    fileId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___import-following': {
        requestBody: {
            content: {
                'application/json': {
                    fileId: string;
                    withReplies?: boolean;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___import-muting': {
        requestBody: {
            content: {
                'application/json': {
                    fileId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___import-user-lists': {
        requestBody: {
            content: {
                'application/json': {
                    fileId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___move: {
        requestBody: {
            content: {
                'application/json': {
                    moveToAccount: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': Record<string, never>;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___notifications: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    markAsRead?: boolean;
                    includeTypes?: ('note' | 'follow' | 'mention' | 'reply' | 'renote' | 'quote' | 'reaction' | 'pollEnded' | 'scheduledNotePosted' | 'scheduledNotePostFailed' | 'receiveFollowRequest' | 'followRequestAccepted' | 'roleAssigned' | 'chatRoomInvitationReceived' | 'achievementEarned' | 'exportCompleted' | 'login' | 'createToken' | 'app' | 'test' | 'pollVote' | 'groupInvited')[];
                    excludeTypes?: ('note' | 'follow' | 'mention' | 'reply' | 'renote' | 'quote' | 'reaction' | 'pollEnded' | 'scheduledNotePosted' | 'scheduledNotePostFailed' | 'receiveFollowRequest' | 'followRequestAccepted' | 'roleAssigned' | 'chatRoomInvitationReceived' | 'achievementEarned' | 'exportCompleted' | 'login' | 'createToken' | 'app' | 'test' | 'pollVote' | 'groupInvited')[];
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Notification'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___notifications-grouped': {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    markAsRead?: boolean;
                    includeTypes?: ('note' | 'follow' | 'mention' | 'reply' | 'renote' | 'quote' | 'reaction' | 'pollEnded' | 'scheduledNotePosted' | 'scheduledNotePostFailed' | 'receiveFollowRequest' | 'followRequestAccepted' | 'roleAssigned' | 'chatRoomInvitationReceived' | 'achievementEarned' | 'exportCompleted' | 'login' | 'createToken' | 'app' | 'test' | 'pollVote' | 'groupInvited')[];
                    excludeTypes?: ('note' | 'follow' | 'mention' | 'reply' | 'renote' | 'quote' | 'reaction' | 'pollEnded' | 'scheduledNotePosted' | 'scheduledNotePostFailed' | 'receiveFollowRequest' | 'followRequestAccepted' | 'roleAssigned' | 'chatRoomInvitationReceived' | 'achievementEarned' | 'exportCompleted' | 'login' | 'createToken' | 'app' | 'test' | 'pollVote' | 'groupInvited')[];
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Notification'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___page-likes': {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        page: components['schemas']['Page'];
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___pages: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Page'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___pin: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['MeDetailed'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___read-announcement': {
        requestBody: {
            content: {
                'application/json': {
                    announcementId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___regenerate-token': {
        requestBody: {
            content: {
                'application/json': {
                    password: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___registry___get: {
        requestBody: {
            content: {
                'application/json': {
                    key: string;
                    scope: string[];
                    domain?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': Record<string, never>;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___registry___get-all': {
        requestBody: {
            content: {
                'application/json': {
                    scope: string[];
                    domain?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': Record<string, never>;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___registry___get-detail': {
        requestBody: {
            content: {
                'application/json': {
                    key: string;
                    scope: string[];
                    domain?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        updatedAt: string;
                        value: unknown;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___registry___keys: {
        requestBody: {
            content: {
                'application/json': {
                    scope: string[];
                    domain?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': string[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___registry___keys-with-type': {
        requestBody: {
            content: {
                'application/json': {
                    scope: string[];
                    domain?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        [key: string]: string;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___registry___remove: {
        requestBody: {
            content: {
                'application/json': {
                    key: string;
                    scope: string[];
                    domain?: string | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___registry___scopes-with-domain': {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        scopes: string[][];
                        domain: string | null;
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___registry___set: {
        requestBody: {
            content: {
                'application/json': {
                    key: string;
                    value: unknown;
                    scope: string[];
                    domain?: string | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___revoke-token': {
        requestBody: {
            content: {
                'application/json': {
                    tokenId: string;
                } | {
                    token: string | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___signin-history': {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Signin'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___unpin: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['MeDetailed'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___update: {
        requestBody: {
            content: {
                'application/json': {
                    name?: string | null;
                    description?: string | null;
                    followedMessage?: string | null;
                    location?: string | null;
                    birthday?: string | null;
                    lang?: null | 'ach' | 'ady' | 'af' | 'af-NA' | 'af-ZA' | 'ak' | 'ar' | 'ar-AR' | 'ar-MA' | 'ar-SA' | 'ay-BO' | 'az' | 'az-AZ' | 'be-BY' | 'bg' | 'bg-BG' | 'bn' | 'bn-IN' | 'bn-BD' | 'br' | 'bs-BA' | 'ca' | 'ca-ES' | 'cak' | 'ck-US' | 'cs' | 'cs-CZ' | 'cy' | 'cy-GB' | 'da' | 'da-DK' | 'de' | 'de-AT' | 'de-DE' | 'de-CH' | 'dsb' | 'el' | 'el-GR' | 'en' | 'en-GB' | 'en-AU' | 'en-CA' | 'en-IE' | 'en-IN' | 'en-PI' | 'en-SG' | 'en-UD' | 'en-US' | 'en-ZA' | 'en@pirate' | 'eo' | 'eo-EO' | 'es' | 'es-AR' | 'es-419' | 'es-CL' | 'es-CO' | 'es-EC' | 'es-ES' | 'es-LA' | 'es-NI' | 'es-MX' | 'es-US' | 'es-VE' | 'et' | 'et-EE' | 'eu' | 'eu-ES' | 'fa' | 'fa-IR' | 'fb-LT' | 'ff' | 'fi' | 'fi-FI' | 'fo' | 'fo-FO' | 'fr' | 'fr-CA' | 'fr-FR' | 'fr-BE' | 'fr-CH' | 'fy-NL' | 'ga' | 'ga-IE' | 'gd' | 'gl' | 'gl-ES' | 'gn-PY' | 'gu-IN' | 'gv' | 'gx-GR' | 'he' | 'he-IL' | 'hi' | 'hi-IN' | 'hr' | 'hr-HR' | 'hsb' | 'ht' | 'hu' | 'hu-HU' | 'hy' | 'hy-AM' | 'id' | 'id-ID' | 'is' | 'is-IS' | 'it' | 'it-IT' | 'ja' | 'ja-JP' | 'jv-ID' | 'ka-GE' | 'kk-KZ' | 'km' | 'kl' | 'km-KH' | 'kab' | 'kn' | 'kn-IN' | 'ko' | 'ko-KR' | 'ku-TR' | 'kw' | 'la' | 'la-VA' | 'lb' | 'li-NL' | 'lt' | 'lt-LT' | 'lv' | 'lv-LV' | 'mai' | 'mg-MG' | 'mk' | 'mk-MK' | 'ml' | 'ml-IN' | 'mn-MN' | 'mr' | 'mr-IN' | 'ms' | 'ms-MY' | 'mt' | 'mt-MT' | 'my' | 'no' | 'nb' | 'nb-NO' | 'ne' | 'ne-NP' | 'nl' | 'nl-BE' | 'nl-NL' | 'nn-NO' | 'oc' | 'or-IN' | 'pa' | 'pa-IN' | 'pl' | 'pl-PL' | 'ps-AF' | 'pt' | 'pt-BR' | 'pt-PT' | 'qu-PE' | 'rm-CH' | 'ro' | 'ro-RO' | 'ru' | 'ru-RU' | 'sa-IN' | 'se-NO' | 'sh' | 'si-LK' | 'sk' | 'sk-SK' | 'sl' | 'sl-SI' | 'so-SO' | 'sq' | 'sq-AL' | 'sr' | 'sr-RS' | 'su' | 'sv' | 'sv-SE' | 'sw' | 'sw-KE' | 'ta' | 'ta-IN' | 'te' | 'te-IN' | 'tg' | 'tg-TJ' | 'th' | 'th-TH' | 'fil' | 'tlh' | 'tr' | 'tr-TR' | 'tt-RU' | 'uk' | 'uk-UA' | 'ur' | 'ur-PK' | 'uz' | 'uz-UZ' | 'vi' | 'vi-VN' | 'xh-ZA' | 'yi' | 'yi-DE' | 'zh' | 'zh-Hans' | 'zh-Hant' | 'zh-CN' | 'zh-HK' | 'zh-SG' | 'zh-TW' | 'zu-ZA';
                    avatarId?: string | null;
                    avatarDecorations?: {
                        id: string;
                        angle?: number | null;
                        flipH?: boolean | null;
                        offsetX?: number | null;
                        offsetY?: number | null;
                    }[];
                    bannerId?: string | null;
                    fields?: {
                        name: string;
                        value: string;
                    }[];
                    isLocked?: boolean;
                    isExplorable?: boolean;
                    hideOnlineStatus?: boolean;
                    publicReactions?: boolean;
                    carefulBot?: boolean;
                    autoAcceptFollowed?: boolean;
                    noCrawle?: boolean;
                    preventAiLearning?: boolean;
                    requireSigninToViewContents?: boolean;
                    makeNotesFollowersOnlyBefore?: number | null;
                    makeNotesHiddenBefore?: number | null;
                    isBot?: boolean;
                    isCat?: boolean;
                    injectFeaturedNote?: boolean;
                    receiveAnnouncementEmail?: boolean;
                    alwaysMarkNsfw?: boolean;
                    autoSensitive?: boolean;
                    followingVisibility?: 'public' | 'followers' | 'private';
                    followersVisibility?: 'public' | 'followers' | 'private';
                    chatScope?: 'everyone' | 'followers' | 'following' | 'mutual' | 'none';
                    pinnedPageId?: string | null;
                    mutedWords?: (string[] | string)[];
                    hardMutedWords?: (string[] | string)[];
                    mutedInstances?: string[];
                    notificationRecieveConfig?: {
                        note?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        follow?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        mention?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        reply?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        renote?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        quote?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        reaction?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        pollEnded?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        scheduledNotePosted?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        scheduledNotePostFailed?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        receiveFollowRequest?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        followRequestAccepted?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        roleAssigned?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        chatRoomInvitationReceived?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        achievementEarned?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        app?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                        test?: {
                            type: 'all' | 'following' | 'follower' | 'mutualFollow' | 'followingOrFollower' | 'never';
                        } | {
                            type: 'list';
                            userListId: string;
                        };
                    };
                    emailNotificationTypes?: string[];
                    alsoKnownAs?: string[];
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['MeDetailed'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'i___update-email': {
        requestBody: {
            content: {
                'application/json': {
                    password: string;
                    email?: string | null;
                    token?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['MeDetailed'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___webhooks___create: {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                    url: string;
                    secret?: string;
                    on: ('mention' | 'unfollow' | 'follow' | 'followed' | 'note' | 'reply' | 'renote' | 'reaction')[];
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        userId: string;
                        name: string;
                        on: ('mention' | 'unfollow' | 'follow' | 'followed' | 'note' | 'reply' | 'renote' | 'reaction')[];
                        url: string;
                        secret: string;
                        active: boolean;
                        latestSentAt: string | null;
                        latestStatus: number | null;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___webhooks___delete: {
        requestBody: {
            content: {
                'application/json': {
                    webhookId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___webhooks___list: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserWebhook'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___webhooks___show: {
        requestBody: {
            content: {
                'application/json': {
                    webhookId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserWebhook'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___webhooks___test: {
        requestBody: {
            content: {
                'application/json': {
                    webhookId: string;
                    type: 'mention' | 'unfollow' | 'follow' | 'followed' | 'note' | 'reply' | 'renote' | 'reaction';
                    override?: {
                        url?: string;
                        secret?: string;
                    };
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    i___webhooks___update: {
        requestBody: {
            content: {
                'application/json': {
                    webhookId: string;
                    name?: string;
                    url?: string;
                    secret?: string | null;
                    on?: ('mention' | 'unfollow' | 'follow' | 'followed' | 'note' | 'reply' | 'renote' | 'reaction')[];
                    active?: boolean;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    invite___create: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['InviteCode'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    invite___delete: {
        requestBody: {
            content: {
                'application/json': {
                    inviteId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    invite___limit: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        remaining: number | null;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    invite___list: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['InviteCode'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    meta: {
        requestBody: {
            content: {
                'application/json': {
                    detail?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['MetaLite'] | components['schemas']['MetaDetailed'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'miauth___gen-token': {
        requestBody: {
            content: {
                'application/json': {
                    session: string | null;
                    name?: string | null;
                    description?: string | null;
                    iconUrl?: string | null;
                    permission: string[];
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        token: string;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    mute___create: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                    expiresAt?: number | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    mute___delete: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    mute___list: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Muting'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    my___apps: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    offset?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['App'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes: {
        requestBody: {
            content: {
                'application/json': {
                    local?: boolean;
                    reply?: boolean;
                    renote?: boolean;
                    withFiles?: boolean;
                    poll?: boolean;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___children: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___clips: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Clip'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___conversation: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                    limit?: number;
                    offset?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___create: {
        requestBody: {
            content: {
                'application/json': {
                    visibility?: 'public' | 'home' | 'followers' | 'specified';
                    visibleUserIds?: string[];
                    cw?: string | null;
                    localOnly?: boolean;
                    reactionAcceptance?: null | 'likeOnly' | 'likeOnlyForRemote' | 'nonSensitiveOnly' | 'nonSensitiveOnlyForLocalLikeOnlyForRemote';
                    noExtractMentions?: boolean;
                    noExtractHashtags?: boolean;
                    noExtractEmojis?: boolean;
                    replyId?: string | null;
                    renoteId?: string | null;
                    channelId?: string | null;
                    text?: string | null;
                    fileIds?: string[];
                    mediaIds?: string[];
                    poll?: {
                        choices: string[];
                        multiple?: boolean;
                        expiresAt?: number | null;
                        expiredAfter?: number | null;
                    } | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        createdNote: components['schemas']['Note'];
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___delete: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___drafts___count: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': number;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___drafts___create: {
        requestBody: {
            content: {
                'application/json': {
                    visibility?: 'public' | 'home' | 'followers' | 'specified';
                    visibleUserIds?: string[];
                    cw?: string | null;
                    hashtag?: string | null;
                    localOnly?: boolean;
                    reactionAcceptance?: null | 'likeOnly' | 'likeOnlyForRemote' | 'nonSensitiveOnly' | 'nonSensitiveOnlyForLocalLikeOnlyForRemote';
                    replyId?: string | null;
                    renoteId?: string | null;
                    channelId?: string | null;
                    text?: string | null;
                    fileIds?: string[];
                    poll?: {
                        choices: string[];
                        multiple?: boolean;
                        expiresAt?: number | null;
                        expiredAfter?: number | null;
                    } | null;
                    scheduledAt?: number | null;
                    isActuallyScheduled?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        createdDraft: components['schemas']['NoteDraft'];
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___drafts___delete: {
        requestBody: {
            content: {
                'application/json': {
                    draftId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___drafts___list: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    scheduled?: boolean | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['NoteDraft'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___drafts___update: {
        requestBody: {
            content: {
                'application/json': {
                    draftId: string;
                    visibility?: 'public' | 'home' | 'followers' | 'specified';
                    visibleUserIds?: string[];
                    cw?: string | null;
                    hashtag?: string | null;
                    localOnly?: boolean;
                    reactionAcceptance?: null | 'likeOnly' | 'likeOnlyForRemote' | 'nonSensitiveOnly' | 'nonSensitiveOnlyForLocalLikeOnlyForRemote';
                    replyId?: string | null;
                    renoteId?: string | null;
                    channelId?: string | null;
                    text?: string | null;
                    fileIds?: string[];
                    poll?: {
                        choices: string[];
                        multiple?: boolean;
                        expiresAt?: number | null;
                        expiredAfter?: number | null;
                    } | null;
                    scheduledAt?: number | null;
                    isActuallyScheduled?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        updatedDraft: components['schemas']['NoteDraft'];
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___favorites___create: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___favorites___delete: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___featured: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    untilId?: string;
                    channelId?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'notes___global-timeline': {
        requestBody: {
            content: {
                'application/json': {
                    withFiles?: boolean;
                    withRenotes?: boolean;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'notes___hybrid-timeline': {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    allowPartial?: boolean;
                    includeMyRenotes?: boolean;
                    includeRenotedMyNotes?: boolean;
                    includeLocalRenotes?: boolean;
                    withFiles?: boolean;
                    withRenotes?: boolean;
                    withReplies?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'notes___local-timeline': {
        requestBody: {
            content: {
                'application/json': {
                    withFiles?: boolean;
                    withRenotes?: boolean;
                    withReplies?: boolean;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    allowPartial?: boolean;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___mentions: {
        requestBody: {
            content: {
                'application/json': {
                    following?: boolean;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    visibility?: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___polls___recommendation: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    offset?: number;
                    excludeChannels?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___polls___vote: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                    choice: number;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___reactions: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                    type?: string | null;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['NoteReaction'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___reactions___create: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                    reaction: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___reactions___delete: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___renotes: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___replies: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___search: {
        requestBody: {
            content: {
                'application/json': {
                    query: string;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                    offset?: number;
                    host?: string;
                    userId?: string | null;
                    channelId?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'notes___search-by-tag': {
        requestBody: {
            content: {
                'application/json': ({
                    tag: string;
                } | {
                    query: string[][];
                }) & {
                    reply?: boolean | null;
                    renote?: boolean | null;
                    withFiles?: boolean;
                    poll?: boolean | null;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___show: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'notes___show-partial-bulk': {
        requestBody: {
            content: {
                'application/json': {
                    noteIds: string[];
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        reactions: {
                            [key: string]: number;
                        };
                        reactionEmojis: {
                            [key: string]: string;
                        };
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___state: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        isFavorited: boolean;
                        isMutedThread: boolean;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'notes___thread-muting___create': {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'notes___thread-muting___delete': {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___timeline: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    allowPartial?: boolean;
                    includeMyRenotes?: boolean;
                    includeRenotedMyNotes?: boolean;
                    includeLocalRenotes?: boolean;
                    withFiles?: boolean;
                    withRenotes?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___translate: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                    targetLang: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        sourceLang: string;
                        text: string;
                    };
                };
            };
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notes___unrenote: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'notes___user-list-timeline': {
        requestBody: {
            content: {
                'application/json': {
                    listId: string;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    allowPartial?: boolean;
                    includeMyRenotes?: boolean;
                    includeRenotedMyNotes?: boolean;
                    includeLocalRenotes?: boolean;
                    withRenotes?: boolean;
                    withFiles?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notifications___create: {
        requestBody: {
            content: {
                'application/json': {
                    body: string;
                    header?: string | null;
                    icon?: string | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    notifications___flush: {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'notifications___mark-all-as-read': {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'notifications___test-notification': {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'page-push': {
        requestBody: {
            content: {
                'application/json': {
                    pageId: string;
                    event: string;
                    var?: unknown;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    pages___create: {
        requestBody: {
            content: {
                'application/json': {
                    title: string;
                    name: string;
                    summary?: string | null;
                    content: {
                        [key: string]: unknown;
                    }[];
                    variables: {
                        [key: string]: unknown;
                    }[];
                    script: string;
                    eyeCatchingImageId?: string | null;
                    font?: 'serif' | 'sans-serif';
                    alignCenter?: boolean;
                    hideTitleWhenPinned?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Page'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    pages___delete: {
        requestBody: {
            content: {
                'application/json': {
                    pageId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    pages___featured: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Page'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    pages___like: {
        requestBody: {
            content: {
                'application/json': {
                    pageId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    pages___show: {
        requestBody: {
            content: {
                'application/json': {
                    pageId: string;
                } | {
                    name: string;
                    username: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Page'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    pages___unlike: {
        requestBody: {
            content: {
                'application/json': {
                    pageId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    pages___update: {
        requestBody: {
            content: {
                'application/json': {
                    pageId: string;
                    title?: string;
                    name?: string;
                    summary?: string | null;
                    content?: {
                        [key: string]: unknown;
                    }[];
                    variables?: {
                        [key: string]: unknown;
                    }[];
                    script?: string;
                    eyeCatchingImageId?: string | null;
                    font?: 'serif' | 'sans-serif';
                    alignCenter?: boolean;
                    hideTitleWhenPinned?: boolean;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    ping: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        pong: number;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'pinned-users': {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserDetailed'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    promo___read: {
        requestBody: {
            content: {
                'application/json': {
                    noteId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'renote-mute___create': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'renote-mute___delete': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'renote-mute___list': {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['RenoteMuting'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'request-reset-password': {
        requestBody: {
            content: {
                'application/json': {
                    username: string;
                    email: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'reset-db': {
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'reset-password': {
        requestBody: {
            content: {
                'application/json': {
                    token: string;
                    password: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    retention: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        createdAt: string;
                        users: number;
                        data: {
                            [key: string]: number;
                        };
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'reversi___cancel-match': {
        requestBody: {
            content: {
                'application/json': {
                    userId?: string | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    reversi___games: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    my?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ReversiGameLite'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    reversi___invitations: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserLite'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    reversi___match: {
        requestBody: {
            content: {
                'application/json': {
                    userId?: string | null;
                    noIrregularRules?: boolean;
                    multiple?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ReversiGameDetailed'];
                };
            };
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'reversi___show-game': {
        requestBody: {
            content: {
                'application/json': {
                    gameId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['ReversiGameDetailed'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    reversi___surrender: {
        requestBody: {
            content: {
                'application/json': {
                    gameId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    reversi___verify: {
        requestBody: {
            content: {
                'application/json': {
                    gameId: string;
                    crc32: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        desynced: boolean;
                        game?: components['schemas']['ReversiGameDetailed'] | null;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    roles___list: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Role'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    roles___notes: {
        requestBody: {
            content: {
                'application/json': {
                    roleId: string;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    roles___show: {
        requestBody: {
            content: {
                'application/json': {
                    roleId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Role'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    roles___users: {
        requestBody: {
            content: {
                'application/json': {
                    roleId: string;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        user: components['schemas']['UserDetailed'];
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'server-info': {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        machine: string;
                        cpu: {
                            model: string;
                            cores: number;
                        };
                        mem: {
                            total: number;
                        };
                        fs: {
                            total: number;
                            used: number;
                        };
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    stats: {
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        notesCount: number;
                        originalNotesCount: number;
                        usersCount: number;
                        originalUsersCount: number;
                        instances: number;
                        driveUsageLocal: number;
                        driveUsageRemote: number;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    sw___register: {
        requestBody: {
            content: {
                'application/json': {
                    endpoint: string;
                    auth: string;
                    publickey: string;
                    sendReadMessage?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        state?: 'already-subscribed' | 'subscribed';
                        key: string | null;
                        userId: string;
                        endpoint: string;
                        sendReadMessage: boolean;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'sw___show-registration': {
        requestBody: {
            content: {
                'application/json': {
                    endpoint: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        userId: string;
                        endpoint: string;
                        sendReadMessage: boolean;
                    } | null;
                };
            };
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    sw___unregister: {
        requestBody: {
            content: {
                'application/json': {
                    endpoint: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'sw___update-registration': {
        requestBody: {
            content: {
                'application/json': {
                    endpoint: string;
                    sendReadMessage?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        userId: string;
                        endpoint: string;
                        sendReadMessage: boolean;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    test: {
        requestBody: {
            content: {
                'application/json': {
                    required: boolean;
                    string?: string;
                    default?: string;
                    nullableDefault?: string | null;
                    id?: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id?: string;
                        required: boolean;
                        string?: string;
                        default?: string;
                        nullableDefault: string | null;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    username___available: {
        requestBody: {
            content: {
                'application/json': {
                    username: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        available: boolean;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    offset?: number;
                    sort?: '+follower' | '-follower' | '+createdAt' | '-createdAt' | '+updatedAt' | '-updatedAt';
                    state?: 'all' | 'alive';
                    origin?: 'combined' | 'local' | 'remote';
                    hostname?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserDetailed'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___achievements: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Achievement'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___clips: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Clip'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'users___featured-notes': {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    untilId?: string;
                    userId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___flashs: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Flash'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___followers: {
        requestBody: {
            content: {
                'application/json': ({
                    userId: string;
                } | {
                    username: string;
                    host: string | null;
                }) & {
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Following'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___following: {
        requestBody: {
            content: {
                'application/json': ({
                    userId: string;
                } | {
                    username: string;
                    host: string | null;
                }) & {
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                    birthday?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Following'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___gallery___posts: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['GalleryPost'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'users___get-frequently-replied-users': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                    limit?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        user: components['schemas']['UserDetailed'];
                        weight: number;
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___lists___create: {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserList'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'users___lists___create-from-public': {
        requestBody: {
            content: {
                'application/json': {
                    name: string;
                    listId: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserList'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___lists___delete: {
        requestBody: {
            content: {
                'application/json': {
                    listId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___lists___favorite: {
        requestBody: {
            content: {
                'application/json': {
                    listId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'users___lists___get-memberships': {
        requestBody: {
            content: {
                'application/json': {
                    listId: string;
                    forPublic?: boolean;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        createdAt: string;
                        userId: string;
                        user: components['schemas']['UserLite'];
                        withReplies: boolean;
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___lists___list: {
        requestBody: {
            content: {
                'application/json': {
                    userId?: string;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserList'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___lists___pull: {
        requestBody: {
            content: {
                'application/json': {
                    listId: string;
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___lists___push: {
        requestBody: {
            content: {
                'application/json': {
                    listId: string;
                    userId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            429: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___lists___show: {
        requestBody: {
            content: {
                'application/json': {
                    listId: string;
                    forPublic?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserList'] & {
                        likedCount?: number;
                        isLiked?: boolean;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___lists___unfavorite: {
        requestBody: {
            content: {
                'application/json': {
                    listId: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___lists___update: {
        requestBody: {
            content: {
                'application/json': {
                    listId: string;
                    name?: string;
                    isPublic?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserList'];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'users___lists___update-membership': {
        requestBody: {
            content: {
                'application/json': {
                    listId: string;
                    userId: string;
                    withReplies?: boolean;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___notes: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                    withReplies?: boolean;
                    withRenotes?: boolean;
                    withChannelNotes?: boolean;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    allowPartial?: boolean;
                    withFiles?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Note'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___pages: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Page'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___reactions: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                    limit?: number;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['NoteReactionWithNote'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___recommendation: {
        requestBody: {
            content: {
                'application/json': {
                    limit?: number;
                    offset?: number;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserDetailed'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___relation: {
        requestBody: {
            content: {
                'application/json': {
                    userId: string | string[];
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        id: string;
                        isFollowing: boolean;
                        hasPendingFollowRequestFromYou: boolean;
                        hasPendingFollowRequestToYou: boolean;
                        isFollowed: boolean;
                        isBlocking: boolean;
                        isBlocked: boolean;
                        isMuted: boolean;
                        isRenoteMuted: boolean;
                    } | {
                        id: string;
                        isFollowing: boolean;
                        hasPendingFollowRequestFromYou: boolean;
                        hasPendingFollowRequestToYou: boolean;
                        isFollowed: boolean;
                        isBlocking: boolean;
                        isBlocked: boolean;
                        isMuted: boolean;
                        isRenoteMuted: boolean;
                    }[];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'users___report-abuse': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                    comment: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___search: {
        requestBody: {
            content: {
                'application/json': {
                    query: string;
                    offset?: number;
                    limit?: number;
                    origin?: 'local' | 'remote' | 'combined';
                    detail?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['User'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'users___search-by-username-and-host': {
        requestBody: {
            content: {
                'application/json': ({
                    username: string | null;
                } | {
                    host: string | null;
                }) & {
                    limit?: number;
                    detail?: boolean;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['User'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    users___show: {
        requestBody: {
            content: {
                'application/json': ({
                    userId: string;
                } | {
                    userIds: string[];
                } | {
                    username: string;
                }) & {
                    host?: string | null;
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['UserDetailed'] | components['schemas']['UserDetailed'][];
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'users___update-memo': {
        requestBody: {
            content: {
                'application/json': {
                    userId: string;
                    memo: string | null;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    v2___admin___emoji___list: {
        requestBody: {
            content: {
                'application/json': {
                    query?: {
                        updatedAtFrom?: string;
                        updatedAtTo?: string;
                        name?: string;
                        host?: string;
                        uri?: string;
                        publicUrl?: string;
                        originalUrl?: string;
                        type?: string;
                        aliases?: string;
                        category?: string;
                        license?: string;
                        isSensitive?: boolean;
                        localOnly?: boolean;
                        hostType?: 'local' | 'remote' | 'all';
                        roleIds?: string[];
                    } | null;
                    sinceId?: string;
                    untilId?: string;
                    sinceDate?: number;
                    untilDate?: number;
                    limit?: number;
                    page?: number;
                    sortKeys?: ('+id' | '-id' | '+updatedAt' | '-updatedAt' | '+name' | '-name' | '+host' | '-host' | '+uri' | '-uri' | '+publicUrl' | '-publicUrl' | '+type' | '-type' | '+aliases' | '-aliases' | '+category' | '-category' | '+license' | '-license' | '+isSensitive' | '-isSensitive' | '+localOnly' | '-localOnly' | '+roleIdsThatCanBeUsedThisEmojiAsReaction' | '-roleIdsThatCanBeUsedThisEmojiAsReaction')[];
                };
            };
        };
        responses: {
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': {
                        emojis: components['schemas']['EmojiDetailedAdmin'][];
                        count: number;
                        allCount: number;
                        allPages: number;
                    };
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
    'verify-email': {
        requestBody: {
            content: {
                'application/json': {
                    code: string;
                };
            };
        };
        responses: {
            204: {
                headers: {
                    [name: string]: unknown;
                };
            };
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            403: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            418: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    'application/json': components['schemas']['Error'];
                };
            };
        };
    };
}
//# sourceMappingURL=types.d.ts.map