import Pleroma from './pleroma.js';
import Mastodon from './mastodon.js';
import Friendica from './friendica.js';
import Firefish from './firefish.js';
import Gotosocial from './gotosocial.js';
import Pixelfed from './pixelfed.js';
export class NotImplementedError extends Error {
    constructor(err) {
        super(err);
        this.name = new.target.name;
        Object.setPrototypeOf(this, new.target.prototype);
    }
}
export class ArgumentError extends Error {
    constructor(err) {
        super(err);
        this.name = new.target.name;
        Object.setPrototypeOf(this, new.target.prototype);
    }
}
export class UnexpectedError extends Error {
    constructor(err) {
        super(err);
        this.name = new.target.name;
        Object.setPrototypeOf(this, new.target.prototype);
    }
}
export class NodeinfoError extends Error {
    constructor(err) {
        super(err);
        this.name = new.target.name;
        Object.setPrototypeOf(this, new.target.prototype);
    }
}
const generator = (sns, baseUrl, accessToken = null, userAgent = null) => {
    switch (sns) {
        case 'pleroma': {
            const pleroma = new Pleroma(baseUrl, accessToken, userAgent);
            return pleroma;
        }
        case 'friendica': {
            const friendica = new Friendica(baseUrl, accessToken, userAgent);
            return friendica;
        }
        case 'mastodon': {
            const mastodon = new Mastodon(baseUrl, accessToken, userAgent);
            return mastodon;
        }
        case 'firefish': {
            const firefish = new Firefish(baseUrl, accessToken, userAgent);
            return firefish;
        }
        case 'gotosocial': {
            const gotosocial = new Gotosocial(baseUrl, accessToken, userAgent);
            return gotosocial;
        }
        case 'pixelfed': {
            const pixelfed = new Pixelfed(baseUrl, accessToken, userAgent);
            return pixelfed;
        }
    }
};
export default generator;
